/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.xnap.commons.i18n.I18n;

public class DashboardElementsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(DashboardElementsLabelProvider.class);
    private final String[] ELEMENT_TYPES = new String[]{this.i18n.tr("Label"), this.i18n.tr("Line chart"), this.i18n.tr("Bar chart"), this.i18n.tr("Pie chart"), this.i18n.tr("Bar chart"), this.i18n.tr("Status chart"), this.i18n.tr("Status indicator"), this.i18n.tr("Dashboard"), this.i18n.tr("Network map"), this.i18n.tr("Custom"), this.i18n.tr("Geo map"), this.i18n.tr("Alarm viewer"), this.i18n.tr("Availability chart"), this.i18n.tr("Gauge"), this.i18n.tr("Web page"), this.i18n.tr("Bar chart for table DCI"), this.i18n.tr("Pie chart for table DCI"), this.i18n.tr("Bar chart for table DCI"), this.i18n.tr("Separator"), this.i18n.tr("Table value"), this.i18n.tr("Status map"), this.i18n.tr("DCI summary table"), this.i18n.tr("Syslog monitor"), this.i18n.tr("SNMP trap monitor"), this.i18n.tr("Event monitor"), this.i18n.tr("Service component map"), this.i18n.tr("Rack diagram"), this.i18n.tr("Object tools"), this.i18n.tr("Object query"), this.i18n.tr("Port view"), this.i18n.tr("Scripted bar chart"), this.i18n.tr("Scripted pie chart")};

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DashboardElement de = (DashboardElement)element;
        switch (columnIndex) {
            case 0: {
                try {
                    return this.ELEMENT_TYPES[de.getType()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return this.i18n.tr("<unknown>");
                }
            }
            case 1: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml((String)de.getLayout());
                    return Integer.toString(layout.horizontalSpan) + " / " + Integer.toString(layout.verticalSpan);
                }
                catch (Exception e) {
                    return "1 / 1";
                }
            }
            case 2: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml((String)de.getLayout());
                    if (layout.grabVerticalSpace) {
                        return this.i18n.tr("Fill");
                    }
                    if (layout.heightHint > 0) {
                        return Integer.toString(layout.heightHint);
                    }
                    return this.i18n.tr("Default");
                }
                catch (Exception e) {
                    return this.i18n.tr("Fill");
                }
            }
            case 3: {
                try {
                    DashboardElementConfig config = DashboardElementConfig.createFromXml((String)de.getData());
                    return config.getTitle();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }
        return null;
    }
}

