/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Sensor;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CommonSensorAttributesEditor
extends Composite {
    private I18n i18n = LocalizationHelper.getI18n(CommonSensorAttributesEditor.class);
    private LabeledText textMacAddress;
    private Combo comboDeviceClass;
    private LabeledText textVendor;
    private LabeledText textSerial;
    private LabeledText textDeviceAddress;
    private LabeledText textMetaType;
    private LabeledText textDescription;
    private ObjectSelector selectorProxyNode;
    private ModifyListener modifyListener = null;
    private int commProtocol;

    public CommonSensorAttributesEditor(Composite parent, int style, IWizard wizard) {
        this(parent, style, wizard, "", 0, "", "", "", "", "", 0L, 0);
    }

    public CommonSensorAttributesEditor(Composite parent, int style, IWizard wizard, String mac, int devClass, String vendor, String serial, String devAddress, String metaType, String desc, long proxyNodeId, int commProto) {
        super(parent, style);
        this.commProtocol = commProto;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.selectorProxyNode = new ObjectSelector((Composite)this, 0, true);
        this.selectorProxyNode.setLabel(this.i18n.tr("Proxy node"));
        this.selectorProxyNode.setObjectClass(Node.class);
        this.selectorProxyNode.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.selectorProxyNode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (proxyNodeId != 0L) {
            this.selectorProxyNode.setObjectId(proxyNodeId);
        }
        this.textMacAddress = new LabeledText((Composite)this, 0);
        this.textMacAddress.setLabel(this.i18n.tr("MAC address"));
        this.textMacAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textMacAddress.setEditable(commProto != 1);
        this.comboDeviceClass = WidgetHelper.createLabeledCombo((Composite)this, (int)2056, (String)this.i18n.tr("Device class"), (Object)"WidgetHelper::default_layout_data");
        this.comboDeviceClass.setItems(Sensor.DEV_CLASS_NAMES);
        this.comboDeviceClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textVendor = new LabeledText((Composite)this, 0);
        this.textVendor.setLabel(this.i18n.tr("Vendor"));
        this.textVendor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textSerial = new LabeledText((Composite)this, 0);
        this.textSerial.setLabel(this.i18n.tr("Serial number"));
        this.textSerial.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textDeviceAddress = new LabeledText((Composite)this, 0);
        this.textDeviceAddress.setLabel(this.i18n.tr("Device address"));
        this.textDeviceAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textDeviceAddress.setEnabled(commProto != 1);
        this.textMetaType = new LabeledText((Composite)this, 0);
        this.textMetaType.setLabel(this.i18n.tr("Meta type"));
        this.textMetaType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textDescription = new LabeledText((Composite)this, 0);
        this.textDescription.setLabel(this.i18n.tr("Description"));
        this.textDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.updateFields(mac, devClass, vendor, serial, devAddress, metaType, desc);
        if (wizard != null) {
            this.modifyListener = new /* Unavailable Anonymous Inner Class!! */;
            this.selectorProxyNode.addModifyListener(this.modifyListener);
            this.textMacAddress.getTextControl().addModifyListener(this.modifyListener);
            this.textDeviceAddress.getTextControl().addModifyListener(this.modifyListener);
        }
    }

    public void updateFields(String mac, int devClass, String vendor, String serial, String devAddress, String metaType, String desc) {
        this.textMacAddress.setText(mac);
        this.comboDeviceClass.select(devClass);
        this.textVendor.setText(vendor);
        this.textSerial.setText(serial);
        this.textDeviceAddress.setText(devAddress);
        this.textMetaType.setText(metaType);
        this.textDescription.setText(desc);
    }

    public boolean validate() {
        if (this.commProtocol == 1 && (this.textMacAddress.getText() == null || this.textDeviceAddress.getText().isEmpty())) {
            return false;
        }
        if (this.commProtocol != 0 && this.selectorProxyNode.getObjectId() == 0L) {
            return false;
        }
        return this.textMacAddress.getText().length() <= 0 || this.textMacAddress.getText().length() >= 12 && this.textMacAddress.getText().length() <= 23;
    }

    public MacAddress getMacAddress() {
        if (this.textMacAddress.getText().isEmpty()) {
            return null;
        }
        try {
            return MacAddress.parseMacAddress((String)this.textMacAddress.getText());
        }
        catch (MacAddressFormatException e) {
            return null;
        }
    }

    public int getDeviceClass() {
        return this.comboDeviceClass.getSelectionIndex();
    }

    public String getVendor() {
        return this.textVendor.getText();
    }

    public String getSerial() {
        return this.textSerial.getText();
    }

    public String getDeviceAddress() {
        return this.textDeviceAddress.getText();
    }

    public String getMetaType() {
        return this.textMetaType.getText();
    }

    public String getDescription() {
        return this.textDescription.getText();
    }

    public long getProxyNode() {
        return this.selectorProxyNode.getObjectId();
    }
}

