/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditSnmpUsmCredentialsDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EditSnmpUsmCredentialsDialog.class);
    private LabeledText name;
    private LabeledText authPasswd;
    private LabeledText privPasswd;
    private LabeledText comment;
    private Combo authMethod;
    private Combo privMethod;
    private SnmpUsmCredential credentials;

    public EditSnmpUsmCredentialsDialog(Shell parentShell, SnmpUsmCredential credentials) {
        super(parentShell);
        this.credentials = credentials;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.credentials == null ? this.i18n.tr("Add SNMP USM Credentials") : this.i18n.tr("Edit SNMP USM Credentials"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(this.i18n.tr("User name"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.authMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Authentication"), (Object)"WidgetHelper::default_layout_data");
        this.authMethod.add(this.i18n.tr("None"));
        this.authMethod.add("MD5");
        this.authMethod.add("SHA1");
        this.authMethod.add("SHA224");
        this.authMethod.add("SHA256");
        this.authMethod.add("SHA384");
        this.authMethod.add("SHA512");
        this.authMethod.select(2);
        this.privMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Encryption"), (Object)"WidgetHelper::default_layout_data");
        this.privMethod.add(this.i18n.tr("None"));
        this.privMethod.add("DES");
        this.privMethod.add("AES");
        this.privMethod.select(2);
        this.authPasswd = new LabeledText(dialogArea, 0);
        this.authPasswd.setLabel(this.i18n.tr("Authentication password"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.authPasswd.setLayoutData((Object)gd);
        this.privPasswd = new LabeledText(dialogArea, 0);
        this.privPasswd.setLabel(this.i18n.tr("Encryption password"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.privPasswd.setLayoutData((Object)gd);
        this.comment = new LabeledText(dialogArea, 0);
        this.comment.setLabel("Comments");
        this.comment.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.comment.setLayoutData((Object)gd);
        if (this.credentials != null) {
            this.name.setText(this.credentials.getName());
            this.authMethod.select(this.credentials.getAuthMethod());
            this.privMethod.select(this.credentials.getPrivMethod());
            this.authPasswd.setText(this.credentials.getAuthPassword());
            this.privPasswd.setText(this.credentials.getPrivPassword());
            this.comment.setText(this.credentials.getComment());
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.credentials == null) {
            this.credentials = new SnmpUsmCredential();
        }
        this.credentials.setName(this.name.getText().trim());
        this.credentials.setAuthMethod(this.authMethod.getSelectionIndex());
        this.credentials.setPrivMethod(this.privMethod.getSelectionIndex());
        this.credentials.setAuthPassword(this.authPasswd.getText());
        this.credentials.setPrivPassword(this.privPasswd.getText());
        this.credentials.setComment(this.comment.getText());
        super.okPressed();
    }

    public SnmpUsmCredential getCredentials() {
        return this.credentials;
    }
}

