/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.NetworkMapConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;

public class NetworkMap
extends PropertyPage {
    private NetworkMapConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Scale zoomLevelScale;
    private Spinner zoomLevelSpinner;
    private Button enableObjectDoubleClick;

    protected Control createContents(Composite parent) {
        this.config = (NetworkMapConfig)this.getElement().getAdapter(NetworkMapConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        Messages.get();
        this.objectSelector.setLabel(Messages.NetworkMap_NetworkMap);
        this.objectSelector.setObjectClass(org.netxms.client.objects.NetworkMap.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.NetworkMap_ZoomLevel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.zoomLevelScale = new Scale(dialogArea, 256);
        this.zoomLevelScale.setMinimum(10);
        this.zoomLevelScale.setMaximum(400);
        this.zoomLevelScale.setSelection(this.config.getZoomLevel());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoomLevelScale.setLayoutData((Object)gd);
        this.zoomLevelScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkMap.this.zoomLevelSpinner.setSelection(NetworkMap.this.zoomLevelScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.zoomLevelSpinner = new Spinner(dialogArea, 2048);
        this.zoomLevelSpinner.setMinimum(10);
        this.zoomLevelSpinner.setMaximum(400);
        this.zoomLevelSpinner.setSelection(this.config.getZoomLevel());
        this.zoomLevelSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkMap.this.zoomLevelScale.setSelection(NetworkMap.this.zoomLevelSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.enableObjectDoubleClick = new Button(dialogArea, 32);
        Messages.get();
        this.enableObjectDoubleClick.setText(Messages.NetworkMap_EnableDoubleClickAction);
        this.enableObjectDoubleClick.setSelection(this.config.isObjectDoubleClickEnabled());
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setZoomLevel(this.zoomLevelSpinner.getSelection());
        this.config.setObjectDoubleClickEnabled(this.enableObjectDoubleClick.getSelection());
        return true;
    }
}

