/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.UnknownObject;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.StatusIndicatorElementEditDialog;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class StatusIndicatorElements
extends PropertyPage {
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_OBJECT = 2;
    public static final int COLUMN_METRIC = 3;
    public static final int COLUMN_LABEL = 4;
    private StatusIndicatorConfig config;
    private List<StatusIndicatorConfig.StatusIndicatorElementConfig> elements;
    private ElementLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    protected Control createContents(Composite parent) {
        this.config = (StatusIndicatorConfig)this.getElement().getAdapter(StatusIndicatorConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        this.elements = new ArrayList<StatusIndicatorConfig.StatusIndicatorElementConfig>();
        StatusIndicatorConfig.StatusIndicatorElementConfig[] statusIndicatorElementConfigArray = this.config.getElements();
        int n = statusIndicatorElementConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = statusIndicatorElementConfigArray[n2];
            this.elements.add(new StatusIndicatorConfig.StatusIndicatorElementConfig(e));
            ++n2;
        }
        this.labelProvider = new ElementLabelProvider();
        this.labelProvider.resolveDciNames(this.elements);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.DataSources_Pos;
        stringArray[1] = "Type";
        stringArray[2] = "Object/Tag";
        Messages.get();
        stringArray[3] = Messages.DataSources_Parameter;
        Messages.get();
        stringArray[4] = Messages.DataSources_Label;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{40, 90, 200, 200, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput(this.elements);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonLayout.marginWidth = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.DataSources_Up);
        GridData gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.upButton.setLayoutData((Object)gd);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElements.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.DataSources_Down);
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.downButton.setLayoutData((Object)gd);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElements.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonLayout.marginWidth = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.DataSources_Add);
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElements.this.addElement();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        Messages.get();
        this.editButton.setText(Messages.DataSources_Modify);
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElements.this.editElement();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.DataSources_Delete);
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElements.this.deleteElements();
            }
        });
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StatusIndicatorElements.this.editElement();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = StatusIndicatorElements.this.viewer.getStructuredSelection();
                StatusIndicatorElements.this.editButton.setEnabled(selection.size() == 1);
                StatusIndicatorElements.this.deleteButton.setEnabled(selection.size() > 0);
                StatusIndicatorElements.this.upButton.setEnabled(selection.size() == 1);
                StatusIndicatorElements.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        return dialogArea;
    }

    private void addElement() {
        StatusIndicatorElementEditDialog dlg = new StatusIndicatorElementEditDialog(this.getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        StatusIndicatorConfig.StatusIndicatorElementConfig element = dlg.getElement();
        this.elements.add(element);
        if (element.getType() == 1) {
            this.labelProvider.addCacheEntry(element.getObjectId(), element.getDciId(), dlg.getCachedDciName());
        }
        this.viewer.refresh();
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        StatusIndicatorConfig.StatusIndicatorElementConfig element = (StatusIndicatorConfig.StatusIndicatorElementConfig)selection.getFirstElement();
        if (element == null) {
            return;
        }
        StatusIndicatorElementEditDialog dlg = new StatusIndicatorElementEditDialog(this.getShell(), element);
        if (dlg.open() == 0) {
            if (element.getType() == 1) {
                this.labelProvider.addCacheEntry(element.getObjectId(), element.getDciId(), dlg.getCachedDciName());
            }
            this.viewer.update((Object)element, null);
        }
    }

    private void deleteElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.elements.remove(o);
        }
        this.viewer.refresh();
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.elements, index - 1, index);
            this.viewer.refresh();
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = selection.getFirstElement())) < this.elements.size() - 1 && index >= 0) {
            Collections.swap(this.elements, index + 1, index);
            this.viewer.refresh();
        }
    }

    public boolean performOk() {
        this.config.setElements(this.elements.toArray(new StatusIndicatorConfig.StatusIndicatorElementConfig[this.elements.size()]));
        return true;
    }

    private class ElementLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NXCSession session = ConsoleSharedData.getSession();
        private Image imageScript = Activator.getImageDescriptor("icons/script.png").createImage();
        private Image imageDCI = Activator.getImageDescriptor("icons/dci.png").createImage();
        private WorkbenchLabelProvider objectLabelProvider = new WorkbenchLabelProvider();
        private Map<Long, String> dciNameCache = new HashMap<Long, String>();

        private ElementLabelProvider() {
        }

        public Image getImage(Object element) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = (StatusIndicatorConfig.StatusIndicatorElementConfig)element;
            switch (e.getType()) {
                case 1: {
                    return this.imageDCI;
                }
                case 0: {
                    AbstractObject object = this.session.findObjectById(e.getObjectId());
                    return this.objectLabelProvider.getImage(object != null ? object : new UnknownObject(e.getObjectId(), this.session));
                }
                case 3: {
                    return this.imageScript;
                }
            }
            return null;
        }

        public String getText(Object element) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = (StatusIndicatorConfig.StatusIndicatorElementConfig)element;
            switch (e.getType()) {
                case 1: {
                    String name;
                    String string = name = e.getDciId() != 0L ? this.dciNameCache.get(e.getDciId()) : e.getDciName();
                    if (name == null) {
                        Messages.get();
                        name = Messages.DciListLabelProvider_Unresolved;
                    }
                    return String.valueOf(e.getObjectId() == 0xFFFFFFFFL ? "<context>" : this.session.getObjectName(e.getObjectId())) + " / " + (e.getDciId() != 0L ? name : e.getDciName());
                }
                case 0: {
                    return e.getObjectId() == 0xFFFFFFFFL ? "<context>" : this.session.getObjectName(e.getObjectId());
                }
                case 3: {
                    return e.getTag();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(element) : null;
        }

        public String getColumnText(Object element, int columnIndex) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = (StatusIndicatorConfig.StatusIndicatorElementConfig)element;
            switch (columnIndex) {
                case 4: {
                    return e.getLabel();
                }
                case 3: {
                    if (e.getType() == 1) {
                        String string;
                        String name = this.dciNameCache.get(e.getDciId());
                        if (name != null) {
                            string = name;
                        } else {
                            Messages.get();
                            string = Messages.DciListLabelProvider_Unresolved;
                        }
                        return string;
                    }
                    if (e.getType() == 2) {
                        return e.getDciName();
                    }
                    return null;
                }
                case 2: {
                    if (e.getType() == 3) {
                        return e.getTag();
                    }
                    return e.getObjectId() == 0xFFFFFFFFL ? "<context>" : this.session.getObjectName(e.getObjectId());
                }
                case 0: {
                    return Integer.toString(StatusIndicatorElements.this.elements.indexOf(e) + 1);
                }
                case 1: {
                    switch (e.getType()) {
                        case 1: {
                            return "DCI";
                        }
                        case 2: {
                            return "DCI Template";
                        }
                        case 0: {
                            return "Object";
                        }
                        case 3: {
                            return "Script";
                        }
                    }
                    return null;
                }
            }
            return null;
        }

        public void dispose() {
            this.imageScript.dispose();
            this.imageDCI.dispose();
            this.objectLabelProvider.dispose();
        }

        public void resolveDciNames(final Collection<StatusIndicatorConfig.StatusIndicatorElementConfig> elementList) {
            Messages.get();
            new ConsoleJob(Messages.DciListLabelProvider_JobTitle, null, "org.netxms.ui.eclipse.dashboard"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final Map names = ElementLabelProvider.this.session.dciIdsToNames(elementList);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).ElementLabelProvider.this.dciNameCache = names;
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.DciListLabelProvider_JobError;
                }
            }.runInForeground();
        }

        public void addCacheEntry(long nodeId, long dciId, String name) {
            if (dciId != 0L) {
                this.dciNameCache.put(dciId, name);
            }
        }
    }
}

