/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actions;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.ui.eclipse.actions.TableRowAction;
import org.netxms.ui.eclipse.actions.ViewerProvider;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class ExportToCsvAction
extends TableRowAction {
    private IViewPart viewPart;

    private ExportToCsvAction(IViewPart viewPart, ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly) {
        String string;
        if (selectionOnly) {
            Messages.get();
            string = Messages.ExportToCsvAction_ExportToCsv;
        } else {
            Messages.get();
            string = Messages.ExportToCsvAction_ExportAllToCsv;
        }
        super(viewer, viewerProvider, selectionOnly, string, SharedIcons.CSV);
        this.viewPart = viewPart;
        this.setId(selectionOnly ? "org.netxms.ui.eclipse.popupActions.ExportToCSV" : "org.netxms.ui.eclipse.actions.ExportToCSV");
        if (viewPart == null || viewPart.getViewSite().getId().equals("org.netxms.ui.eclipse.objectview.view.tabbed_object_view")) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)viewPart.getSite().getService(IHandlerService.class);
        this.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.export_to_csv_" + (selectionOnly ? "selection" : "all"));
        handlerService.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    public ExportToCsvAction(IViewPart viewPart, ColumnViewer viewer, boolean selectionOnly) {
        this(viewPart, viewer, null, selectionOnly);
    }

    public ExportToCsvAction(IViewPart viewPart, ViewerProvider viewerProvider, boolean selectionOnly) {
        this(viewPart, null, viewerProvider, selectionOnly);
    }

    public void run() {
        FileDialog dlg = new FileDialog(this.viewPart.getSite().getShell(), 8192);
        dlg.setOverwrite(true);
        dlg.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dlg.setFilterNames(new String[]{"CSV files", "All files"});
        final String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final List<String[]> data = this.getRowsFromViewer(true);
        Messages.get();
        new ConsoleJob(String.format(Messages.ExportToCsvAction_SaveTo, fileName), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.console"){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
                for (String[] row : data) {
                    int i = 0;
                    while (i < row.length) {
                        if (i > 0) {
                            out.write(44);
                        }
                        out.write(34);
                        out.write(row[i].replace("\"", "\"\""));
                        out.write(34);
                        ++i;
                    }
                    out.newLine();
                }
                out.close();
            }

            @Override
            protected String getErrorMessage() {
                Messages.get();
                return Messages.ExportToCsvAction_SaveError;
            }
        }.start();
    }
}

