/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.LinkedList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.DiffMatchPatch;

public class DiffViewer
extends Composite {
    private StyledText textControl;
    private Color colorDeleted;
    private Color colorInserted;

    public DiffViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.textControl = new StyledText((Composite)this, 778);
        this.textControl.setFont(JFaceResources.getTextFont());
        this.colorDeleted = new Color((Device)this.getDisplay(), 253, 184, 192);
        this.colorInserted = new Color((Device)this.getDisplay(), 172, 242, 189);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DiffViewer.this.colorDeleted.dispose();
                DiffViewer.this.colorInserted.dispose();
            }
        });
    }

    public void setContent(LinkedList<DiffMatchPatch.Diff> diffs) {
        this.textControl.setText("");
        for (DiffMatchPatch.Diff diff : diffs) {
            StyleRange style = new StyleRange();
            style.start = this.textControl.getCharCount();
            style.length = diff.text.length();
            switch (diff.operation) {
                case DELETE: {
                    style.background = this.colorDeleted;
                    break;
                }
                case EQUAL: {
                    break;
                }
                case INSERT: {
                    style.background = this.colorInserted;
                }
            }
            this.textControl.append(diff.text);
            this.textControl.setStyleRange(style);
        }
    }
}

