/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.io.Serializable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.netxms.nxmc.base.widgets.events.HyperlinkEvent;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;

public abstract class AbstractHyperlink
extends Canvas {
    private boolean hasFocus;
    boolean paintFocus = true;
    private boolean armed;
    private ListenerList<IHyperlinkListener> listeners;
    protected int marginWidth = 1;
    protected int marginHeight = 1;

    public AbstractHyperlink(Composite parent, int style) {
        super(parent, style);
        this.addListener(1, (Listener & Serializable)e -> {
            if (e.character == '\r') {
                this.handleActivate(e);
            }
        });
        this.addPaintListener((PaintListener & Serializable)e -> this.paint(e));
        this.addListener(31, (Listener & Serializable)e -> {
            switch (e.detail) {
                case 4: {
                    e.doit = false;
                    return;
                }
            }
            e.doit = true;
        });
        Listener & Serializable listener = (Listener & Serializable)e -> {
            switch (e.type) {
                case 15: {
                    this.hasFocus = true;
                    this.handleEnter(e);
                    break;
                }
                case 16: {
                    this.hasFocus = false;
                    this.handleExit(e);
                    break;
                }
                case 14: {
                    this.handleActivate(e);
                    break;
                }
                case 6: {
                    this.handleEnter(e);
                    break;
                }
                case 7: {
                    this.handleExit(e);
                    break;
                }
                case 3: {
                    this.handleMouseDown(e);
                    break;
                }
                case 4: {
                    this.handleMouseUp(e);
                    break;
                }
                case 5: {
                    this.handleMouseMove(e);
                }
            }
        };
        this.addListener(6, (Listener)listener);
        this.addListener(7, (Listener)listener);
        this.addListener(3, (Listener)listener);
        this.addListener(4, (Listener)listener);
        this.addListener(5, (Listener)listener);
        this.addListener(15, (Listener)listener);
        this.addListener(16, (Listener)listener);
        this.setCursor(this.getDisplay().getSystemCursor(21));
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)listener);
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    protected void handleEnter(Event e) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        for (IHyperlinkListener listener : this.listeners) {
            listener.linkEntered(he);
        }
    }

    protected void handleExit(Event e) {
        this.armed = false;
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        for (IHyperlinkListener listener : this.listeners) {
            listener.linkExited(he);
        }
    }

    protected void handleActivate(Event e) {
        this.armed = false;
        if (this.listeners == null) {
            return;
        }
        this.setCursor(this.getDisplay().getSystemCursor(1));
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        for (IHyperlinkListener listener : this.listeners) {
            listener.linkActivated(he);
        }
        if (!this.isDisposed()) {
            this.setCursor(this.getDisplay().getSystemCursor(21));
            this.triggerAccessible();
        }
    }

    void triggerAccessible() {
        this.getAccessible().setFocus(-1);
    }

    public void setHref(Object href) {
        this.setData("href", href);
    }

    public Object getHref() {
        return this.getData("href");
    }

    public String getText() {
        return this.getToolTipText();
    }

    protected abstract void paintHyperlink(GC var1);

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        this.paintHyperlink(gc);
        if (this.paintFocus && this.hasFocus) {
            Rectangle carea = this.getClientArea();
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, carea.width, carea.height);
        }
    }

    private void handleMouseDown(Event e) {
        if (e.button != 1) {
            return;
        }
        this.armed = true;
    }

    private void handleMouseUp(Event e) {
        if (!this.armed || e.button != 1) {
            return;
        }
        Point size = this.getSize();
        if (e.x < 0) {
            return;
        }
        if (e.y < 0) {
            return;
        }
        if (e.x >= size.x) {
            return;
        }
        if (e.y >= size.y) {
            return;
        }
        this.handleActivate(e);
    }

    private void handleMouseMove(Event e) {
        if (this.armed) {
            Point size = this.getSize();
            this.armed = e.x >= 0 && e.y >= 0 && e.x < size.x && e.y < size.y;
        }
    }

    public void setEnabled(boolean enabled) {
        boolean needsRedraw = enabled != this.getEnabled();
        super.setEnabled(enabled);
        if (needsRedraw) {
            this.redraw();
        }
    }
}

