/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.actions.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.ServerAction;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.views.helpers.DecoratingActionLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ActionLabelProvider
extends DecoratingActionLabelProvider
implements ITableLabelProvider {
    private static final I18n i18n = LocalizationHelper.getI18n(ActionLabelProvider.class);
    public static final String[] ACTION_TYPE = new String[]{i18n.tr("Local Command"), i18n.tr("Agent Command"), i18n.tr("SSH Command"), i18n.tr("Notification"), i18n.tr("Forward Event"), i18n.tr("NXSL Script")};

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getImage(element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ServerAction action = (ServerAction)element;
        switch (columnIndex) {
            case 0: {
                return action.getName();
            }
            case 1: {
                try {
                    return ACTION_TYPE[action.getType().getValue()];
                }
                catch (IndexOutOfBoundsException e) {
                    return i18n.tr("Unknown");
                }
            }
            case 2: {
                return action.getRecipientAddress();
            }
            case 3: {
                return action.getEmailSubject();
            }
            case 4: {
                return action.getData();
            }
            case 5: {
                return action.getChannelName();
            }
        }
        return null;
    }
}

