/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.DashboardElementPropertiesManager;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.AbstractChart;
import org.netxms.nxmc.modules.dashboards.propertypages.AlarmViewer;
import org.netxms.nxmc.modules.dashboards.propertypages.CustomWidget;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.DataSources;
import org.netxms.nxmc.modules.dashboards.propertypages.DciSummaryTable;
import org.netxms.nxmc.modules.dashboards.propertypages.EmbeddedDashboard;
import org.netxms.nxmc.modules.dashboards.propertypages.EventMonitor;
import org.netxms.nxmc.modules.dashboards.propertypages.Gauge;
import org.netxms.nxmc.modules.dashboards.propertypages.GeoMap;
import org.netxms.nxmc.modules.dashboards.propertypages.LabelProperties;
import org.netxms.nxmc.modules.dashboards.propertypages.Layout;
import org.netxms.nxmc.modules.dashboards.propertypages.NetworkMap;
import org.netxms.nxmc.modules.dashboards.propertypages.ObjectDetailsPropertyList;
import org.netxms.nxmc.modules.dashboards.propertypages.ObjectDetailsQuery;
import org.netxms.nxmc.modules.dashboards.propertypages.ObjectStatusChart;
import org.netxms.nxmc.modules.dashboards.propertypages.ObjectTools;
import org.netxms.nxmc.modules.dashboards.propertypages.PortView;
import org.netxms.nxmc.modules.dashboards.propertypages.RackDiagram;
import org.netxms.nxmc.modules.dashboards.propertypages.ScriptedChart;
import org.netxms.nxmc.modules.dashboards.propertypages.SeparatorProperties;
import org.netxms.nxmc.modules.dashboards.propertypages.ServiceComponents;
import org.netxms.nxmc.modules.dashboards.propertypages.SnmpTrapMonitor;
import org.netxms.nxmc.modules.dashboards.propertypages.StatusIndicator;
import org.netxms.nxmc.modules.dashboards.propertypages.StatusIndicatorElements;
import org.netxms.nxmc.modules.dashboards.propertypages.StatusIndicatorScript;
import org.netxms.nxmc.modules.dashboards.propertypages.StatusMap;
import org.netxms.nxmc.modules.dashboards.propertypages.SyslogMonitor;
import org.netxms.nxmc.modules.dashboards.propertypages.TableComparisonChart;
import org.netxms.nxmc.modules.dashboards.propertypages.TableDataSource;
import org.netxms.nxmc.modules.dashboards.propertypages.TableValue;
import org.netxms.nxmc.modules.dashboards.propertypages.WebPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class DashboardElementPropertiesManager {
    private static final Logger logger = LoggerFactory.getLogger(DashboardElementPropertiesManager.class);
    private static final I18n i18n = LocalizationHelper.getI18n(DashboardElementPropertiesManager.class);
    private static Set<Class<? extends DashboardElementPropertyPage>> pageClasses = new HashSet();

    public static boolean openElementPropertiesDialog(DashboardElementConfig elementConfig, Shell shell) {
        ArrayList<DashboardElementPropertyPage> pages = new ArrayList<DashboardElementPropertyPage>(pageClasses.size());
        for (Object c : pageClasses) {
            try {
                DashboardElementPropertyPage p = (DashboardElementPropertyPage)((Class)c).getConstructor(DashboardElementConfig.class).newInstance(elementConfig);
                if (!p.isVisible()) continue;
                pages.add(p);
            }
            catch (Exception e) {
                logger.error("Error instantiating dashboard element property page", (Throwable)e);
            }
        }
        pages.sort((Comparator<DashboardElementPropertyPage>)new /* Unavailable Anonymous Inner Class!! */);
        PreferenceManager pm = new PreferenceManager();
        for (DashboardElementPropertyPage p : pages) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode(p.getId(), (IPreferencePage)p));
        }
        2 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    static {
        pageClasses.add(AbstractChart.class);
        pageClasses.add(AlarmViewer.class);
        pageClasses.add(CustomWidget.class);
        pageClasses.add(DataSources.class);
        pageClasses.add(DciSummaryTable.class);
        pageClasses.add(EmbeddedDashboard.class);
        pageClasses.add(EventMonitor.class);
        pageClasses.add(Gauge.class);
        pageClasses.add(GeoMap.class);
        pageClasses.add(LabelProperties.class);
        pageClasses.add(Layout.class);
        pageClasses.add(NetworkMap.class);
        pageClasses.add(ObjectDetailsPropertyList.class);
        pageClasses.add(ObjectDetailsQuery.class);
        pageClasses.add(ObjectStatusChart.class);
        pageClasses.add(ObjectTools.class);
        pageClasses.add(PortView.class);
        pageClasses.add(RackDiagram.class);
        pageClasses.add(ScriptedChart.class);
        pageClasses.add(SeparatorProperties.class);
        pageClasses.add(ServiceComponents.class);
        pageClasses.add(SnmpTrapMonitor.class);
        pageClasses.add(StatusIndicator.class);
        pageClasses.add(StatusIndicatorElements.class);
        pageClasses.add(StatusIndicatorScript.class);
        pageClasses.add(StatusMap.class);
        pageClasses.add(SyslogMonitor.class);
        pageClasses.add(TableComparisonChart.class);
        pageClasses.add(TableDataSource.class);
        pageClasses.add(TableValue.class);
        pageClasses.add(WebPage.class);
    }
}

