/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import org.eclipse.swt.graphics.RGB;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.tools.ColorConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelConfig
extends DashboardElementConfig {
    private static final Logger logger = LoggerFactory.getLogger(LabelConfig.class);
    @Element(required=false)
    private String foreground = null;
    @Element(required=false)
    private String background = null;

    public static LabelConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        LabelConfig config = (LabelConfig)serializer.read(LabelConfig.class, xml);
        if (config.foreground != null && config.foreground.startsWith("0x")) {
            try {
                config.setTitleForeground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.foreground.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                logger.warn("Cannot convert label foreground color \"" + config.foreground + "\"", (Throwable)e);
            }
            config.foreground = null;
        }
        if (config.background != null && config.background.startsWith("0x")) {
            try {
                config.setTitleBackground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.background.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                logger.warn("Cannot convert label background color \"" + config.background + "\"", (Throwable)e);
            }
            config.background = null;
        }
        return config;
    }
}

