/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.widgets;

import java.util.Collection;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.CompositeWithMessageArea;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class ScriptEditor
extends CompositeWithMessageArea {
    private static final I18n i18n = LocalizationHelper.getI18n(ScriptEditor.class);
    private Composite content;
    private Text editor;
    private String hintText;
    private Composite hintArea;
    private Text hintTextControl = null;
    private Label hintsExpandButton = null;
    private Button compileButton;

    public ScriptEditor(Composite parent, int style, int editorStyle) {
        this(parent, style, editorStyle, true, null, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers) {
        this(parent, style, editorStyle, showLineNumbers, null, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers, String hints) {
        this(parent, style, editorStyle, showLineNumbers, hints, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers, boolean showCompileButton) {
        this(parent, style, editorStyle, showLineNumbers, null, showCompileButton);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers, String hints, boolean showCompileButton) {
        super(parent, style);
        this.hintText = hints;
        this.content = new Composite((Composite)this, 0);
        this.setContent(this.content);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.content.setLayout((Layout)layout);
        if (hints != null) {
            this.createHintsArea();
        }
        this.editor = new Text(this.content, editorStyle | 2);
        this.editor.setData("org.eclipse.rap.rwt.customVariant", (Object)"monospace");
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        if (showCompileButton) {
            Image compileImage = ResourceManager.getImage((String)"icons/compile.gif");
            this.compileButton = new Button(this.content, 0x800008);
            this.compileButton.setToolTipText("Compile script");
            this.compileButton.setImage(compileImage);
            this.compileButton.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            GridData gd = new GridData();
            gd.exclude = true;
            this.compileButton.setLayoutData((Object)gd);
            this.editor.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
            this.compileButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.compileButton.setSize(this.compileButton.computeSize(-1, -1));
            this.positionCompileButton();
        }
    }

    private void positionCompileButton() {
        this.compileButton.moveAbove(null);
        Point location = this.editor.getLocation();
        int editorWidth = this.editor.getSize().x;
        ScrollBar sb = this.editor.getVerticalBar();
        if (sb != null) {
            editorWidth -= sb.getSize().x;
        }
        this.compileButton.setLocation(location.x + editorWidth - this.compileButton.getSize().x - 3, location.y + 3);
    }

    private void createHintsArea() {
        this.hintArea = new Composite(this.content, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.hintArea.setLayout((Layout)layout);
        this.hintArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hintArea.setBackground(ThemeEngine.getBackgroundColor((String)"MessageBar"));
        CLabel hintsTitle = new CLabel(this.hintArea, 0);
        hintsTitle.setBackground(this.hintArea.getBackground());
        hintsTitle.setForeground(ThemeEngine.getForegroundColor((String)"MessageBar"));
        hintsTitle.setImage(SharedIcons.IMG_INFORMATION);
        hintsTitle.setText(i18n.tr("Hints"));
        hintsTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        hintsTitle.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.hintsExpandButton = new Label(this.hintArea, 0);
        this.hintsExpandButton.setBackground(this.hintArea.getBackground());
        this.hintsExpandButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        this.hintsExpandButton.setToolTipText(i18n.tr("Hide message"));
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.hintsExpandButton.setLayoutData((Object)gd);
        this.hintsExpandButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label(this.content, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public Text getTextWidget() {
        return this.editor;
    }

    public void setText(String text) {
        this.editor.setText(text != null ? text : "");
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setFunctions(Set<String> functions) {
    }

    public void addFunctions(Collection<String> fc) {
    }

    public void setVariables(Set<String> variables) {
    }

    public void addVariables(Collection<String> vc) {
    }

    public void setConstants(Set<String> constants) {
    }

    public void addConstants(Collection<String> cc) {
    }

    public String[] getFunctions() {
        return new String[0];
    }

    public String[] getVariables() {
        return new String[0];
    }

    public String[] getConstants() {
        return new String[0];
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = this.editor.computeSize(wHint, hHint, changed);
        p.y += 4;
        return p;
    }

    public void showLineNumbers(boolean show) {
    }

    private void toggleHints() {
        if (this.hintTextControl != null) {
            this.hintTextControl.dispose();
            this.hintTextControl = null;
            this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        } else {
            this.hintTextControl = new Text(this.hintArea, 66);
            this.hintTextControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.hintTextControl.setEditable(false);
            this.hintTextControl.setText(this.hintText);
            this.hintTextControl.setBackground(ThemeEngine.getBackgroundColor((String)"MessageBar"));
            this.hintTextControl.setForeground(ThemeEngine.getForegroundColor((String)"MessageBar"));
            this.hintsExpandButton.setImage(SharedIcons.IMG_COLLAPSE);
        }
        this.layout(true, true);
    }

    public void compileScript() {
        String source = this.getText();
        this.editor.setEditable(false);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void highlightErrorLine(int lineNumber) {
    }

    public void clearHighlighting() {
    }

    public int getLineCount() {
        String text = this.editor.getText();
        if (text.isEmpty()) {
            return 0;
        }
        return text.split(this.editor.getLineDelimiter()).length + 1;
    }

    public int getCurrentLine() {
        int i = this.editor.getCaretPosition();
        String text = this.editor.getText().substring(0, i);
        if (text.isEmpty()) {
            return 0;
        }
        return text.split(this.editor.getLineDelimiter()).length + 1;
    }

    public void setCaretToLine(int lineNumber) {
    }
}

