/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ClusterNetworkEditDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.NetworkListComparator;
import org.netxms.nxmc.modules.objects.propertypages.helpers.NetworkListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ClusterNetworks
extends ObjectPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(ClusterNetworks.class);
    public static final int COLUMN_ADDRESS = 0;
    public static final int COLUMN_NETMASK = 1;
    private Cluster cluster;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<InetAddressEx> networks = null;
    private boolean isModified = false;

    public ClusterNetworks(AbstractObject object) {
        super(i18n.tr("Cluster Networks"), object);
    }

    public String getId() {
        return "clusterNetworks";
    }

    public int getPriority() {
        return 15;
    }

    public boolean isVisible() {
        return this.object instanceof Cluster;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.cluster = (Cluster)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("Address"), i18n.tr("Mask")};
        int[] columnWidths = new int[]{150, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NetworkListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NetworkListComparator());
        this.networks = new ArrayList(this.cluster.getSyncNetworks().size());
        for (InetAddressEx n : this.cluster.getSyncNetworks()) {
            this.networks.add(new InetAddressEx(n));
        }
        this.viewer.setInput((Object)this.networks.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addNetwork() {
        ClusterNetworkEditDialog dlg = new ClusterNetworkEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            InetAddressEx n = new InetAddressEx(dlg.getAddress(), dlg.getMask());
            this.networks.add(n);
            this.viewer.setInput((Object)this.networks.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)n));
            this.isModified = true;
        }
    }

    private void editNetwork() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InetAddressEx n = (InetAddressEx)selection.getFirstElement();
        ClusterNetworkEditDialog dlg = new ClusterNetworkEditDialog(this.getShell(), n.getAddress(), n.maskFromBits());
        if (dlg.open() == 0) {
            n.setAddress(dlg.getAddress());
            n.setMask(InetAddressEx.bitsInMask((InetAddress)dlg.getMask()));
            this.viewer.update((Object)n, null);
            this.isModified = true;
        }
    }

    private void deleteNetwork() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        for (Object o : selection.toList()) {
            this.networks.remove(o);
        }
        this.viewer.setInput((Object)this.networks.toArray());
        this.isModified = true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setNetworkList(this.networks);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

