/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ObjectToolsGeneral
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectToolsGeneral.class);
    private static final Logger logger = LoggerFactory.getLogger(ObjectToolsGeneral.class);
    private ObjectToolDetails objectTool;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textData;
    private LabeledSpinner maxFileSize;
    private LabeledText textParameter;
    private LabeledText textRegexp;
    private Button checkShowOutput;
    private Button checkSuppressSuccessMessage;
    private Button checkSetupTCPTunnel;
    private Spinner remotePort;
    private Button checkConfirmation;
    private LabeledText textConfirmation;
    private Button checkDisable;
    private Button checkRunInContainerContext;
    private Button checkFollow;
    private Button checkCommand;
    private LabeledText textCommandName;
    private LabeledText textCommandShortName;
    private Button radioIndexOID;
    private Button radioIndexValue;
    private Label iconLabel;
    private Image icon;

    public ObjectToolsGeneral(ObjectToolDetails toolDetails) {
        super("General");
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(i18n.tr("Name"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
        this.textName.setText(this.objectTool.getName());
        this.createIcon();
        this.createIconSelector(dialogArea);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel(i18n.tr("Description"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.textDescription.setLayoutData((Object)gd);
        this.textDescription.setText(this.objectTool.getDescription());
        this.textData = new LabeledText(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.textData.setLayoutData((Object)gd);
        this.textData.setText(this.objectTool.getData());
        switch (this.objectTool.getToolType()) {
            case 0: {
                this.textData.setLabel(i18n.tr("Operation"));
                break;
            }
            case 5: {
                this.textData.setLabel(i18n.tr("Command"));
                this.createTCPTunnelGroup(dialogArea);
                this.createOutputGroup(dialogArea);
                break;
            }
            case 6: 
            case 10: {
                this.textData.setLabel(i18n.tr("Command"));
                this.createOutputGroup(dialogArea);
                break;
            }
            case 8: {
                this.textData.setLabel(i18n.tr("Script"));
                this.createOutputGroup(dialogArea);
                break;
            }
            case 1: {
                this.textData.setLabel(i18n.tr("Agent's command"));
                this.createOutputGroup(dialogArea);
                break;
            }
            case 4: {
                this.textData.setLabel(i18n.tr("URL"));
                this.createTCPTunnelGroup(dialogArea);
                break;
            }
            case 7: {
                String[] parameters = this.objectTool.getData().split("\u007f");
                this.textData.setLabel(i18n.tr("Remote file name"));
                this.textData.setText(parameters.length > 0 ? parameters[0] : "");
                Group fileOptionsGoup = new Group(dialogArea, 0);
                fileOptionsGoup.setText(i18n.tr("File Options"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                fileOptionsGoup.setLayoutData((Object)gd);
                GridLayout fileGroupLayout = new GridLayout();
                fileGroupLayout.verticalSpacing = 4;
                fileGroupLayout.numColumns = 1;
                fileOptionsGoup.setLayout((Layout)fileGroupLayout);
                this.maxFileSize = new LabeledSpinner((Composite)fileOptionsGoup, 0);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.maxFileSize.setLayoutData((Object)gd);
                this.maxFileSize.setLabel(i18n.tr("Limit initial download size (in bytes, 0 for unlimited)"));
                this.maxFileSize.setRange(0, Integer.MAX_VALUE);
                try {
                    this.maxFileSize.setSelection(parameters.length > 1 ? Integer.parseInt(parameters[1]) : 0);
                }
                catch (NumberFormatException e) {
                    this.maxFileSize.setSelection(0);
                }
                this.checkFollow = new Button((Composite)fileOptionsGoup, 32);
                this.checkFollow.setText(i18n.tr("Follow file changes"));
                if (parameters.length <= 2) break;
                this.checkFollow.setSelection(parameters[2].equals("true"));
                break;
            }
            case 2: {
                this.textData.setLabel(i18n.tr("Title"));
                Group snmpOptGroup = new Group(dialogArea, 0);
                snmpOptGroup.setText(i18n.tr("SNMP List Options"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                snmpOptGroup.setLayoutData((Object)gd);
                layout = new GridLayout();
                snmpOptGroup.setLayout((Layout)layout);
                new Label((Composite)snmpOptGroup, 0).setText(i18n.tr("Use as index for second and subsequent columns:"));
                this.radioIndexOID = new Button((Composite)snmpOptGroup, 16);
                this.radioIndexOID.setText(i18n.tr("&OID suffix of first column"));
                this.radioIndexOID.setSelection((this.objectTool.getFlags() & 0x10) == 0);
                this.radioIndexValue = new Button((Composite)snmpOptGroup, 16);
                this.radioIndexValue.setText(i18n.tr("&Value of first column"));
                this.radioIndexValue.setSelection(!this.radioIndexOID.getSelection());
                break;
            }
            case 3: {
                this.textData.setLabel(i18n.tr("Title"));
                String[] listParts = this.objectTool.getData().split("\u007f");
                this.textData.setText(listParts.length > 0 ? listParts[0] : "");
                this.textParameter = new LabeledText(dialogArea, 0);
                this.textParameter.setLabel(i18n.tr("Parameter"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                this.textParameter.setLayoutData((Object)gd);
                this.textParameter.setText(listParts.length > 1 ? listParts[1] : "");
                this.textRegexp = new LabeledText(dialogArea, 0);
                this.textRegexp.setLabel(i18n.tr("Regular expression"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                this.textRegexp.setLayoutData((Object)gd);
                this.textRegexp.setText(listParts.length > 2 ? listParts[2] : "");
                break;
            }
            case 9: {
                this.textData.setLabel(i18n.tr("Title"));
                String[] tableParts = this.objectTool.getData().split("\u007f");
                this.textData.setText(tableParts.length > 0 ? tableParts[0] : "");
                this.textParameter = new LabeledText(dialogArea, 0);
                this.textParameter.setLabel(i18n.tr("Parameter"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                this.textParameter.setLayoutData((Object)gd);
                this.textParameter.setText(tableParts.length > 1 ? tableParts[1] : "");
            }
        }
        Group confirmationGroup = new Group(dialogArea, 0);
        confirmationGroup.setText(i18n.tr("Confirmation"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        confirmationGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        confirmationGroup.setLayout((Layout)layout);
        this.checkConfirmation = new Button((Composite)confirmationGroup, 32);
        this.checkConfirmation.setText(i18n.tr("This tool requires confirmation before execution"));
        this.checkConfirmation.setSelection((this.objectTool.getFlags() & 1) != 0);
        this.checkConfirmation.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textConfirmation = new LabeledText((Composite)confirmationGroup, 0);
        this.textConfirmation.setLabel(i18n.tr("Confirmation message"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textConfirmation.setLayoutData((Object)gd);
        this.textConfirmation.setText(this.objectTool.getConfirmationText());
        this.textConfirmation.setEnabled(this.checkConfirmation.getSelection());
        Group commandGroup = new Group(dialogArea, 0);
        commandGroup.setText(i18n.tr("Show in commands"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        commandGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        commandGroup.setLayout((Layout)layout);
        this.checkCommand = new Button((Composite)commandGroup, 32);
        this.checkCommand.setText(i18n.tr("Show this tool in node commands"));
        this.checkCommand.setSelection((this.objectTool.getFlags() & 8) != 0);
        this.checkCommand.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkCommand.setLayoutData((Object)gd);
        this.textCommandName = new LabeledText((Composite)commandGroup, 0);
        this.textCommandName.setLabel(i18n.tr("Command name"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textCommandName.setLayoutData((Object)gd);
        this.textCommandName.setText(this.objectTool.getCommandName());
        this.textCommandName.setEnabled(this.checkCommand.getSelection());
        this.textCommandShortName = new LabeledText((Composite)commandGroup, 0);
        this.textCommandShortName.setLabel(i18n.tr("Command short name"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textCommandShortName.setLayoutData((Object)gd);
        this.textCommandShortName.setText(this.objectTool.getCommandShortName());
        this.textCommandShortName.setEnabled(this.checkCommand.getSelection());
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Other options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        optionsGroup.setLayout((Layout)new GridLayout());
        this.checkDisable = new Button((Composite)optionsGroup, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkDisable.setLayoutData((Object)gd);
        this.checkDisable.setText(i18n.tr("&Disabled"));
        this.checkDisable.setSelection(!this.objectTool.isEnabled());
        if (this.objectTool.getToolType() == 5 || this.objectTool.getToolType() == 6 || this.objectTool.getToolType() == 8 || this.objectTool.getToolType() == 4) {
            this.checkRunInContainerContext = new Button((Composite)optionsGroup, 32);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.checkDisable.setLayoutData((Object)gd);
            this.checkRunInContainerContext.setText(i18n.tr("Run in &container context"));
            this.checkRunInContainerContext.setSelection(this.objectTool.isRunInContainerContext());
        }
        return dialogArea;
    }

    private void createOutputGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        outputGroup.setText(i18n.tr("Execution options"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        outputGroup.setLayoutData((Object)gd);
        outputGroup.setLayout((Layout)new GridLayout());
        this.checkShowOutput = new Button((Composite)outputGroup, 32);
        this.checkShowOutput.setText(i18n.tr("Command generates output"));
        this.checkShowOutput.setSelection((this.objectTool.getFlags() & 2) != 0);
        this.checkSuppressSuccessMessage = new Button((Composite)outputGroup, 32);
        this.checkSuppressSuccessMessage.setText("&Suppress notification of successful execution");
        this.checkSuppressSuccessMessage.setSelection((this.objectTool.getFlags() & 0x40) != 0);
    }

    private void createTCPTunnelGroup(Composite parent) {
        Group tcpTunnelGroup = new Group(parent, 0);
        tcpTunnelGroup.setText(i18n.tr("TCP tunnel"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        tcpTunnelGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        tcpTunnelGroup.setLayout((Layout)layout);
        this.checkSetupTCPTunnel = new Button((Composite)tcpTunnelGroup, 32);
        this.checkSetupTCPTunnel.setText(i18n.tr("Setup &TCP tunnel to remote port"));
        this.checkSetupTCPTunnel.setSelection((this.objectTool.getFlags() & 0x80) != 0);
        this.checkSetupTCPTunnel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.checkSetupTCPTunnel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.remotePort = new Spinner((Composite)tcpTunnelGroup, 2048);
        this.remotePort.setMinimum(1);
        this.remotePort.setMaximum(65535);
        this.remotePort.setSelection(this.objectTool.getRemotePort());
        this.remotePort.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.remotePort.setEnabled(this.checkSetupTCPTunnel.getSelection());
    }

    private void createIcon() {
        byte[] imageBytes;
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        if ((imageBytes = this.objectTool.getImageData()) == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(imageBytes);
        try {
            ImageDescriptor d = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)input));
            this.icon = d.createImage();
        }
        catch (Exception e) {
            logger.error("Exception in ObjectToolsGeneral.createIcon()", (Throwable)e);
        }
    }

    private void createIconSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(i18n.tr("Icon"));
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        this.iconLabel = new Label((Composite)group, 0);
        this.iconLabel.setImage(this.icon != null ? this.icon : SharedIcons.IMG_EMPTY);
        this.iconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        Label dummy = new Label((Composite)group, 0);
        GridData gd = new GridData();
        gd.widthHint = 8;
        dummy.setLayoutData((Object)gd);
        Button link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_FIND);
        link.setToolTipText(i18n.tr("Select..."));
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_CLEAR);
        link.setToolTipText(i18n.tr("Clear"));
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        link.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectIcon() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        WidgetHelper.setFileDialogFilterNames((FileDialog)dlg, (String[])new String[]{i18n.tr("Image Files"), i18n.tr("All Files")});
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)dlg, (String[])new String[]{"*.gif;*.jpg;*.png", "*.*"});
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        try {
            Image image = new Image((Device)this.getShell().getDisplay(), (InputStream)new FileInputStream(new File(fileName)));
            if (image.getImageData().width <= 16 && image.getImageData().height <= 16) {
                if (this.icon != null) {
                    this.icon.dispose();
                }
                this.icon = image;
                this.iconLabel.setImage(this.icon);
            } else {
                image.dispose();
                MessageDialogHelper.openError((Shell)this.getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Select image file is too large"));
            }
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)i18n.tr("Error"), (String)String.format(i18n.tr("Cannot load image file: %s"), e.getLocalizedMessage()));
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.objectTool.setName(this.textName.getText());
        this.objectTool.setDescription(this.textDescription.getText());
        switch (this.objectTool.getToolType()) {
            case 3: {
                this.objectTool.setData(this.textData.getText() + "\u007f" + this.textParameter.getText() + "\u007f" + this.textRegexp.getText());
                break;
            }
            case 9: {
                this.objectTool.setData(this.textData.getText() + "\u007f" + this.textParameter.getText());
                break;
            }
            case 7: {
                this.objectTool.setData(this.textData.getText() + "\u007f" + this.maxFileSize.getSelection() + "\u007f" + this.checkFollow.getSelection());
                break;
            }
            default: {
                this.objectTool.setData(this.textData.getText());
            }
        }
        if (this.checkConfirmation.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 1);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFFE);
        }
        this.objectTool.setConfirmationText(this.textConfirmation.getText());
        if (this.checkCommand.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 8);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFF7);
        }
        this.objectTool.setCommandName(this.textCommandName.getText());
        this.objectTool.setCommandShortName(this.textCommandShortName.getText());
        if (this.checkDisable.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 4);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFFB);
        }
        if (this.checkRunInContainerContext != null && this.checkRunInContainerContext.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 0x20);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFDF);
        }
        if (this.objectTool.getToolType() == 2) {
            if (this.radioIndexValue.getSelection()) {
                this.objectTool.setFlags(this.objectTool.getFlags() | 0x10);
            } else {
                this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFEF);
            }
        }
        if (this.checkShowOutput != null && this.checkShowOutput.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 2);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFFD);
        }
        if (this.checkSuppressSuccessMessage != null && this.checkSuppressSuccessMessage.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 0x40);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFBF);
        }
        if (this.checkSetupTCPTunnel != null && this.checkSetupTCPTunnel.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 0x80);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFF7F);
        }
        if (this.remotePort != null) {
            this.objectTool.setRemotePort(this.remotePort.getSelection());
        }
        if (this.icon != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{this.icon.getImageData()};
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            loader.save((OutputStream)stream, 5);
            this.objectTool.setImageData(stream.toByteArray());
        } else {
            this.objectTool.setImageData(null);
        }
        return true;
    }
}

