/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectPollType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.StyleRange;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.views.ObjectPollerView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ObjectPollerView
extends AdHocObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectPollerView.class);
    private static final String[] POLL_NAME = new String[]{"", i18n.tr("Status Poll"), i18n.tr("Configuration Poll (Full)"), i18n.tr("Interface Poll"), i18n.tr("Topology Poll"), i18n.tr("Configuration Poll"), i18n.tr("Instance Discovery Poll"), i18n.tr("Routing Table Poll"), i18n.tr("Network Discovery Poll"), i18n.tr("Automatic Binding Poll")};
    private static final Color COLOR_ERROR = new Color((Device)Display.getCurrent(), 192, 0, 0);
    private static final Color COLOR_WARNING = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private static final Color COLOR_INFO = new Color((Device)Display.getCurrent(), 0, 128, 0);
    private static final Color COLOR_LOCAL = new Color((Device)Display.getCurrent(), 0, 0, 192);
    private NXCSession session = Registry.getSession();
    private PollingTarget target;
    private ObjectPollType pollType;
    private Display display = Display.getCurrent();
    private StyledText textArea;
    private boolean pollActive = false;
    private Action actionRestart;
    private Action actionClearOutput;

    public ObjectPollerView(AbstractObject object, ObjectPollType type) {
        super(POLL_NAME[type.getValue()], ResourceManager.getImageDescriptor((String)"icons/object-views/poller_view.png"), "ObjectPoll." + type, object.getObjectId(), false);
        this.target = (PollingTarget)object;
        this.pollType = type;
    }

    protected void createContent(Composite parent) {
        this.textArea = new StyledText(parent, 770);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.createActions();
    }

    private void createActions() {
        this.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRestart.setActionDefinitionId("org.netxms.ui.eclipse.objectmanager.commands.restart_poller");
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClearOutput.setActionDefinitionId("org.netxms.ui.eclipse.objectmanager.commands.clear_output");
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void addPollerMessage(String message) {
        Date now = new Date();
        this.textArea.append("[" + DateFormatFactory.getDateTimeFormat().format(now) + "] ");
        int index = message.indexOf(127);
        if (index != -1) {
            this.textArea.append(message.substring(0, index));
            char code = message.charAt(index + 1);
            int lastPos = this.textArea.getCharCount();
            String msgPart = message.substring(index + 2);
            this.textArea.append(msgPart);
            StyleRange style = new StyleRange();
            style.start = lastPos;
            style.length = msgPart.length();
            style.foreground = this.getTextColor(code);
            this.textArea.setStyleRange(style);
        } else {
            this.textArea.append(message);
        }
    }

    private Color getTextColor(char code) {
        switch (code) {
            case 'e': {
                return COLOR_ERROR;
            }
            case 'w': {
                return COLOR_WARNING;
            }
            case 'i': {
                return COLOR_INFO;
            }
            case 'l': {
                return COLOR_LOCAL;
            }
        }
        return null;
    }

    public void startPoll() {
        if (this.pollActive) {
            return;
        }
        this.pollActive = true;
        this.actionRestart.setEnabled(false);
        this.addPollerMessage("\u007fl**** Poll request sent to server ****\r\n");
        3 listener = new /* Unavailable Anonymous Inner Class!! */;
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setSystem(true);
        job.start();
    }

    private void onPollComplete(boolean success, String errorMessage) {
        this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

