/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.views.AbstractCommandResultView;
import org.netxms.nxmc.modules.objects.views.ServerCommandResults;
import org.xnap.commons.i18n.I18n;

public class ServerCommandResults
extends AbstractCommandResultView
implements TextOutputListener {
    private static final I18n i18n = LocalizationHelper.getI18n(ServerCommandResults.class);
    private TextConsole.IOConsoleOutputStream out;
    private String lastCommand = null;
    private Action actionRestart;
    private Action actionStop;
    private long streamId = 0L;
    private boolean isRunning = false;

    public ServerCommandResults(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        super(node, tool, inputValues, maskedFields);
    }

    protected void createActions() {
        super.createActions();
        this.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRestart.setEnabled(false);
        this.actionStop = new /* Unavailable Anonymous Inner Class!! */;
        this.actionStop.setEnabled(false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalMenu(manager);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void execute() {
        if (this.isRunning) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Command already running!");
            return;
        }
        this.isRunning = true;
        this.actionRestart.setEnabled(false);
        this.actionStop.setEnabled(true);
        this.out = this.console.newOutputStream();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void stopCommand() {
        if (this.streamId > 0L) {
            4 job = new /* Unavailable Anonymous Inner Class!! */;
            job.start();
        }
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    public boolean beforeClose() {
        if (this.isRunning) {
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Stop command", (String)("Do you wish to stop the command \"" + this.lastCommand + "\"? "))) {
                this.stopCommand();
                return true;
            }
            return false;
        }
        return true;
    }

    public void onError() {
    }
}

