/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SSHCredentials;
import org.netxms.client.SessionListener;
import org.netxms.client.SshKeyPair;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.ZoneSelector;
import org.netxms.nxmc.modules.serverconfig.NetworkCredentials;
import org.netxms.nxmc.modules.serverconfig.dialogs.EditSSHCredentialsDialog;
import org.netxms.nxmc.modules.serverconfig.dialogs.EditSnmpUsmCredentialsDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SnmpUsmCredentialsLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SshCredentialsLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NetworkCredentialsEditor
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(NetworkCredentialsEditor.class);
    public static final int COLUMN_SNMP_USERNAME = 0;
    public static final int COLUMN_SNMP_AUTHENTICATION = 1;
    public static final int COLUMN_SNMP_ENCRYPTION = 2;
    public static final int COLUMN_SNMP_AUTH_PASSWORD = 3;
    public static final int COLUMN_SNMP_ENCRYPTION_PASSWORD = 4;
    public static final int COLUMN_SNMP_COMMENTS = 5;
    public static final int COLUMN_SSH_LOGIN = 0;
    public static final int COLUMN_SSH_PASSWORD = 1;
    public static final int COLUMN_SSH_KEY = 2;
    private NXCSession session;
    private boolean modified = false;
    private boolean bothModified = false;
    private boolean saveInProgress = false;
    private int warningMessageId = 0;
    private Composite content;
    private TableViewer snmpCommunityList;
    private SortableTableViewer snmpUsmCredentialsList;
    private TableViewer snmpPortList;
    private TableViewer sharedSecretList;
    private TableViewer agentPortList;
    private TableViewer sshCredentialsList;
    private TableViewer sshPortList;
    private Action actionSave;
    private NetworkCredentials config;
    private ZoneSelector zoneSelector;
    private int zoneUIN = NetworkCredentials.NETWORK_CONFIG_GLOBAL;
    private List<SshKeyPair> sshKeys;
    private SshCredentialsLabelProvider sshLabelProvider;

    public NetworkCredentialsEditor() {
        super(i18n.tr("Network Credentials"), ResourceManager.getImageDescriptor((String)"icons/config-views/network-discovery.gif"), "NetworkDiscovery", false);
        this.session = Registry.getSession();
        this.config = new NetworkCredentials(this.session);
    }

    public void createContent(Composite parent) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)scroller, (int)512, (int)20);
        scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.content = new Composite((Composite)scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        scroller.setContent((Control)this.content);
        if (this.session.isZoningEnabled()) {
            Composite headArea = new Composite(this.content, 0);
            headArea.setBackground(this.content.getBackground());
            headArea.setLayout((Layout)new GridLayout());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = layout.numColumns;
            headArea.setLayoutData((Object)gd);
            this.zoneSelector = new ZoneSelector(headArea, 0, true);
            this.zoneSelector.setEmptySelectionText("Global");
            this.zoneSelector.setLabel("Select zone");
            this.zoneSelector.setBackground(headArea.getBackground());
            this.zoneSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            gd = new GridData();
            gd.widthHint = 300;
            this.zoneSelector.setLayoutData((Object)gd);
            Label separator = new Label(headArea, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createSnmpCommunitySection();
        this.snmpPortList = this.createPortList(4, "SNMP");
        this.createSnmpUsmCredSection();
        this.createSharedSecretList();
        this.agentPortList = this.createPortList(16, "Agent");
        this.createSshCredentialsList();
        this.sshPortList = this.createPortList(64, "SSH");
        this.createActions();
        this.loadConfiguration(127, NetworkCredentials.ALL_ZONES);
    }

    private void loadConfiguration(int configId, int zoneUIN) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    public void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Refresh Network Credentials"), (String)i18n.tr("This will discard all unsaved changes. Do you really want to continue?"))) {
            return;
        }
        this.loadConfiguration(127, NetworkCredentials.ALL_ZONES);
        this.modified = false;
        this.bothModified = false;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void createSnmpCommunitySection() {
        Section section = new Section(this.content, i18n.tr("SNMP community strings"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        this.snmpCommunityList = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.snmpCommunityList.getTable().setLayoutData((Object)gd);
        this.snmpCommunityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSnmpUsmCredSection() {
        Section section = new Section(this.content, i18n.tr("SNMPv3 USM credentials"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{"User name", "Auth type", "Priv type", "Auth password", "Priv password", "Comments"};
        int[] widths = new int[]{100, 100, 100, 100, 100, 100};
        this.snmpUsmCredentialsList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.snmpUsmCredentialsList.getTable().setLayoutData((Object)gd);
        this.snmpUsmCredentialsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpUsmCredentialsList.setLabelProvider((IBaseLabelProvider)new SnmpUsmCredentialsLabelProvider());
        this.snmpUsmCredentialsList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSharedSecretList() {
        Section section = new Section(this.content, i18n.tr("Agent shared secrets"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        this.sharedSecretList = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.sharedSecretList.getTable().setLayoutData((Object)gd);
        this.sharedSecretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSshCredentialsList() {
        Section section = new Section(this.content, i18n.tr("SSH credentials"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{"Login", "Password", "Key"};
        int[] widths = new int[]{150, 150, 150};
        this.sshCredentialsList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.sshCredentialsList.getTable().setLayoutData((Object)gd);
        this.sshCredentialsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sshLabelProvider = new SshCredentialsLabelProvider();
        this.sshCredentialsList.setLabelProvider((IBaseLabelProvider)this.sshLabelProvider);
        this.sshCredentialsList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private TableViewer createPortList(int portType, String typeName) {
        Section section = new Section(this.content, String.format("%s ports", typeName), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        viewer.getTable().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setData("PortType", (Object)portType);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        return viewer;
    }

    public void setFocus() {
        this.content.setFocus();
    }

    private void setConfig(NetworkCredentials config) {
        this.config = config;
        this.updateFieldContent();
    }

    private void updateFieldContent() {
        this.snmpCommunityList.setInput((Object)this.config.getCommunities(this.zoneUIN));
        this.snmpUsmCredentialsList.setInput((Object)this.config.getUsmCredentials(this.zoneUIN));
        this.snmpPortList.setInput((Object)this.config.getPorts(4, this.zoneUIN));
        this.sharedSecretList.setInput((Object)this.config.getSharedSecrets(this.zoneUIN));
        this.agentPortList.setInput((Object)this.config.getPorts(16, this.zoneUIN));
        this.sshCredentialsList.setInput((Object)this.config.getSshCredentials(this.zoneUIN));
        this.sshPortList.setInput((Object)this.config.getPorts(64, this.zoneUIN));
    }

    private void setModified(int id) {
        this.config.setConfigUpdate(this.zoneUIN, id);
        if (!this.modified) {
            this.modified = true;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getSaveOnExitPrompt() {
        return this.bothModified ? i18n.tr("Network credentials are modified by you and other users. Do you want to save your changes and overwrite other users' changes?") : i18n.tr("Network credentials are modified. Do you want to save your changes?");
    }

    public void save() {
        this.saveInProgress = true;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addCommunity() {
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), i18n.tr("Add SNMP Community String"), i18n.tr("Enter SNMP community string"), "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            this.config.addCommunityString(s, this.zoneUIN);
            this.snmpCommunityList.setInput((Object)this.config.getCommunities(this.zoneUIN));
            this.setModified(1);
        }
    }

    private void removeCommunity() {
        List list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = this.snmpCommunityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpCommunityList.setInput((Object)list);
            this.setModified(1);
        }
    }

    protected void moveCommunity(boolean up) {
        List list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = this.snmpCommunityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpCommunityList.setInput((Object)list);
            this.setModified(1);
        }
    }

    private void addUsmCredentials() {
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getWindow().getShell(), null);
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getCredentials();
            cred.setZoneId(this.zoneUIN);
            this.config.addUsmCredentials(cred, this.zoneUIN);
            this.snmpUsmCredentialsList.setInput((Object)this.config.getUsmCredentials(this.zoneUIN));
            this.setModified(2);
        }
    }

    private void editUsmCredentials() {
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpUsmCredential cred = (SnmpUsmCredential)selection.getFirstElement();
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getWindow().getShell(), cred);
        if (dlg.open() == 0) {
            List list = this.config.getUsmCredentials(this.zoneUIN);
            this.snmpUsmCredentialsList.setInput((Object)list.toArray());
            this.setModified(2);
        }
    }

    private void removeUsmCredentials() {
        List list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpUsmCredentialsList.setInput((Object)list.toArray());
            this.setModified(2);
        }
    }

    protected void moveUsmCredentials(boolean up) {
        List list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpUsmCredentialsList.setInput((Object)list);
            this.setModified(2);
        }
    }

    protected void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), i18n.tr("Add Shared Secret"), i18n.tr("Enter shared secret"), "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addSharedSecret(value, this.zoneUIN);
            this.sharedSecretList.setInput((Object)this.config.getSharedSecrets(this.zoneUIN));
            this.setModified(8);
        }
    }

    protected void removeSharedSecret() {
        List list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = this.sharedSecretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.sharedSecretList.setInput((Object)list.toArray());
            this.setModified(8);
        }
    }

    protected void moveSharedSecret(boolean up) {
        List list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = this.sharedSecretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.sharedSecretList.setInput((Object)list);
            this.setModified(8);
        }
    }

    private void addSshCredentials() {
        EditSSHCredentialsDialog dlg = new EditSSHCredentialsDialog(this.getWindow().getShell(), null, this.sshKeys);
        if (dlg.open() == 0) {
            SSHCredentials cred = dlg.getCredentials();
            this.config.addSshCredentials(cred, this.zoneUIN);
            this.sshCredentialsList.setInput((Object)this.config.getSshCredentials(this.zoneUIN));
            this.setModified(32);
        }
    }

    private void editSshCredentials() {
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SSHCredentials cred = (SSHCredentials)selection.getFirstElement();
        EditSSHCredentialsDialog dlg = new EditSSHCredentialsDialog(this.getWindow().getShell(), cred, this.sshKeys);
        if (dlg.open() == 0) {
            List list = this.config.getSshCredentials(this.zoneUIN);
            this.sshCredentialsList.setInput((Object)list.toArray());
            this.setModified(32);
        }
    }

    private void removeSshCredentials() {
        List list = this.config.getSshCredentials(this.zoneUIN);
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.sshCredentialsList.setInput((Object)list.toArray());
            this.setModified(32);
        }
    }

    protected void moveSshCredentials(boolean up) {
        List list = this.config.getSshCredentials(this.zoneUIN);
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.sshCredentialsList.setInput((Object)list);
            this.setModified(32);
        }
    }

    private void addPort(TableViewer viewer, String typeName) {
        int portType = (Integer)viewer.getData("PortType");
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), String.format(i18n.tr("Add %s Port"), typeName), String.format(i18n.tr("Please enter %s port"), typeName), "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addPort(portType, Integer.valueOf(Integer.parseInt(value)), this.zoneUIN);
            viewer.setInput((Object)this.config.getPorts(portType, this.zoneUIN));
            this.setModified(portType);
        }
    }

    private void removePort(TableViewer viewer) {
        int portType = (Integer)viewer.getData("PortType");
        List list = this.config.getPorts(portType, this.zoneUIN);
        IStructuredSelection selection = viewer.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove((Integer)o);
            }
            viewer.setInput((Object)list.toArray());
            this.setModified(portType);
        }
    }

    protected void movePort(TableViewer viewer, boolean up) {
        int portType = (Integer)viewer.getData("PortType");
        List list = this.config.getPorts(portType, this.zoneUIN);
        IStructuredSelection selection = viewer.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf((Integer)o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            viewer.setInput((Object)list);
            this.setModified(portType);
        }
    }
}

