/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util;

import java.util.Stack;
import org.codehaus.commons.nullanalysis.Nullable;

public class Benchmark {
    private final Stack<Long> beginTimes = new Stack();
    private final boolean reportingEnabled;
    private final Reporter reporter;
    private static final String PAD = "                       ";

    public void begin() {
        this.beginTimes.push(new Long(System.currentTimeMillis()));
    }

    public long end() {
        return System.currentTimeMillis() - this.beginTimes.pop();
    }

    public Benchmark(boolean reportingEnabled) {
        this.reportingEnabled = reportingEnabled;
        this.reporter = new Reporter(){

            @Override
            public void report(String message2) {
                System.out.println(message2);
            }
        };
    }

    public Benchmark(boolean reportingEnabled, Reporter reporter) {
        this.reportingEnabled = reportingEnabled;
        this.reporter = reporter;
    }

    public void beginReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("Beginning...");
        this.begin();
    }

    public void beginReporting(String message2) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented(message2 + "...");
        this.begin();
    }

    public void endReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms");
    }

    public void endReporting(String message2) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms: " + message2);
    }

    public void report(String message2) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented(message2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@Nullable String title, @Nullable Object o) {
        String prefix;
        if (!this.reportingEnabled) {
            return;
        }
        String string2 = title == null ? "" : (prefix = title + ": " + (title.length() < PAD.length() ? PAD.substring(title.length()) : ""));
        if (o == null) {
            this.reportIndented(prefix + "(undefined)");
        } else if (o.getClass().isArray()) {
            Object[] oa = (Object[])o;
            if (oa.length == 0) {
                this.reportIndented(prefix + "(empty)");
            } else if (oa.length == 1) {
                this.reportIndented(prefix + oa[0].toString());
            } else {
                this.reportIndented(title == null ? "Array:" : title + ':');
                this.begin();
                try {
                    for (Object o2 : oa) {
                        this.report(null, o2);
                    }
                }
                finally {
                    this.end();
                }
            }
        } else {
            this.reportIndented(prefix + o.toString());
        }
    }

    private void reportIndented(String message2) {
        StringBuilder sb = new StringBuilder();
        for (int i = this.beginTimes.size(); i > 0; --i) {
            sb.append("  ");
        }
        sb.append(message2);
        this.reporter.report(sb.toString());
    }

    public static interface Reporter {
        public void report(String var1);
    }
}

