/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import com.jcraft.jzlib.Deflater;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.EncryptionContext;
import org.netxms.base.GeoLocation;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.base.VersionInfo;
import org.netxms.client.AccessListElement;
import org.netxms.client.AgentFileData;
import org.netxms.client.AgentFileFingerprint;
import org.netxms.client.AgentFileInfo;
import org.netxms.client.AgentParameter;
import org.netxms.client.AgentPolicy;
import org.netxms.client.AgentTable;
import org.netxms.client.AgentTunnel;
import org.netxms.client.FutureObject;
import org.netxms.client.GeoArea;
import org.netxms.client.HardwareComponent;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.LibraryImage;
import org.netxms.client.LicenseProblem;
import org.netxms.client.MaintenanceJournalEntry;
import org.netxms.client.MessageHandler;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCReceivedFile;
import org.netxms.client.NotificationChannel;
import org.netxms.client.OUICache;
import org.netxms.client.ObjectCreationListener;
import org.netxms.client.ObjectFilter;
import org.netxms.client.ObjectUrl;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.PhysicalLink;
import org.netxms.client.ProgressListener;
import org.netxms.client.ProtocolVersion;
import org.netxms.client.ReceivedFile;
import org.netxms.client.SSHCredentials;
import org.netxms.client.ScheduledTask;
import org.netxms.client.Script;
import org.netxms.client.ScriptCompilationResult;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.SoftwarePackage;
import org.netxms.client.SshKeyPair;
import org.netxms.client.Table;
import org.netxms.client.TcpProxy;
import org.netxms.client.TextOutputListener;
import org.netxms.client.TimePeriod;
import org.netxms.client.TwoFactorAuthenticationCallback;
import org.netxms.client.UserAgentNotification;
import org.netxms.client.agent.config.AgentConfiguration;
import org.netxms.client.agent.config.AgentConfigurationHandle;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.businessservices.BusinessServiceTicket;
import org.netxms.client.constants.AggregationFunction;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.constants.ObjectPollType;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.datacollection.DCOStatusHolder;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciLastValue;
import org.netxms.client.datacollection.DciPushData;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.datacollection.GraphFolder;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.datacollection.PredictionEngine;
import org.netxms.client.datacollection.RemoteChangeListener;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.datacollection.ThresholdStateChange;
import org.netxms.client.datacollection.ThresholdViolationSummary;
import org.netxms.client.datacollection.TransformationTestResult;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.client.datacollection.WinPerfObject;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.events.BulkAlarmStateChangeData;
import org.netxms.client.events.Event;
import org.netxms.client.events.EventInfo;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventReference;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.log.Log;
import org.netxms.client.maps.MapDCIInstance;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.market.Repository;
import org.netxms.client.mt.MappingTable;
import org.netxms.client.mt.MappingTableDescriptor;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.DependentNode;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.MutableObjectCategory;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.client.objects.UnknownObject;
import org.netxms.client.objects.VPNConnector;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.client.objects.interfaces.NodeItemPair;
import org.netxms.client.objects.queries.ObjectQuery;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.client.objecttools.ObjectContextBase;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.objecttools.ObjectToolFolder;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.client.packages.PackageInfo;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.client.reporting.ReportingJobConfiguration;
import org.netxms.client.server.AgentFile;
import org.netxms.client.server.ServerConsoleListener;
import org.netxms.client.server.ServerFile;
import org.netxms.client.server.ServerJob;
import org.netxms.client.server.ServerJobIdUpdater;
import org.netxms.client.server.ServerVariable;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.client.topology.FdbEntry;
import org.netxms.client.topology.NetworkPath;
import org.netxms.client.topology.OSPFInfo;
import org.netxms.client.topology.Route;
import org.netxms.client.topology.VlanInfo;
import org.netxms.client.topology.WirelessStation;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.ResponsibleUser;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXCSession {
    public static final int DCI_RES_SEARCH_NAME = 1;
    public static final int DEFAULT_CONN_PORT = 4701;
    public static final String CHANNEL_AGENT_TUNNELS = "Core.AgentTunnels";
    public static final String CHANNEL_ALARMS = "Core.Alarms";
    public static final String CHANNEL_AUDIT_LOG = "Core.Audit";
    public static final String CHANNEL_DC_THRESHOLDS = "Core.DC.Thresholds";
    public static final String CHANNEL_GEO_AREAS = "Core.GeoAreas";
    public static final String CHANNEL_EVENTS = "Core.Events";
    public static final String CHANNEL_OBJECTS = "Core.Objects";
    public static final String CHANNEL_SNMP_TRAPS = "Core.SNMP.Traps";
    public static final String CHANNEL_SYSLOG = "Core.Syslog";
    public static final String CHANNEL_USERDB = "Core.UserDB";
    public static final int OBJECT_SYNC_NOTIFY = 1;
    public static final int OBJECT_SYNC_WAIT = 2;
    public static final int CFG_IMPORT_REPLACE_EVENTS = 1;
    public static final int CFG_IMPORT_REPLACE_ACTIONS = 2;
    public static final int CFG_IMPORT_REPLACE_TEMPLATES = 4;
    public static final int CFG_IMPORT_REPLACE_TRAPS = 8;
    public static final int CFG_IMPORT_REPLACE_SCRIPTS = 16;
    public static final int CFG_IMPORT_REPLACE_SUMMARY_TABLES = 32;
    public static final int CFG_IMPORT_REPLACE_OBJECT_TOOLS = 64;
    public static final int CFG_IMPORT_REPLACE_EPP_RULES = 128;
    public static final int CFG_IMPORT_REPLACE_TEMPLATE_NAMES_LOCATIONS = 256;
    public static final int CFG_IMPORT_DELETE_EMPTY_TEMPLATE_GROUPS = 512;
    public static final int CFG_IMPORT_REPLACE_WEB_SVCERVICE_DEFINITIONS = 1024;
    public static final int ADDRESS_LIST_DISCOVERY_TARGETS = 1;
    public static final int ADDRESS_LIST_DISCOVERY_FILTER = 2;
    public static final int SERVER_COMPONENT_DISCOVERY_MANAGER = 1;
    public static final int DESKTOP_CLIENT = 0;
    public static final int WEB_CLIENT = 1;
    public static final int MOBILE_CLIENT = 2;
    public static final int TABLET_CLIENT = 3;
    public static final int APPLICATION_CLIENT = 4;
    private static final int CLIENT_CHALLENGE_SIZE = 256;
    private static final int MAX_DCI_DATA_ROWS = 200000;
    private static final int MAX_DCI_STRING_VALUE_LENGTH = 256;
    private static final int RECEIVED_FILE_TTL = 300000;
    private static final int FILE_BUFFER_SIZE = 32768;
    private static Logger logger = LoggerFactory.getLogger(NXCSession.class);
    private final Semaphore syncObjects = new Semaphore(1);
    private final Semaphore syncUserDB = new Semaphore(1);
    private String connAddress;
    private int connPort;
    private boolean connUseEncryption;
    private String connClientInfo = "nxjclient/" + VersionInfo.version();
    private int clientType = 0;
    private String clientAddress = null;
    private boolean ignoreProtocolVersion = false;
    private String clientLanguage = "en";
    private int sessionId;
    private int userId;
    private String userName;
    private AuthenticationType authenticationMethod;
    private long userSystemRights;
    private boolean passwordExpired;
    private int graceLogins;
    private Socket socket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private HousekeeperThread housekeeperThread = null;
    private AtomicLong requestId = new AtomicLong(1L);
    private boolean connected = false;
    private boolean disconnected = false;
    private boolean serverConsoleConnected = false;
    private boolean allowCompression = false;
    private EncryptionContext encryptionContext = null;
    private Throwable receiverStopCause = null;
    private int defaultRecvBufferSize = 0x400000;
    private int maxRecvBufferSize = 0x2000000;
    private int connectTimeout = 10000;
    private int commandTimeout = 30000;
    private int serverCommandOutputTimeout = 60000;
    private LinkedBlockingQueue<SessionNotification> notificationQueue = new LinkedBlockingQueue(8192);
    private Set<SessionListener> listeners = new HashSet<SessionListener>(0);
    private Set<ServerConsoleListener> consoleListeners = new HashSet<ServerConsoleListener>(0);
    private Map<Long, ProgressListener> progressListeners = new HashMap<Long, ProgressListener>(0);
    private Map<MessageSubscription, MessageHandler> messageSubscriptions = new HashMap<MessageSubscription, MessageHandler>(0);
    private Map<Long, NXCReceivedFile> receivedFiles = new HashMap<Long, NXCReceivedFile>();
    private Map<String, String> receivedFileUpdates = new HashMap<String, String>();
    private ProtocolVersion protocolVersion;
    private String serverVersion = "(unknown)";
    private long serverId = 0L;
    private String serverTimeZone;
    private byte[] serverChallenge = new byte[256];
    private boolean zoningEnabled = false;
    private boolean helpdeskLinkActive = false;
    private String tileServerURL;
    private String dateFormat;
    private String timeFormat;
    private String shortTimeFormat;
    private int defaultDciRetentionTime;
    private int defaultDciPollingInterval;
    private boolean strictAlarmStatusFlow;
    private boolean timedAlarmAckEnabled;
    private int minViewRefreshInterval;
    private long serverTime = System.currentTimeMillis();
    private long serverTimeRecvTime = System.currentTimeMillis();
    private Set<String> serverComponents = new HashSet<String>(0);
    private String serverName;
    private String serverColor;
    private Map<String, String> clientConfigurationHints = new HashMap<String, String>();
    private Map<Long, AbstractObject> objectList = new HashMap<Long, AbstractObject>();
    private Map<UUID, AbstractObject> objectListGUID = new HashMap<UUID, AbstractObject>();
    private Map<Integer, Zone> zoneList = new HashMap<Integer, Zone>();
    private Map<Integer, ObjectCategory> objectCategories = new HashMap<Integer, ObjectCategory>();
    private boolean objectsSynchronized = false;
    private Set<String> responsibleUserTags = new HashSet<String>();
    private Map<Long, AbstractUserObject> userDatabase = new HashMap<Long, AbstractUserObject>();
    private Map<UUID, AbstractUserObject> userDatabaseGUID = new HashMap<UUID, AbstractUserObject>();
    private Set<Long> missingUsers = new HashSet<Long>();
    private boolean userDatabaseSynchronized = false;
    private Set<Long> userSyncList = new HashSet<Long>();
    private List<Runnable> callbackList = new ArrayList<Runnable>();
    private Map<Long, EventTemplate> eventTemplates = new HashMap<Long, EventTemplate>();
    private boolean eventTemplatesSynchronized = false;
    private Map<Long, AlarmCategory> alarmCategories = new HashMap<Long, AlarmCategory>();
    private boolean alarmCategoriesSynchronized = false;
    private String messageOfTheDay;
    private LicenseProblem[] licenseProblems = null;
    private List<PredictionEngine> predictionEngines = null;
    private Map<Integer, TcpProxy> tcpProxies = new HashMap<Integer, TcpProxy>();
    private Set<Long> synchronizedObjectSet = new HashSet<Long>();
    private OUICache ouiCache;

    public NXCSession(String connAddress) {
        this(connAddress, 4701, false);
    }

    public NXCSession(String connAddress, int connPort) {
        this(connAddress, connPort, false);
    }

    public NXCSession(String connAddress, int connPort, boolean connUseEncryption) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connUseEncryption = connUseEncryption;
        this.ouiCache = new OUICache(this);
    }

    protected AbstractObject createCustomObjectFromMessage(int objectClass, NXCPMessage msg2) {
        return null;
    }

    private AbstractObject createObjectFromMessage(NXCPMessage msg2) {
        int objectClass = msg2.getFieldAsInt32(5L);
        AbstractObject object = this.createCustomObjectFromMessage(objectClass, msg2);
        if (object != null) {
            return object;
        }
        switch (objectClass) {
            case 33: {
                object = new AccessPoint(msg2, this);
                break;
            }
            case 28: {
                object = new BusinessService(msg2, this);
                break;
            }
            case 15: {
                object = new BusinessServicePrototype(msg2, this);
                break;
            }
            case 27: {
                object = new BusinessServiceRoot(msg2, this);
                break;
            }
            case 35: {
                object = new Chassis(msg2, this);
                break;
            }
            case 14: {
                object = new Cluster(msg2, this);
                break;
            }
            case 13: {
                object = new Condition(msg2, this);
                break;
            }
            case 5: {
                object = new Container(msg2, this);
                break;
            }
            case 36: {
                object = new DashboardGroup(msg2, this);
                break;
            }
            case 23: {
                object = new Dashboard(msg2, this);
                break;
            }
            case 22: {
                object = new DashboardRoot(msg2, this);
                break;
            }
            case 3: {
                object = new Interface(msg2, this);
                break;
            }
            case 31: {
                object = new MobileDevice(msg2, this);
                break;
            }
            case 4: {
                object = new EntireNetwork(msg2, this);
                break;
            }
            case 21: {
                object = new NetworkMap(msg2, this);
                break;
            }
            case 20: {
                object = new NetworkMapGroup(msg2, this);
                break;
            }
            case 19: {
                object = new NetworkMapRoot(msg2, this);
                break;
            }
            case 11: {
                object = new NetworkService(msg2, this);
                break;
            }
            case 2: {
                object = new Node(msg2, this);
                break;
            }
            case 32: {
                object = new Rack(msg2, this);
                break;
            }
            case 37: {
                object = new Sensor(msg2, this);
                break;
            }
            case 7: {
                object = new ServiceRoot(msg2, this);
                break;
            }
            case 1: {
                object = new Subnet(msg2, this);
                break;
            }
            case 8: {
                object = new Template(msg2, this);
                break;
            }
            case 9: {
                object = new TemplateGroup(msg2, this);
                break;
            }
            case 10: {
                object = new TemplateRoot(msg2, this);
                break;
            }
            case 12: {
                object = new VPNConnector(msg2, this);
                break;
            }
            case 6: {
                object = new Zone(msg2, this);
                break;
            }
            default: {
                object = new GenericObject(msg2, this);
            }
        }
        return object;
    }

    private void setupEncryption(NXCPMessage msg2) throws IOException, NXCException {
        NXCPMessage response = new NXCPMessage(132, msg2.getMessageId());
        response.setEncryptionDisabled(true);
        try {
            this.encryptionContext = EncryptionContext.createInstance(msg2);
            response.setField(155L, this.encryptionContext.getEncryptedSessionKey());
            response.setField(158L, this.encryptionContext.getEncryptedIv());
            response.setFieldInt16(156L, this.encryptionContext.getCipher());
            response.setFieldInt16(157L, this.encryptionContext.getKeyLength());
            response.setFieldInt16(238L, this.encryptionContext.getIvLength());
            response.setFieldInt32(28L, 0);
            logger.debug("Cipher selected: " + EncryptionContext.getCipherName(this.encryptionContext.getCipher()));
            logger.debug("Server key fingerprint: " + this.encryptionContext.getServerKeyFingerprint());
        }
        catch (Exception e) {
            logger.error("Failed to create encryption context", e);
            response.setFieldInt32(28L, 42);
        }
        this.sendMessage(response);
    }

    private void waitForSync(Semaphore syncObject, int timeout) throws NXCException {
        if (timeout == 0) {
            syncObject.acquireUninterruptibly();
        } else {
            long startTime;
            boolean success = false;
            for (long actualTimeout = (long)timeout; actualTimeout > 0L; actualTimeout -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                try {
                    if (!syncObject.tryAcquire(actualTimeout, TimeUnit.MILLISECONDS)) continue;
                    success = true;
                    syncObject.release();
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!success) {
                throw new NXCException(4);
            }
        }
    }

    private void completeSync(Semaphore syncObject) {
        syncObject.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SessionListener listener) {
        boolean changed;
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            changed = this.listeners.add(listener);
        }
        if (changed) {
            this.notificationQueue.offer(new SessionNotification(32766));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SessionListener listener) {
        boolean changed;
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            changed = this.listeners.remove(listener);
        }
        if (changed) {
            this.notificationQueue.offer(new SessionNotification(32766));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageSubscription(int messageCode, long messageId, MessageHandler handler2) {
        Map<MessageSubscription, MessageHandler> map = this.messageSubscriptions;
        synchronized (map) {
            this.messageSubscriptions.put(new MessageSubscription(messageCode, messageId), handler2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageSubscription(int messageCode, long messageId) {
        Map<MessageSubscription, MessageHandler> map = this.messageSubscriptions;
        synchronized (map) {
            this.messageSubscriptions.remove(new MessageSubscription(messageCode, messageId));
        }
    }

    protected void sendNotification(SessionNotification n) {
        if (!this.notificationQueue.offer(n)) {
            logger.warn("Notification processing queue is full");
        }
    }

    public synchronized void sendMessage(NXCPMessage msg2) throws IOException, NXCException {
        byte[] message2;
        if (this.socket == null) {
            throw new IllegalStateException("Not connected to the server. Did you forgot to call connect() first?");
        }
        OutputStream outputStream = this.socket.getOutputStream();
        if (this.encryptionContext != null && !msg2.isEncryptionDisabled()) {
            try {
                message2 = this.encryptionContext.encryptMessage(msg2, this.allowCompression);
            }
            catch (GeneralSecurityException e) {
                throw new NXCException(98);
            }
        } else {
            message2 = msg2.createNXCPMessage(this.allowCompression);
        }
        outputStream.write(message2);
    }

    private void abortFileTransfer(long requestId) throws IOException, NXCException {
        NXCPMessage msg2 = new NXCPMessage(114, requestId);
        msg2.setBinaryMessage(true);
        msg2.setBinaryData(new byte[0]);
        this.sendMessage(msg2);
    }

    protected void sendFile(long requestId, File file, ProgressListener listener, boolean allowStreamCompression, long offset) throws IOException, NXCException {
        BufferedInputStream inputStream;
        if (listener != null) {
            listener.setTotalWorkAmount(file.length());
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            this.abortFileTransfer(requestId);
            throw e;
        }
        this.sendFileStream(requestId, inputStream, listener, allowStreamCompression && file.length() > 1024L, offset);
        ((InputStream)inputStream).close();
    }

    protected void sendFile(long requestId, byte[] data, ProgressListener listener, boolean allowStreamCompression) throws IOException, NXCException {
        if (listener != null) {
            listener.setTotalWorkAmount(data.length);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        this.sendFileStream(requestId, inputStream, listener, allowStreamCompression, 0L);
        ((InputStream)inputStream).close();
    }

    private void sendFileStream(long requestId, InputStream inputStream, ProgressListener listener, boolean allowStreamCompression, long offset) throws IOException, NXCException {
        NXCPMessage msg2 = new NXCPMessage(105, requestId);
        msg2.setBinaryMessage(true);
        inputStream.skip(offset);
        Deflater compressor = allowStreamCompression ? new Deflater(9) : null;
        msg2.setStream(true, allowStreamCompression);
        byte[] buffer = new byte[32768];
        try {
            int bytesRead;
            long bytesSent = 0L;
            do {
                if ((bytesRead = inputStream.read(buffer)) < 32768) {
                    msg2.setEndOfFile(true);
                }
                if (compressor != null && bytesRead > 0) {
                    byte[] compressedData = new byte[compressor.deflateBound(bytesRead) + 4];
                    compressor.setInput(buffer, 0, bytesRead, false);
                    compressor.setOutput(compressedData, 4, compressedData.length - 4);
                    if (compressor.deflate(2) != 0) {
                        throw new NXCException(16);
                    }
                    int length = compressedData.length - compressor.getAvailOut();
                    byte[] payload = Arrays.copyOf(compressedData, length);
                    payload[0] = 2;
                    payload[1] = 0;
                    payload[2] = (byte)(bytesRead >> 8 & 0xFF);
                    payload[3] = (byte)(bytesRead & 0xFF);
                    msg2.setBinaryData(payload);
                } else {
                    msg2.setBinaryData(bytesRead > 0 ? Arrays.copyOf(buffer, bytesRead) : new byte[]{});
                }
                this.sendMessage(msg2);
                bytesSent += bytesRead == -1 ? 0L : (long)bytesRead;
                if (listener == null) continue;
                listener.markProgress(bytesSent);
            } while (bytesRead >= 32768);
            if (compressor != null) {
                compressor.deflateEnd();
            }
        }
        catch (Exception e) {
            this.abortFileTransfer(requestId);
            throw e;
        }
    }

    public NXCPMessage waitForMessage(int code2, long id, int timeout) throws NXCException {
        NXCPMessage msg2 = this.msgWaitQueue.waitForMessage(code2, id, timeout);
        if (msg2 == null) {
            throw this.receiverStopCause != null ? new NXCException(9, this.receiverStopCause) : new NXCException(4);
        }
        return msg2;
    }

    public NXCPMessage waitForMessage(int code2, long id) throws NXCException {
        return this.waitForMessage(code2, id, this.msgWaitQueue.getDefaultTimeout());
    }

    public NXCPMessage waitForRCC(long id) throws NXCException {
        return this.waitForRCC(id, this.msgWaitQueue.getDefaultTimeout());
    }

    public NXCPMessage waitForRCC(long id, int timeout) throws NXCException {
        NXCPMessage msg2 = this.waitForMessage(29, id, timeout);
        int rcc = msg2.getFieldAsInt32(28L);
        if (rcc != 0 && rcc != 158) {
            long[] relatedObjects = msg2.getFieldAsUInt32Array(139L);
            String description = rcc == 1 && msg2.findField(29L) != null ? msg2.getFieldAsString(29L) : (msg2.findField(259L) != null ? msg2.getFieldAsString(259L) : (msg2.findField(21L) != null ? msg2.getFieldAsString(21L) : null));
            throw new NXCException(rcc, description, relatedObjects);
        }
        return msg2;
    }

    public final NXCPMessage newMessage(int code2) {
        return new NXCPMessage(code2, this.requestId.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivedFile waitForFile(long id, int timeout) {
        File file = null;
        int status = 2;
        long timestamp = System.currentTimeMillis();
        while (true) {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile rf = this.receivedFiles.get(id);
                if (rf != null) {
                    if (rf.getStatus() != 0) {
                        if (rf.getStatus() == 1) {
                            file = rf.getFile();
                            status = 0;
                        }
                        break;
                    }
                    timestamp = rf.getTimestamp();
                }
                if (System.currentTimeMillis() - timestamp > (long)timeout) {
                    status = 3;
                    break;
                }
                try {
                    this.receivedFiles.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return new ReceivedFile(file, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForFileTail(String fileName, int timeout) {
        int timeRemaining = timeout;
        String tail = null;
        while (timeRemaining > 0) {
            Map<String, String> map = this.receivedFileUpdates;
            synchronized (map) {
                tail = this.receivedFileUpdates.get(fileName);
                if (tail != null) {
                    this.receivedFileUpdates.remove(fileName);
                    break;
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.receivedFileUpdates.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeRemaining = (int)((long)timeRemaining - (System.currentTimeMillis() - startTime));
            }
        }
        return tail;
    }

    protected void executeSimpleCommand(int command2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(command2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Table receiveTable(long requestId, int msgCode) throws NXCException {
        NXCPMessage msg2 = this.waitForMessage(msgCode, requestId);
        Table table = new Table(msg2);
        while (!msg2.isEndOfSequence()) {
            msg2 = this.waitForMessage(msgCode, requestId);
            table.addDataFromMessage(msg2);
        }
        return table;
    }

    public void connect() throws IOException, UnknownHostException, NXCException, IllegalStateException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int[] componentVersions) throws IOException, UnknownHostException, NXCException, IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException("Session already connected");
        }
        if (this.disconnected) {
            throw new IllegalStateException("Session already disconnected and cannot be reused");
        }
        this.encryptionContext = null;
        logger.info("Connecting to " + this.connAddress + ":" + this.connPort);
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.connAddress, this.connPort), this.connectTimeout);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            this.housekeeperThread = new HousekeeperThread();
            new NotificationProcessor();
            new BackgroundUserSync();
            logger.debug("Connection established, retrieving server info");
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            this.protocolVersion = new ProtocolVersion(response);
            if (!this.ignoreProtocolVersion) {
                if (!this.protocolVersion.isCorrectVersion(0) || componentVersions != null && !this.validateProtocolVersions(componentVersions)) {
                    logger.warn("Connection failed (" + this.protocolVersion.toString() + ")");
                    throw new NXCException(40, this.protocolVersion.toString());
                }
            } else {
                logger.info("Protocol version ignored");
            }
            this.serverVersion = response.getFieldAsString(121L);
            this.serverId = response.getFieldAsInt64(142L);
            this.serverTimeZone = response.getFieldAsString(308L);
            this.serverTime = response.getFieldAsInt64(94L) * 1000L;
            this.serverTimeRecvTime = System.currentTimeMillis();
            this.serverChallenge = response.getFieldAsBinary(278L);
            this.tileServerURL = response.getFieldAsString(384L);
            if (this.tileServerURL != null) {
                if (!this.tileServerURL.endsWith("/")) {
                    this.tileServerURL = this.tileServerURL.concat("/");
                }
            } else {
                this.tileServerURL = "http://tile.openstreetmap.org/";
            }
            this.dateFormat = response.getFieldAsString(421L);
            if (this.dateFormat == null || this.dateFormat.length() == 0) {
                this.dateFormat = "dd.MM.yyyy";
            }
            this.timeFormat = response.getFieldAsString(422L);
            if (this.timeFormat == null || this.timeFormat.length() == 0) {
                this.timeFormat = "HH:mm:ss";
            }
            this.shortTimeFormat = response.getFieldAsString(453L);
            if (this.shortTimeFormat == null || this.shortTimeFormat.length() == 0) {
                this.shortTimeFormat = "HH:mm";
            }
            int count2 = response.getFieldAsInt32(560L);
            long fieldId = 0x20000000L;
            for (int i = 0; i < count2; ++i) {
                this.serverComponents.add(response.getFieldAsString(fieldId++));
            }
            if (this.connUseEncryption) {
                request = this.newMessage(133);
                request.setFieldInt16(319L, 1);
                this.sendMessage(request);
                this.waitForRCC(request.getMessageId());
            }
            logger.info("Connected to server version " + this.serverVersion);
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.disconnect(2002);
            }
        }
    }

    public void login(String login, String password) throws NXCException, IOException, IllegalStateException {
        this.login(AuthenticationType.PASSWORD, login, password, null, null, null);
    }

    public void login(String token2) throws NXCException, IOException, IllegalStateException {
        this.login(AuthenticationType.TOKEN, token2, null, null, null, null);
    }

    public void login(String login, Certificate certificate, Signature signature) throws NXCException, IOException, IllegalStateException {
        this.login(AuthenticationType.CERTIFICATE, login, null, certificate, signature, null);
    }

    public void login(AuthenticationType authType, String login, String password, Certificate certificate, Signature signature, TwoFactorAuthenticationCallback twoFactorAuthenticationCallback) throws NXCException, IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Session not connected");
        }
        if (this.disconnected) {
            throw new IllegalStateException("Session already disconnected and cannot be reused");
        }
        this.authenticationMethod = authType;
        this.userName = login;
        NXCPMessage request = this.newMessage(1);
        request.setFieldInt16(275L, authType.getValue());
        request.setField(1L, login);
        if (authType == AuthenticationType.PASSWORD || authType == AuthenticationType.SSO_TICKET) {
            request.setField(2L, password);
        } else if (authType == AuthenticationType.CERTIFICATE) {
            if (this.serverChallenge == null || signature == null || certificate == null) {
                throw new NXCException(98);
            }
            byte[] signedChallenge = this.signChallenge(signature, this.serverChallenge);
            request.setField(277L, signedChallenge);
            try {
                request.setField(276L, certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new NXCException(98);
            }
        }
        request.setField(177L, VersionInfo.version());
        request.setField(175L, this.connClientInfo);
        request.setField(176L, System.getProperty("os.name") + " " + System.getProperty("os.version"));
        request.setFieldInt16(170L, this.clientType);
        if (this.clientAddress != null) {
            logger.debug("Client address provided: " + this.clientAddress);
            request.setField(452L, this.clientAddress);
        }
        if (this.clientLanguage != null) {
            request.setField(479L, this.clientLanguage);
        }
        request.setFieldInt16(570L, 1);
        this.sendMessage(request);
        NXCPMessage response = this.waitForMessage(29, request.getMessageId());
        int rcc = response.getFieldAsInt32(28L);
        logger.debug("CMD_LOGIN_RESP received, RCC=" + rcc);
        if (rcc == 147 && twoFactorAuthenticationCallback != null) {
            logger.info("Two factor authentication requested by server");
            List<String> methods = response.getStringListFromFields(0x10000000L, 751L);
            int selectedMethod = twoFactorAuthenticationCallback.selectMethod(methods);
            logger.debug("Selected method " + selectedMethod);
            if (selectedMethod >= 0 && selectedMethod < methods.size()) {
                request = this.newMessage(430);
                request.setField(752L, methods.get(selectedMethod));
                this.sendMessage(request);
                response = this.waitForMessage(29, request.getMessageId());
                rcc = response.getFieldAsInt32(28L);
                logger.debug("Two factor challenge preparation completed, RCC=" + rcc);
                if (rcc == 0) {
                    String challenge = response.getFieldAsString(278L);
                    String qrLabel = response.getFieldAsString(787L);
                    String userResponse = twoFactorAuthenticationCallback.getUserResponse(challenge, qrLabel);
                    request = this.newMessage(431);
                    request.setField(753L, userResponse);
                    this.sendMessage(request);
                    response = this.waitForMessage(29, request.getMessageId());
                    rcc = response.getFieldAsInt32(28L);
                    logger.debug("Two factor validation response received, RCC=" + rcc);
                }
            }
        }
        if (rcc != 0) {
            logger.warn("Login failed, RCC=" + rcc);
            throw new NXCException(rcc);
        }
        this.userId = response.getFieldAsInt32(35L);
        this.sessionId = response.getFieldAsInt32(209L);
        this.userSystemRights = response.getFieldAsInt64(36L);
        this.passwordExpired = response.getFieldAsBoolean(221L);
        this.graceLogins = response.getFieldAsInt32(576L);
        this.zoningEnabled = response.getFieldAsBoolean(148L);
        this.helpdeskLinkActive = response.getFieldAsBoolean(470L);
        if (response.isFieldPresent(34L)) {
            this.userName = response.getFieldAsString(34L);
        }
        this.defaultDciPollingInterval = response.getFieldAsInt32(44L);
        if (this.defaultDciPollingInterval == 0) {
            this.defaultDciPollingInterval = 60;
        }
        this.defaultDciRetentionTime = response.getFieldAsInt32(45L);
        if (this.defaultDciRetentionTime == 0) {
            this.defaultDciRetentionTime = 30;
        }
        this.minViewRefreshInterval = response.getFieldAsInt32(473L);
        if (this.minViewRefreshInterval <= 0) {
            this.minViewRefreshInterval = 200;
        }
        this.strictAlarmStatusFlow = response.getFieldAsBoolean(461L);
        this.timedAlarmAckEnabled = response.getFieldAsBoolean(465L);
        this.serverCommandOutputTimeout = response.getFieldAsInt32(514L) * 1000;
        this.serverColor = response.getFieldAsString(562L);
        this.serverName = response.getFieldAsString(561L);
        if (this.serverName == null || this.serverName.isEmpty()) {
            this.serverName = this.connAddress;
        }
        int count2 = response.getFieldAsInt32(478L);
        this.clientConfigurationHints.put("AlarmList.DisplayLimit", Integer.toString(count2));
        count2 = response.getFieldAsInt32(618L);
        if (count2 > 0) {
            long fieldId = 0x10000000L;
            for (int i = 0; i < count2; ++i) {
                String key = response.getFieldAsString(fieldId++);
                String value = response.getFieldAsString(fieldId++);
                this.clientConfigurationHints.put(key, value);
                logger.info("Configuration hint: " + key + " = " + value);
            }
        }
        this.messageOfTheDay = response.getFieldAsString(563L);
        String tags = response.getFieldAsString(791L);
        if (tags != null) {
            String[] elements;
            for (String e : elements = tags.split(",")) {
                this.responsibleUserTags.add(e.trim());
            }
        }
        if ((count2 = response.getFieldAsInt32(708L)) > 0) {
            this.licenseProblems = new LicenseProblem[count2];
            long fieldId = 0x28000000L;
            for (int i = 0; i < count2; ++i) {
                this.licenseProblems[i] = new LicenseProblem(response, fieldId);
                ++fieldId;
                logger.warn("License problem reported by server: " + this.licenseProblems[i].getDescription());
            }
        }
        this.allowCompression = response.getFieldAsBoolean(570L);
        logger.info("Succesfully logged in, userId=" + this.userId);
    }

    private void backgroundDisconnect(final int reason) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                NXCSession.this.disconnect(reason);
            }
        }, "NXCSession disconnect");
        t.setDaemon(true);
        t.start();
    }

    private synchronized void disconnect(int reason) {
        if (this.disconnected) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notificationQueue.clear();
        if (reason != 2002) {
            this.notificationQueue.offer(new SessionNotification(reason));
        }
        this.notificationQueue.offer(new SessionNotification(Short.MAX_VALUE));
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.recvThread = null;
        }
        if (this.housekeeperThread != null) {
            this.housekeeperThread.setStopFlag(true);
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.housekeeperThread = null;
        }
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.connected = false;
        this.disconnected = true;
        this.socket = null;
        this.listeners.clear();
        this.consoleListeners.clear();
        this.messageSubscriptions.clear();
        this.receivedFiles.clear();
        this.receivedFileUpdates.clear();
        this.objectList.clear();
        this.objectListGUID.clear();
        this.zoneList.clear();
        this.eventTemplates.clear();
        this.userDatabase.clear();
        this.userDatabaseGUID.clear();
        this.alarmCategories.clear();
        this.tcpProxies.clear();
    }

    public void disconnect() {
        this.disconnect(2002);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isEncrypted() {
        return this.connUseEncryption;
    }

    public boolean isIgnoreProtocolVersion() {
        return this.ignoreProtocolVersion;
    }

    public void setIgnoreProtocolVersion(boolean ignoreProtocolVersion) {
        this.ignoreProtocolVersion = ignoreProtocolVersion;
    }

    public boolean validateProtocolVersions(int[] versions) {
        if (this.protocolVersion == null) {
            return false;
        }
        for (int index : versions) {
            if (this.protocolVersion.isCorrectVersion(index)) continue;
            return false;
        }
        return true;
    }

    public int getDefaultRecvBufferSize() {
        return this.defaultRecvBufferSize;
    }

    public int getMaxRecvBufferSize() {
        return this.maxRecvBufferSize;
    }

    public void setRecvBufferSize(int defaultBufferSize, int maxBufferSize) {
        this.defaultRecvBufferSize = defaultBufferSize;
        this.maxRecvBufferSize = maxBufferSize;
    }

    public String getServerAddress() {
        return this.connAddress;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public long getServerId() {
        return this.serverId;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerColor() {
        return this.serverColor;
    }

    public long getServerTime() {
        long offset = System.currentTimeMillis() - this.serverTimeRecvTime;
        return this.serverTime + offset;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public boolean isServerComponentRegistered(String componentId) {
        return this.serverComponents.contains(componentId);
    }

    public String[] getRegisteredServerComponents() {
        return this.serverComponents.toArray(new String[this.serverComponents.size()]);
    }

    public String getTileServerURL() {
        return this.tileServerURL;
    }

    public boolean isZoningEnabled() {
        return this.zoningEnabled;
    }

    public boolean isHelpdeskLinkActive() {
        return this.helpdeskLinkActive;
    }

    public String getClientInfo() {
        return this.connClientInfo;
    }

    public void setClientInfo(String connClientInfo) {
        this.connClientInfo = connClientInfo;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public AuthenticationType getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public long getUserSystemRights() {
        return this.userSystemRights;
    }

    public String getMessageOfTheDay() {
        return this.messageOfTheDay;
    }

    public LicenseProblem[] getLicenseProblems() {
        return this.licenseProblems;
    }

    public boolean hasLicenseProblems() {
        return this.licenseProblems != null && this.licenseProblems.length > 0;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public int getGraceLogins() {
        return this.graceLogins;
    }

    public int getAlarmListDisplayLimit() {
        return this.getClientConfigurationHintAsInt("AlarmList.DisplayLimit", 4096);
    }

    public String getClientConfigurationHint(String name, String defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        return v != null ? v : defaultValue;
    }

    public String getClientConfigurationHint(String name) {
        return this.getClientConfigurationHint(name, null);
    }

    public int getClientConfigurationHintAsInt(String name, int defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getClientConfigurationHintAsBoolean(String name, boolean defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        if (v == null) {
            return defaultValue;
        }
        if (v.equalsIgnoreCase("true")) {
            return true;
        }
        if (v.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Integer.parseInt(v) != 0;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Set<String> getResponsibleUserTags() {
        return new HashSet<String>(this.responsibleUserTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncObjectCategories() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(201);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        Map<Integer, ObjectCategory> map = this.objectCategories;
        synchronized (map) {
            this.objectCategories.clear();
            int count2 = response.getFieldAsInt32(361L);
            long fieldId = 0x10000000L;
            int i = 0;
            while (i < count2) {
                ObjectCategory category = new ObjectCategory(response, fieldId);
                this.objectCategories.put(category.getId(), category);
                ++i;
                fieldId += 10L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCategory getObjectCategory(int categoryId) {
        Map<Integer, ObjectCategory> map = this.objectCategories;
        synchronized (map) {
            return this.objectCategories.get(categoryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectCategory> getObjectCategories() {
        Map<Integer, ObjectCategory> map = this.objectCategories;
        synchronized (map) {
            return new ArrayList<ObjectCategory>(this.objectCategories.values());
        }
    }

    public int modifyObjectCategory(MutableObjectCategory category) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(202);
        category.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt32(104L);
    }

    public void deleteObjectCategory(int categoryId, boolean forceDelete) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(203);
        msg2.setFieldInt32(104L, categoryId);
        msg2.setField(720L, forceDelete);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void syncObjects() throws IOException, NXCException {
        this.syncObjects(true);
    }

    public void syncObjects(boolean syncNodeComponents) throws IOException, NXCException {
        this.syncObjectCategories();
        this.syncObjects.acquireUninterruptibly();
        NXCPMessage msg2 = this.newMessage(5);
        msg2.setField(254L, true);
        msg2.setField(679L, syncNodeComponents);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.waitForSync(this.syncObjects, this.commandTimeout * 10);
        this.objectsSynchronized = this.objectsSynchronized || syncNodeComponents;
        this.sendNotification(new SessionNotification(2001));
        this.subscribe(CHANNEL_OBJECTS);
    }

    public void syncObjectSet(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncObjectSet(objects, syncComments, 0);
    }

    public void syncObjectSet(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(249);
        msg2.setField(254L, syncComments);
        msg2.setFieldInt16(13L, options);
        msg2.setFieldInt32(138L, objects.length);
        msg2.setField(139L, objects);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        if ((options & 2) != 0) {
            this.waitForRCC(msg2.getMessageId());
        }
    }

    public void syncMissingObjects(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncMissingObjects(objects, syncComments, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMissingObjects(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        long[] syncList = Arrays.copyOf(objects, objects.length);
        int count2 = syncList.length;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < syncList.length; ++i) {
                if (!this.objectList.containsKey(syncList[i])) continue;
                syncList[i] = 0L;
                --count2;
            }
        }
        if (count2 > 0) {
            this.syncObjectSet(syncList, syncComments, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMissingObjects(List<Long> objects, boolean syncComments, int options) throws IOException, NXCException {
        long[] syncList = new long[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            syncList[i] = objects.get(i);
        }
        int count2 = syncList.length;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < syncList.length; ++i) {
                if (!this.objectList.containsKey(syncList[i])) continue;
                syncList[i] = 0L;
                --count2;
            }
        }
        if (count2 > 0) {
            this.syncObjectSet(syncList, syncComments, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncChildren(AbstractObject object) throws NXCException, IOException {
        boolean syncRequired;
        if (this.objectsSynchronized) {
            return;
        }
        Set<Long> set = this.synchronizedObjectSet;
        synchronized (set) {
            syncRequired = !this.synchronizedObjectSet.contains(object.getObjectId());
        }
        if (syncRequired) {
            this.syncMissingObjects(object.getChildIdList(), true, 2);
            set = this.synchronizedObjectSet;
            synchronized (set) {
                this.synchronizedObjectSet.add(object.getObjectId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildrenSynchronized(long id) {
        Set<Long> set = this.synchronizedObjectSet;
        synchronized (set) {
            return this.objectsSynchronized || this.synchronizedObjectSet.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> findObjectByRegex(String regex) {
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>();
        Matcher matcher = Pattern.compile(regex).matcher("");
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject o : this.objectList.values()) {
                matcher.reset(o.getObjectName());
                if (!matcher.matches()) continue;
                objects.add(o);
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectById(long id) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.objectList.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureObject findFutureObjectById(final long id) {
        FutureObject object;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            AbstractObject result2 = this.objectList.get(id);
            if (result2 == null) {
                object = new FutureObject();
                this.addListener(new SessionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void notificationHandler(SessionNotification n) {
                        if (n.code == 4 && n.subCode == id) {
                            FutureObject futureObject = object;
                            synchronized (futureObject) {
                                object.setObject((AbstractObject)n.object);
                                object.notifyAll();
                            }
                            NXCSession.this.removeListener(this);
                        }
                    }
                });
            } else {
                object = new FutureObject(result2);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findObjectAsync(final long id, final ObjectCreationListener callback) {
        if (callback == null) {
            return;
        }
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            AbstractObject object = this.objectList.get(id);
            if (object == null) {
                this.addListener(new SessionListener(){

                    @Override
                    public void notificationHandler(SessionNotification n) {
                        if (n.code == 4 && n.subCode == id) {
                            callback.objectCreated(NXCSession.this.findObjectById(id));
                            NXCSession.this.removeListener(this);
                        }
                    }
                });
            } else {
                callback.objectCreated(object);
            }
        }
    }

    public <T> T findObjectById(long id, Class<T> requiredClass) {
        AbstractObject object = this.findObjectById(id);
        return (T)(requiredClass.isInstance(object) ? object : null);
    }

    public List<AbstractObject> findMultipleObjects(long[] idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> findMultipleObjects(long[] idList, Class<? extends AbstractObject> classFilter, boolean returnUnknown) {
        ArrayList<AbstractObject> result2 = new ArrayList<AbstractObject>(idList.length);
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < idList.length; ++i) {
                AbstractObject object = this.objectList.get(idList[i]);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result2.add(object);
                    continue;
                }
                if (!returnUnknown) continue;
                result2.add(new UnknownObject(idList[i], this));
            }
        }
        return result2;
    }

    public List<AbstractObject> findMultipleObjects(Collection<Long> idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> findMultipleObjects(Collection<Long> idList, Class<? extends AbstractObject> classFilter, boolean returnUnknown) {
        ArrayList<AbstractObject> result2 = new ArrayList<AbstractObject>(idList.size());
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (Long id : idList) {
                AbstractObject object = this.objectList.get(id);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result2.add(object);
                    continue;
                }
                if (!returnUnknown) continue;
                result2.add(new UnknownObject(id, this));
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByGUID(UUID guid) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.objectListGUID.get(guid);
        }
    }

    public <T extends AbstractObject> T findObjectByGUID(UUID guid, Class<T> requiredClass) {
        AbstractObject object = this.findObjectByGUID(guid);
        return (T)(requiredClass.isInstance(object) ? object : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zone findZone(int zoneUIN) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.zoneList.get(zoneUIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Zone> getAllZones() {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return new ArrayList<Zone>(this.zoneList.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByName(String name) {
        AbstractObject result2 = null;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!object.getObjectName().equalsIgnoreCase(name)) continue;
                result2 = object;
                break;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByName(String name, ObjectFilter filter) {
        AbstractObject result2 = null;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!object.getObjectName().equalsIgnoreCase(name) || !filter.filter(object)) continue;
                result2 = object;
                break;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByNamePattern(String pattern) {
        AbstractObject result2 = null;
        Matcher matcher = Pattern.compile(pattern).matcher("");
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                matcher.reset(object.getObjectName());
                if (!matcher.matches()) continue;
                result2 = object;
                break;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObject(ObjectFilter filter) {
        AbstractObject result2 = null;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!filter.filter(object)) continue;
                result2 = object;
                break;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> filterObjects(ObjectFilter filter) {
        ArrayList<AbstractObject> result2 = new ArrayList<AbstractObject>();
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!filter.filter(object)) continue;
                result2.add(object);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getTopLevelObjects(Set<Integer> classFilter) {
        HashSet<AbstractObject> list = new HashSet<AbstractObject>();
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (classFilter != null && !classFilter.contains(object.getObjectClass())) continue;
                if (!object.hasParents()) {
                    list.add(object);
                    continue;
                }
                boolean hasParents = false;
                Iterator<Long> it = object.getParents();
                while (it.hasNext()) {
                    Long parent = it.next();
                    if (classFilter != null) {
                        AbstractObject p = this.objectList.get(parent);
                        if (p == null || !classFilter.contains(p.getObjectClass())) continue;
                        hasParents = true;
                        break;
                    }
                    if (!this.objectList.containsKey(parent)) continue;
                    hasParents = true;
                    break;
                }
                if (hasParents) continue;
                list.add(object);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public AbstractObject[] getTopLevelObjects() {
        return this.getTopLevelObjects(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> getAllObjects() {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return new ArrayList<AbstractObject>(this.objectList.values());
        }
    }

    public String getObjectName(long objectId) {
        AbstractObject object = this.findObjectById(objectId);
        return object != null ? object.getObjectName() : "[" + Long.toString(objectId) + "]";
    }

    public String getZoneName(int zoneUIN) {
        Zone zone = this.findZone(zoneUIN);
        return zone != null ? zone.getObjectName() : "[" + Long.toString(zoneUIN) + "]";
    }

    public List<AbstractObject> queryObjects(String query) throws IOException, NXCException {
        NXCPMessage request = this.newMessage(362);
        request.setField(617L, query);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        return this.findMultipleObjects(response.getFieldAsUInt32Array(139L), false);
    }

    public List<ObjectQueryResult> queryObjectDetails(String query, List<String> properties, List<String> orderBy, Map<String, String> inputFields, boolean readAllComputedProperties, int limit) throws IOException, NXCException {
        NXCPMessage request = this.newMessage(363);
        request.setField(617L, query);
        if (properties != null) {
            request.setFieldsFromStringCollection(properties, 0x70000000L, 337L);
        }
        if (orderBy != null) {
            request.setFieldsFromStringCollection(orderBy, 0x78000000L, 632L);
        }
        if (inputFields != null) {
            request.setFieldsFromStringMap(inputFields, 0x20000000L, 603L);
        }
        request.setFieldInt32(633L, limit);
        request.setField(750L, readAllComputedProperties);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        long[] objects = response.getFieldAsUInt32Array(139L);
        ArrayList<ObjectQueryResult> results = new ArrayList<ObjectQueryResult>(objects.length);
        long fieldId = 0x10000000L;
        for (int i = 0; i < objects.length; ++i) {
            Map<String, String> values = response.getStringMapFromFields(fieldId + 1L, fieldId);
            AbstractObject object = this.findObjectById(objects[i]);
            if (object != null) {
                results.add(new ObjectQueryResult(object, values));
            }
            fieldId += (long)(values.size() * 2 + 1);
        }
        return results;
    }

    public List<ObjectQuery> getObjectQueries() throws IOException, NXCException {
        NXCPMessage request = this.newMessage(329);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<ObjectQuery> queries = new ArrayList<ObjectQuery>(count2);
        long[] fieldId = new long[]{0x10000000L};
        for (int i = 0; i < count2; ++i) {
            queries.add(new ObjectQuery(response, fieldId));
        }
        return queries;
    }

    public int modifyObjectQuery(ObjectQuery query) throws IOException, NXCException {
        NXCPMessage request = this.newMessage(330);
        query.fillMessage(request);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        return response.getFieldAsInt32(755L);
    }

    public void deleteObjectQuery(int queryId) throws IOException, NXCException {
        NXCPMessage request = this.newMessage(331);
        request.setFieldInt32(755L, queryId);
        this.sendMessage(request);
        this.waitForRCC(request.getMessageId());
    }

    public HashMap<Long, Alarm> getAlarms() throws IOException, NXCException {
        long alarmId;
        NXCPMessage request = this.newMessage(70);
        long rqId = request.getMessageId();
        this.sendMessage(request);
        HashMap<Long, Alarm> alarmList = new HashMap<Long, Alarm>(0);
        while ((alarmId = (long)(request = this.waitForMessage(74, rqId)).getFieldAsInt32(93L)) != 0L) {
            alarmList.put(alarmId, new Alarm(request));
        }
        return alarmList;
    }

    public Alarm getAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(259);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Alarm(response);
    }

    public List<EventInfo> getAlarmEvents(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(267);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<EventInfo> list = new ArrayList<EventInfo>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            EventInfo parent = null;
            long rootId = response.getFieldAsInt64(varId + 1L);
            if (rootId != 0L) {
                for (EventInfo e : list) {
                    if (e.getId() != rootId) continue;
                    parent = e;
                    break;
                }
            }
            list.add(new EventInfo(response, varId, parent));
            varId += 10L;
        }
        return list;
    }

    public void acknowledgeAlarm(long alarmId, boolean sticky, int time) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(72);
        msg2.setFieldInt32(93L, (int)alarmId);
        msg2.setFieldInt16(320L, sticky ? 1 : 0);
        msg2.setFieldInt32(94L, time);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void acknowledgeAlarm(long alarmId) throws IOException, NXCException {
        this.acknowledgeAlarm(alarmId, false, 0);
    }

    public void acknowledgeAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(72);
        msg2.setField(247L, helpdeskReference);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void resolveAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(263);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void resolveAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(263);
        msg2.setField(247L, helpdeskReference);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void terminateAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(181);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void terminateAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(181);
        msg2.setField(247L, helpdeskReference);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    private Map<Long, Integer> bulkAlarmOperation(int cmd2, List<Long> alarmIds) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(cmd2);
        msg2.setField(559L, alarmIds.toArray(new Long[alarmIds.size()]));
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        HashMap<Long, Integer> operationFails = new HashMap<Long, Integer>();
        if (response.findField(559L) != null) {
            for (int i = 0; i < response.getFieldAsUInt32ArrayEx(559L).length; ++i) {
                operationFails.put(response.getFieldAsUInt32ArrayEx(559L)[i], response.getFieldAsUInt32ArrayEx(553L)[i].intValue());
            }
        }
        return operationFails;
    }

    public Map<Long, Integer> bulkResolveAlarms(List<Long> alarmIds) throws IOException, NXCException {
        return this.bulkAlarmOperation(344, alarmIds);
    }

    public Map<Long, Integer> bulkTerminateAlarms(List<Long> alarmIds) throws IOException, NXCException {
        return this.bulkAlarmOperation(343, alarmIds);
    }

    public void deleteAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(75);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public String openHelpdeskIssue(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(4);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsString(247L);
    }

    public String getHelpdeskIssueUrl(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(292);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsString(471L);
    }

    public void unlinkHelpdeskIssue(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(293);
        msg2.setField(247L, helpdeskReference);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void unlinkHelpdeskIssue(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(293);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<AlarmComment> getAlarmComments(long alarmId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(71);
        msg2.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<AlarmComment> comments = new ArrayList<AlarmComment>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            comments.add(new AlarmComment(response, varId));
            varId += 10L;
        }
        return comments;
    }

    public void deleteAlarmComment(long alarmId, long commentId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(289);
        msg2.setFieldInt32(93L, (int)alarmId);
        msg2.setFieldInt32(410L, (int)commentId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void createAlarmComment(long alarmId, String text2) throws IOException, NXCException {
        this.updateAlarmComment(alarmId, 0L, text2);
    }

    public void createAlarmComment(String helpdeskReference, String text2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(258);
        msg2.setFieldInt32(93L, 0);
        msg2.setField(247L, helpdeskReference);
        msg2.setField(82L, text2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void updateAlarmComment(long alarmId, long commentId, String text2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(258);
        msg2.setFieldInt32(93L, (int)alarmId);
        msg2.setFieldInt32(410L, (int)commentId);
        msg2.setField(82L, text2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setAlarmFlowState(int state) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(288);
        msg2.setFieldInt32(461L, state);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<String, ServerVariable> getServerVariables() throws IOException, NXCException {
        NXCPMessage request = this.newMessage(13);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        int count2 = response.getFieldAsInt32(144L);
        HashMap<String, ServerVariable> varList = new HashMap<String, ServerVariable>(count2);
        long id = 0x10000000L;
        int i = 0;
        while (i < count2) {
            ServerVariable v = new ServerVariable(response, id);
            varList.put(v.getName(), v);
            ++i;
            id += 10L;
        }
        count2 = response.getFieldAsInt32(566L);
        for (i = 0; i < count2; ++i) {
            ServerVariable var;
            if ((var = varList.get(response.getFieldAsString(id++))) != null) {
                var.addPossibleValue(response, id);
            }
            id += 2L;
        }
        return varList;
    }

    public String getPublicServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(313);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(21L);
    }

    public int getPublicServerVariableAsInt(String name) throws IOException, NXCException {
        return Integer.parseInt(this.getPublicServerVariable(name));
    }

    public boolean getPublicServerVariableAsBoolean(String name) throws IOException, NXCException {
        String value = this.getPublicServerVariable(name);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        try {
            int n = Integer.parseInt(value);
            return n != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setServerVariable(String name, String value) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(14);
        msg2.setField(20L, name);
        msg2.setField(21L, value);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(17);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setDefaultServerValues(List<ServerVariable> varList) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(139);
        long base2 = 0x10000000L;
        for (ServerVariable v : varList) {
            msg2.setField(base2++, v.getName());
        }
        msg2.setFieldInt32(144L, varList.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public String getServerConfigClob(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(226);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(21L);
    }

    public void setServerConfigClob(String name, String value) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(225);
        msg2.setField(20L, name);
        msg2.setField(21L, value);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void subscribe(String channel) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(138);
        msg2.setField(20L, channel);
        msg2.setFieldInt16(172L, 1);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void unsubscribe(String channel) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(138);
        msg2.setField(20L, channel);
        msg2.setFieldInt16(172L, 0);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void syncUserDatabase() throws IOException, NXCException {
        this.syncUserDB.acquireUninterruptibly();
        NXCPMessage msg2 = this.newMessage(30);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.waitForSync(this.syncUserDB, this.commandTimeout * 10);
        this.userDatabaseSynchronized = true;
        this.subscribe(CHANNEL_USERDB);
    }

    public void subscribeToUserDBUpdates() throws IOException, NXCException {
        this.subscribe(CHANNEL_USERDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUserSet(Set<Long> users) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(113);
        msg2.setFieldInt32(138L, users.size());
        msg2.setField(139L, users);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.waitForRCC(msg2.getMessageId());
        Map<Long, AbstractUserObject> map = this.userDatabase;
        synchronized (map) {
            for (Long id : users) {
                if (this.userDatabase.containsKey(id)) {
                    this.missingUsers.remove(id);
                    continue;
                }
                this.missingUsers.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncMissingUsers(Set<Long> users) throws IOException, NXCException {
        if (this.userDatabaseSynchronized) {
            return false;
        }
        HashSet<Long> syncSet = new HashSet<Long>();
        Map<Long, AbstractUserObject> map = this.userDatabase;
        synchronized (map) {
            for (Long id : users) {
                if (this.userDatabase.containsKey(id)) continue;
                syncSet.add(id);
            }
        }
        if (!syncSet.isEmpty()) {
            this.syncUserSet(syncSet);
        }
        return !syncSet.isEmpty();
    }

    public boolean isUserDatabaseSynchronized() {
        return this.userDatabaseSynchronized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractUserObject> findUserDBObjectsByIds(Collection<Long> ids) {
        ArrayList<AbstractUserObject> users = new ArrayList<AbstractUserObject>();
        Map<Long, AbstractUserObject> map = this.userDatabase;
        synchronized (map) {
            for (Long l : ids) {
                AbstractUserObject user2 = this.userDatabase.get(l);
                if (user2 == null) continue;
                users.add(user2);
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject findUserDBObjectById(long id, Runnable callback) {
        AbstractUserObject object = null;
        boolean needSync = false;
        Object object2 = this.userDatabase;
        synchronized (object2) {
            object = this.userDatabase.get(id);
            if (object == null && !this.userDatabaseSynchronized && !this.missingUsers.contains(id)) {
                needSync = true;
            }
        }
        if (needSync) {
            object2 = this.userSyncList;
            synchronized (object2) {
                this.userSyncList.add(id);
                if (callback != null) {
                    this.callbackList.add(callback);
                }
                this.userSyncList.notifyAll();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject findUserDBObjectByGUID(UUID guid) {
        Map<Long, AbstractUserObject> map = this.userDatabase;
        synchronized (map) {
            return this.userDatabaseGUID.get(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject[] getUserDatabaseObjects() {
        AbstractUserObject[] list;
        Map<Long, AbstractUserObject> map = this.userDatabase;
        synchronized (map) {
            Collection<AbstractUserObject> values = this.userDatabase.values();
            list = values.toArray(new AbstractUserObject[values.size()]);
        }
        return list;
    }

    private long createUserDBObject(String name, boolean isGroup) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(36);
        msg2.setField(34L, name);
        msg2.setField(39L, isGroup);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(35L);
    }

    public long createUser(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, false);
    }

    public long createUserGroup(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, true);
    }

    public void deleteUserDBObject(long id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(35);
        msg2.setFieldInt32(35L, (int)id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setUserPassword(long id, String newPassword, String oldPassword) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(40);
        msg2.setFieldInt32(35L, (int)id);
        msg2.setField(2L, newPassword);
        if (oldPassword != null) {
            msg2.setField(349L, oldPassword);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public boolean validateUserPassword(String password) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(316);
        msg2.setField(2L, password);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsBoolean(508L);
    }

    public void modifyUserDBObject(AbstractUserObject object, int fields) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(34);
        msg2.setFieldInt32(337L, fields);
        object.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifyUserDBObject(AbstractUserObject object) throws IOException, NXCException {
        this.modifyUserDBObject(object, Integer.MAX_VALUE);
    }

    public void detachUserFromLdap(long userId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(315);
        msg2.setFieldInt32(35L, (int)userId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setAttributeForCurrentUser(String name, String value) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(69);
        msg2.setField(20L, name);
        msg2.setField(21L, value);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public String getAttributeForCurrentUser(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(68);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(21L);
    }

    public List<DciValue> findMatchingDCI(long objectId, String objectName, String dciName, int flags) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(380);
        if (objectId != 0L) {
            msg2.setFieldInt32(3L, (int)objectId);
        } else {
            msg2.setField(4L, objectName);
        }
        msg2.setField(600L, dciName);
        msg2.setFieldInt32(13L, flags);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        ArrayList<DciValue> result2 = new ArrayList<DciValue>(count2);
        Long base2 = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            result2.add(new SimpleDciValue(response, base2));
            base2 = base2 + 50L;
        }
        return result2;
    }

    public DciValue[] getLastValues(long nodeId, boolean objectTooltipOnly, boolean overviewOnly, boolean includeNoValueObjects) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(121);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(443L, objectTooltipOnly);
        msg2.setField(502L, overviewOnly);
        msg2.setField(481L, includeNoValueObjects);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        DciValue[] list = new DciValue[count2];
        long base2 = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list[i] = DciValue.createFromMessage(response, base2);
            ++i;
            base2 += 50L;
        }
        return list;
    }

    public DciValue[] getLastValues(long nodeId) throws IOException, NXCException {
        return this.getLastValues(nodeId, false, false, false);
    }

    public Map<Long, DciValue[]> getTooltipLastValues(Set<Long> nodeList) throws IOException, NXCException {
        HashMap<Long, DciValue[]> cachedDciValues = new HashMap<Long, DciValue[]>();
        NXCPMessage msg2 = this.newMessage(428);
        msg2.setField(139L, nodeList.toArray(new Long[nodeList.size()]));
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        long base2 = 0x10000000L;
        ArrayList<SimpleDciValue> values = null;
        Long nodeId = 0L;
        int i = 0;
        while (i < count2) {
            SimpleDciValue v = new SimpleDciValue(response, base2);
            if (nodeId.longValue() != v.getNodeId()) {
                if (nodeId != 0L) {
                    cachedDciValues.put(nodeId, values.toArray(new DciValue[values.size()]));
                }
                values = new ArrayList<SimpleDciValue>();
                nodeId = v.getNodeId();
            }
            values.add(v);
            ++i;
            base2 += 50L;
        }
        if (nodeId != 0L) {
            cachedDciValues.put(nodeId, values.toArray(new DciValue[values.size()]));
        }
        return cachedDciValues;
    }

    public DciValue[] getLastValues(Set<MapDCIInstance> mapDcis) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(291);
        long base2 = 0x10000000L;
        msg2.setFieldInt32(111L, mapDcis.size());
        for (MapDCIInstance item : mapDcis) {
            item.fillMessage(msg2, base2);
            base2 += 10L;
        }
        return this.doLastValuesRequest(msg2);
    }

    public DciValue[] getLastValues(List<SingleDciConfig> dciConfig) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(291);
        long base2 = 0x10000000L;
        msg2.setFieldInt32(111L, dciConfig.size());
        for (SingleDciConfig c : dciConfig) {
            c.fillMessage(msg2, base2);
            base2 += 10L;
        }
        return this.doLastValuesRequest(msg2);
    }

    private DciValue[] doLastValuesRequest(NXCPMessage msg2) throws IOException, NXCException {
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        DciValue[] list = new DciValue[count2];
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list[i] = new SimpleDciValue(response, fieldId);
            ++i;
            fieldId += 50L;
        }
        return list;
    }

    public List<Threshold> getActiveThresholds(List<SingleDciConfig> dciConfig) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(369);
        long base2 = 0x10000000L;
        msg2.setFieldInt32(111L, dciConfig.size());
        for (SingleDciConfig c : dciConfig) {
            c.fillMessage(msg2, base2);
            base2 += 10L;
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(54L);
        ArrayList<Threshold> list = new ArrayList<Threshold>(count2);
        base2 = 0x20000000L;
        int i = 0;
        while (i < count2) {
            list.add(new Threshold(response, base2));
            ++i;
            base2 += 20L;
        }
        return list;
    }

    public Table getTableLastValues(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(260);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Table(response);
    }

    public DciLastValue getDciLastValue(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(413);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new DciLastValue(response);
    }

    public List<PerfTabDci> getPerfTabItems(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(200);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        ArrayList<PerfTabDci> list = new ArrayList<PerfTabDci>(count2);
        long baseId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list.add(new PerfTabDci(response, baseId));
            ++i;
            baseId += 50L;
        }
        return list;
    }

    public List<ThresholdViolationSummary> getThresholdSummary(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(262);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        ArrayList<ThresholdViolationSummary> list = new ArrayList<ThresholdViolationSummary>();
        long varId = 0x800000L;
        while (response.getFieldAsInt64(varId) != 0L) {
            ThresholdViolationSummary t = new ThresholdViolationSummary(response, varId);
            list.add(t);
            varId += (long)(50 * t.getDciList().size() + 2);
        }
        return list;
    }

    public int parseDataRows(byte[] input, DciData data) {
        NXCPDataInputStream inputStream = new NXCPDataInputStream(input);
        int rows = 0;
        DciDataRow row = null;
        try {
            inputStream.skipBytes(4);
            rows = inputStream.readInt();
            DataType dataType = DataType.getByValue(inputStream.readInt());
            data.setDataType(dataType);
            inputStream.skipBytes(4);
            for (int i = 0; i < rows; ++i) {
                Object value;
                long timestamp = inputStream.readUnsignedInt() * 1000L;
                switch (dataType) {
                    case INT32: {
                        value = (long)inputStream.readInt();
                        break;
                    }
                    case UINT32: 
                    case COUNTER32: {
                        value = inputStream.readUnsignedInt();
                        break;
                    }
                    case INT64: 
                    case UINT64: 
                    case COUNTER64: {
                        inputStream.skipBytes(4);
                        value = inputStream.readLong();
                        break;
                    }
                    case FLOAT: {
                        inputStream.skipBytes(4);
                        value = inputStream.readDouble();
                        break;
                    }
                    case STRING: {
                        int count2;
                        StringBuilder sb = new StringBuilder(256);
                        for (count2 = 256; count2 > 0; --count2) {
                            char ch = inputStream.readChar();
                            if (ch == '\u0000') {
                                --count2;
                                break;
                            }
                            sb.append(ch);
                        }
                        inputStream.skipBytes(count2 * 2);
                        value = sb.toString();
                        break;
                    }
                    default: {
                        value = null;
                    }
                }
                if (timestamp > 0L) {
                    row = new DciDataRow(new Date(timestamp), value);
                    data.addDataRow(row);
                    continue;
                }
                if (row == null) continue;
                row.setRawValue(value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputStream.close();
        return rows;
    }

    private DciData getCollectedDataInternal(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows, HistoricalDataType valueType) throws IOException, NXCException {
        int timeTo;
        NXCPMessage msg2;
        if (instance != null) {
            msg2 = this.newMessage(261);
            msg2.setField(116L, instance);
            msg2.setField(413L, dataColumn);
        } else {
            msg2 = this.newMessage(valueType == HistoricalDataType.FULL_TABLE ? 261 : 49);
        }
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        msg2.setFieldInt16(608L, valueType.getValue());
        DciData data = new DciData(nodeId, dciId);
        int timeFrom = from != null ? (int)(from.getTime() / 1000L) : 0;
        int n = timeTo = to != null ? (int)(to.getTime() / 1000L) : 0;
        if (valueType == HistoricalDataType.FULL_TABLE) {
            NXCPMessage response;
            long timestamp;
            msg2.setFieldInt32(50L, maxRows);
            msg2.setFieldInt32(51L, timeFrom);
            msg2.setFieldInt32(52L, timeTo);
            this.sendMessage(msg2);
            this.waitForRCC(msg2.getMessageId());
            while ((timestamp = (response = this.waitForMessage(50, msg2.getMessageId())).getFieldAsInt64(94L) * 1000L) != 0L) {
                data.addDataRow(new DciDataRow(new Date(timestamp), new Table(response)));
            }
        } else {
            int rowsReceived;
            int rowsRemaining = maxRows;
            do {
                DciDataRow row;
                msg2.setMessageId(this.requestId.getAndIncrement());
                msg2.setFieldInt32(50L, maxRows);
                msg2.setFieldInt32(51L, timeFrom);
                msg2.setFieldInt32(52L, timeTo);
                this.sendMessage(msg2);
                this.waitForRCC(msg2.getMessageId());
                NXCPMessage response = this.waitForMessage(50, msg2.getMessageId());
                if (!response.isBinaryMessage()) {
                    throw new NXCException(46);
                }
                rowsReceived = this.parseDataRows(response.getBinaryData(), data);
                if (rowsRemaining != 0 && rowsRemaining <= 200000 || rowsReceived != 200000) continue;
                if (rowsRemaining > 0) {
                    rowsRemaining -= rowsReceived;
                }
                if (to == null || (row = data.getLastValue()) == null) continue;
                timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
            } while (rowsReceived == 200000);
        }
        return data;
    }

    public DciData getCollectedData(long nodeId, long dciId, Date from, Date to, int maxRows, HistoricalDataType valueType) throws IOException, NXCException {
        return this.getCollectedDataInternal(nodeId, dciId, null, null, from, to, maxRows, valueType);
    }

    public DciData getCollectedTableData(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows) throws IOException, NXCException {
        if (instance == null || dataColumn == null) {
            throw new NXCException(12);
        }
        return this.getCollectedDataInternal(nodeId, dciId, instance, dataColumn, from, to, maxRows, HistoricalDataType.PROCESSED);
    }

    public void clearCollectedData(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(228);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteDciEntry(long nodeId, long dciId, long timestamp) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(368);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        msg2.setFieldInt32(94L, (int)timestamp);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public long recalculateDCIValues(long objectId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(11);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(331L);
    }

    public void forceDCIPoll(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(309);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Threshold[] getThresholds(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(238);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(54L);
        Threshold[] list = new Threshold[count2];
        long fieldId = 0x20000000L;
        for (int i = 0; i < count2; ++i) {
            list[i] = new Threshold(response, fieldId);
            fieldId += 20L;
        }
        return list;
    }

    public Map<Long, String> dciIdsToNames(List<Long> nodeIds, List<Long> dciIds) throws IOException, NXCException {
        if (nodeIds.isEmpty()) {
            return new HashMap<Long, String>();
        }
        NXCPMessage msg2 = this.newMessage(174);
        msg2.setFieldInt32(111L, nodeIds.size());
        msg2.setField(229L, nodeIds);
        msg2.setField(230L, dciIds);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        HashMap<Long, String> result2 = new HashMap<Long, String>();
        int size = response.getFieldAsInt32(111L);
        long fieldId = 0x40000000L;
        for (int i = 0; i < size; ++i) {
            result2.put(response.getFieldAsInt64(fieldId), response.getFieldAsString(fieldId + 1L));
            fieldId += 2L;
        }
        return result2;
    }

    public Map<Long, String> dciIdsToNames(Collection<? extends NodeItemPair> itemList) throws IOException, NXCException {
        if (itemList.isEmpty()) {
            return new HashMap<Long, String>();
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        ArrayList<Long> dciIds = new ArrayList<Long>();
        for (NodeItemPair nodeItemPair : itemList) {
            if (nodeItemPair.getNodeId() == 0L || nodeItemPair.getDciId() == 0L) continue;
            nodeIds.add(nodeItemPair.getNodeId());
            dciIds.add(nodeItemPair.getDciId());
        }
        return this.dciIdsToNames(nodeIds, dciIds);
    }

    public long dciNameToId(long nodeId, String dciName) throws IOException, NXCException {
        DciValue[] list;
        if (nodeId == 0L || dciName == null || dciName.isEmpty()) {
            return 0L;
        }
        for (DciValue dciValue : list = this.getLastValues(nodeId)) {
            if (!dciValue.getName().equals(dciName)) continue;
            return dciValue.getId();
        }
        return 0L;
    }

    public String queryParameter(long nodeId, DataOrigin origin, String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(102);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt16(46L, origin.getValue());
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(21L);
    }

    public Table queryAgentTable(long nodeId, String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(246);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Table(response);
    }

    protected void createCustomObject(NXCObjectCreationData data, Object userData, NXCPMessage msg2) {
    }

    public long createObject(NXCObjectCreationData data, Object userData) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(55);
        msg2.setFieldInt32(78L, (int)data.getParentId());
        msg2.setFieldInt16(5L, data.getObjectClass());
        msg2.setField(4L, data.getName());
        if (data.getObjectAlias() != null && !data.getObjectAlias().isEmpty()) {
            msg2.setField(494L, data.getObjectAlias());
        }
        msg2.setFieldInt32(147L, data.getZoneUIN());
        if (data.getComments() != null) {
            msg2.setField(82L, data.getComments());
        }
        switch (data.getObjectClass()) {
            case 35: {
                msg2.setFieldInt32(543L, (int)data.getControllerId());
                break;
            }
            case 3: {
                msg2.setField(113L, data.getMacAddress().getValue());
                msg2.setField(8L, data.getIpAddress());
                msg2.setFieldInt32(12L, data.getIfType());
                msg2.setFieldInt32(11L, data.getIfIndex());
                msg2.setFieldInt32(659L, data.getChassis());
                msg2.setFieldInt32(367L, data.getModule());
                msg2.setFieldInt32(660L, data.getPIC());
                msg2.setFieldInt32(368L, data.getPort());
                msg2.setFieldInt16(407L, data.isPhysicalPort() ? 1 : 0);
                break;
            }
            case 31: {
                msg2.setField(433L, data.getDeviceId());
                break;
            }
            case 2: {
                if (data.getPrimaryName() != null) {
                    msg2.setField(397L, data.getPrimaryName());
                }
                msg2.setField(8L, data.getIpAddress());
                msg2.setFieldInt16(15L, data.getAgentPort());
                msg2.setFieldInt16(80L, data.getSnmpPort());
                msg2.setFieldInt16(688L, data.getEtherNetIpPort());
                msg2.setFieldInt16(727L, data.getSshPort());
                msg2.setFieldInt32(14L, data.getCreationFlags());
                msg2.setFieldInt32(195L, (int)data.getAgentProxyId());
                msg2.setFieldInt32(267L, (int)data.getSnmpProxyId());
                msg2.setFieldInt32(802L, (int)data.getMqttProxyId());
                msg2.setFieldInt32(687L, (int)data.getEtherNetIpProxyId());
                msg2.setFieldInt32(149L, (int)data.getIcmpProxyId());
                msg2.setFieldInt32(548L, (int)data.getSshProxyId());
                msg2.setField(546L, data.getSshLogin());
                msg2.setField(547L, data.getSshPassword());
                msg2.setFieldInt32(778L, (int)data.getWebServiceProxyId());
                break;
            }
            case 21: {
                msg2.setFieldInt16(357L, data.getMapType());
                msg2.setField(359L, data.getSeedObjectIds());
                msg2.setFieldInt32(13L, data.getFlags());
                break;
            }
            case 11: {
                msg2.setFieldInt16(130L, data.getServiceType());
                msg2.setFieldInt16(131L, data.getIpProtocol());
                msg2.setFieldInt16(132L, data.getIpPort());
                msg2.setField(133L, data.getRequest());
                msg2.setField(134L, data.getResponse());
                msg2.setFieldInt16(408L, data.isCreateStatusDci() ? 1 : 0);
                break;
            }
            case 32: {
                msg2.setFieldInt16(441L, data.getHeight());
                break;
            }
            case 37: {
                msg2.setFieldInt32(581L, data.getFlags());
                msg2.setField(113L, data.getMacAddress());
                msg2.setFieldInt32(582L, data.getDeviceClass());
                msg2.setField(428L, data.getVendor());
                msg2.setFieldInt32(583L, data.getCommProtocol());
                msg2.setField(584L, data.getXmlConfig());
                msg2.setField(593L, data.getXmlRegConfig());
                msg2.setField(432L, data.getSerialNumber());
                msg2.setField(585L, data.getDeviceAddress());
                msg2.setField(586L, data.getMetaType());
                msg2.setField(27L, data.getDescription());
                msg2.setFieldInt32(592L, (int)data.getSensorProxy());
                break;
            }
            case 1: {
                msg2.setField(8L, data.getIpAddress());
                break;
            }
            case 15: {
                msg2.setFieldInt16(435L, data.getInstanceDiscoveryMethod());
            }
        }
        if (userData != null) {
            this.createCustomObject(data, userData, msg2);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(3L);
    }

    public long createObject(NXCObjectCreationData data) throws IOException, NXCException {
        return this.createObject(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject createObjectSync(NXCObjectCreationData data) throws IOException, NXCException {
        FutureObject object;
        long id = this.createObject(data, null);
        FutureObject futureObject = object = this.findFutureObjectById(id);
        synchronized (futureObject) {
            while (!object.hasObject()) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return object.getObject();
    }

    public long createObjectAsync(NXCObjectCreationData data, ObjectCreationListener callback) throws IOException, NXCException {
        long id = this.createObject(data, null);
        this.findObjectAsync(id, callback);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(7);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            AbstractObject object = this.objectList.get(objectId);
            if (object != null) {
                this.objectList.remove(objectId);
                this.objectListGUID.remove(object.getGuid());
                if (object instanceof Zone) {
                    this.zoneList.remove(((Zone)object).getUIN());
                }
                this.removeOrphanedObjects(object);
            }
        }
        this.sendNotification(new SessionNotification(99, objectId));
    }

    private void removeOrphanedObjects(AbstractObject parent) {
        Iterator<Long> it = parent.getChildren();
        while (it.hasNext()) {
            AbstractObject object = this.objectList.get(it.next());
            if (object == null || object.getParentCount() != 1) continue;
            this.objectList.remove(object.getObjectId());
            this.objectListGUID.remove(object.getGuid());
            if (object instanceof Zone) {
                this.zoneList.remove(((Zone)object).getUIN());
            }
            this.removeOrphanedObjects(object);
        }
    }

    protected void modifyCustomObject(NXCObjectModificationData data, Object userData, NXCPMessage msg2) {
    }

    public void modifyObject(NXCObjectModificationData data, Object userData) throws IOException, NXCException {
        long varId;
        NXCPMessage msg2 = this.newMessage(8);
        msg2.setFieldInt32(3L, (int)data.getObjectId());
        if (data.getName() != null) {
            msg2.setField(4L, data.getName());
        }
        if (data.getAlias() != null) {
            msg2.setField(494L, data.getAlias());
        }
        if (data.getNameOnMap() != null) {
            msg2.setField(712L, data.getNameOnMap());
        }
        if (data.getPrimaryIpAddress() != null) {
            msg2.setField(8L, data.getPrimaryIpAddress());
        }
        if (data.getACL() != null) {
            if (data.isInheritAccessRights() == null) {
                throw new NXCException(39);
            }
            Collection<AccessListElement> acl = data.getACL();
            msg2.setFieldInt32(32L, acl.size());
            msg2.setFieldInt16(33L, data.isInheritAccessRights() != false ? 1 : 0);
            long id1 = 4096L;
            long id2 = 8192L;
            for (AccessListElement e : acl) {
                msg2.setFieldInt32(id1++, (int)e.getUserId());
                msg2.setFieldInt32(id2++, e.getAccessRights());
            }
        }
        if (data.getCustomAttributes() != null) {
            Map<String, CustomAttribute> attrList = data.getCustomAttributes();
            Iterator<String> it = attrList.keySet().iterator();
            long id = 0x70000000L;
            int count2 = 0;
            while (it.hasNext()) {
                String key = it.next();
                CustomAttribute attr = attrList.get(key);
                if (attr.getSourceObject() != 0L && !attr.isRedefined()) continue;
                msg2.setField(id++, key);
                msg2.setField(id++, attr.getValue());
                msg2.setFieldInt32(id++, (int)attr.getFlags());
                ++count2;
            }
            msg2.setFieldInt32(309L, count2);
        }
        if (data.getAutoBindFilter() != null) {
            msg2.setField(321L, data.getAutoBindFilter());
        }
        if (data.getAutoBindFilter2() != null) {
            msg2.setField(626L, data.getAutoBindFilter2());
        }
        if (data.getAutoBindFlags() != null) {
            msg2.setFieldInt32(625L, data.getAutoBindFlags());
        }
        if (data.getFilter() != null) {
            msg2.setField(232L, data.getFilter());
        }
        if (data.getDescription() != null) {
            msg2.setField(27L, data.getDescription());
        }
        if (data.getVersion() != null) {
            msg2.setFieldInt32(178L, data.getVersion());
        }
        if (data.getAgentPort() != null) {
            msg2.setFieldInt16(15L, data.getAgentPort());
        }
        if (data.getAgentProxy() != null) {
            msg2.setFieldInt32(195L, data.getAgentProxy().intValue());
        }
        if (data.getAgentSecret() != null) {
            msg2.setField(17L, data.getAgentSecret());
        }
        if (data.getTrustedNodes() != null) {
            Long[] nodes = data.getTrustedNodes();
            msg2.setFieldInt32(306L, nodes.length);
            msg2.setField(307L, nodes);
        }
        if (data.getSnmpVersion() != null) {
            msg2.setFieldInt16(6L, data.getSnmpVersion().getValue());
        }
        if (data.getSnmpAuthName() != null || data.getSnmpAuthPassword() != null || data.getSnmpPrivPassword() != null || data.getSnmpAuthMethod() != null || data.getSnmpPrivMethod() != null) {
            if (data.getSnmpAuthName() == null || data.getSnmpAuthPassword() == null || data.getSnmpPrivPassword() == null || data.getSnmpAuthMethod() == null || data.getSnmpPrivMethod() == null) {
                throw new NXCException(39);
            }
            msg2.setField(18L, data.getSnmpAuthName());
            msg2.setField(89L, data.getSnmpAuthPassword());
            msg2.setField(91L, data.getSnmpPrivPassword());
            int methods = data.getSnmpAuthMethod() | data.getSnmpPrivMethod() << 8;
            msg2.setFieldInt16(84L, methods);
        }
        if (data.getSnmpProxy() != null) {
            msg2.setFieldInt32(267L, data.getSnmpProxy().intValue());
        }
        if (data.getSnmpPort() != null) {
            msg2.setFieldInt16(80L, data.getSnmpPort());
        }
        if (data.getMqttProxy() != null) {
            msg2.setFieldInt32(802L, data.getMqttProxy().intValue());
        }
        if (data.getIcmpProxy() != null) {
            msg2.setFieldInt32(149L, data.getIcmpProxy().intValue());
        }
        if (data.getGeolocation() != null) {
            GeoLocation gl = data.getGeolocation();
            msg2.setFieldInt16(342L, gl.getType());
            msg2.setField(343L, gl.getLatitude());
            msg2.setField(344L, gl.getLongitude());
            msg2.setFieldInt16(438L, gl.getAccuracy());
            if (gl.getTimestamp() != null) {
                msg2.setFieldInt64(439L, gl.getTimestamp().getTime() / 1000L);
            }
        }
        if (data.getMapLayout() != null) {
            msg2.setFieldInt16(358L, data.getMapLayout().getValue());
        }
        if (data.getMapBackground() != null || data.getMapBackgroundLocation() != null || data.getMapBackgroundLocation() != null || data.getMapBackgroundZoom() != null || data.getMapBackgroundColor() != null) {
            if (data.getMapBackground() == null || data.getMapBackgroundLocation() == null || data.getMapBackgroundLocation() == null || data.getMapBackgroundZoom() == null || data.getMapBackgroundColor() == null) {
                throw new NXCException(39);
            }
            msg2.setField(360L, data.getMapBackground());
            msg2.setField(385L, data.getMapBackgroundLocation().getLatitude());
            msg2.setField(386L, data.getMapBackgroundLocation().getLongitude());
            msg2.setFieldInt16(387L, data.getMapBackgroundZoom());
            msg2.setFieldInt32(424L, data.getMapBackgroundColor());
        }
        if (data.getMapImage() != null) {
            msg2.setField(379L, data.getMapImage());
        }
        if (data.getMapElements() != null || data.getMapLinks() != null) {
            if (data.getMapElements() == null || data.getMapLinks() == null) {
                throw new NXCException(39);
            }
            msg2.setFieldInt32(361L, data.getMapElements().size());
            long fieldId = 0x10000000L;
            for (NetworkMapElement e : data.getMapElements()) {
                e.fillMessage(msg2, fieldId);
                fieldId += 100L;
            }
            msg2.setFieldInt32(214L, data.getMapLinks().size());
            fieldId = 0x40000000L;
            for (NetworkMapLink l : data.getMapLinks()) {
                l.fillMessage(msg2, fieldId);
                fieldId += 20L;
            }
        }
        if (data.getColumnCount() != null) {
            msg2.setFieldInt16(166L, data.getColumnCount());
        }
        if (data.getDashboardElements() != null) {
            msg2.setFieldInt32(361L, data.getDashboardElements().size());
            long fieldId = 0x10000000L;
            for (DashboardElement e : data.getDashboardElements()) {
                e.fillMessage(msg2, fieldId);
                fieldId += 10L;
            }
        }
        if (data.getUrls() != null) {
            msg2.setFieldInt32(575L, data.getUrls().size());
            long fieldId = 0x74000000L;
            for (ObjectUrl u : data.getUrls()) {
                u.fillMessage(msg2, fieldId);
                fieldId += 10L;
            }
        }
        if (data.getScript() != null) {
            msg2.setField(228L, data.getScript());
        }
        if (data.getActivationEvent() != null) {
            msg2.setFieldInt32(223L, data.getActivationEvent());
        }
        if (data.getDeactivationEvent() != null) {
            msg2.setFieldInt32(224L, data.getDeactivationEvent());
        }
        if (data.getSourceObject() != null) {
            msg2.setFieldInt32(225L, data.getSourceObject().intValue());
        }
        if (data.getActiveStatus() != null) {
            msg2.setFieldInt16(226L, data.getActiveStatus());
        }
        if (data.getInactiveStatus() != null) {
            msg2.setFieldInt16(227L, data.getInactiveStatus());
        }
        if (data.getDciList() != null) {
            List<ConditionDciInfo> dciList = data.getDciList();
            msg2.setFieldInt32(111L, dciList.size());
            varId = 0x40000000L;
            for (ConditionDciInfo dci : dciList) {
                msg2.setFieldInt32(varId++, (int)dci.getDciId());
                msg2.setFieldInt32(varId++, (int)dci.getNodeId());
                msg2.setFieldInt16(varId++, dci.getFunction());
                msg2.setFieldInt16(varId++, dci.getPolls());
                varId += 6L;
            }
        }
        if (data.getDrillDownObjectId() != null) {
            msg2.setFieldInt32(389L, data.getDrillDownObjectId().intValue());
        }
        if (data.getServiceType() != null) {
            msg2.setFieldInt16(130L, data.getServiceType());
        }
        if (data.getIpAddress() != null) {
            msg2.setField(8L, data.getIpAddress());
        }
        if (data.getIpProtocol() != null) {
            msg2.setFieldInt16(131L, data.getIpProtocol());
        }
        if (data.getIpPort() != null) {
            msg2.setFieldInt16(132L, data.getIpPort());
        }
        if (data.getPollerNode() != null) {
            msg2.setFieldInt32(135L, data.getPollerNode().intValue());
        }
        if (data.getRequiredPolls() != null) {
            msg2.setFieldInt16(299L, data.getRequiredPolls());
        }
        if (data.getRequest() != null) {
            msg2.setField(133L, data.getRequest());
        }
        if (data.getResponse() != null) {
            msg2.setField(134L, data.getResponse());
        }
        if (data.getObjectFlags() != null || data.getObjectFlagsMask() != null) {
            msg2.setFieldInt32(13L, data.getObjectFlags());
            if (data.getObjectFlagsMask() != null) {
                msg2.setFieldInt32(538L, data.getObjectFlagsMask());
            }
        }
        if (data.getIfXTablePolicy() != null) {
            msg2.setFieldInt16(318L, data.getIfXTablePolicy());
        }
        if (data.getReportDefinition() != null) {
            msg2.setField(390L, data.getReportDefinition());
        }
        if (data.getResourceList() != null) {
            msg2.setFieldInt32(265L, data.getResourceList().size());
            long varId2 = 0x20000000L;
            for (ClusterResource r : data.getResourceList()) {
                msg2.setFieldInt32(varId2++, (int)r.getId());
                msg2.setField(varId2++, r.getName());
                msg2.setField(varId2++, r.getVirtualAddress());
                varId2 += 7L;
            }
        }
        if (data.getNetworkList() != null) {
            int count3 = data.getNetworkList().size();
            msg2.setFieldInt32(263L, count3);
            varId = 0x28000000L;
            for (InetAddressEx n : data.getNetworkList()) {
                msg2.setField(varId++, n);
            }
        }
        if (data.getPrimaryName() != null) {
            msg2.setField(397L, data.getPrimaryName());
        }
        if (data.getStatusCalculationMethod() != null || data.getStatusPropagationMethod() != null || data.getFixedPropagatedStatus() != null || data.getStatusShift() != null || data.getStatusTransformation() != null || data.getStatusSingleThreshold() != null || data.getStatusThresholds() != null) {
            msg2.setFieldInt16(160L, data.getStatusCalculationMethod());
            msg2.setFieldInt16(183L, data.getStatusPropagationMethod());
            msg2.setFieldInt16(184L, data.getFixedPropagatedStatus().getValue());
            msg2.setFieldInt16(185L, data.getStatusShift());
            ObjectStatus[] transformation = data.getStatusTransformation();
            msg2.setFieldInt16(186L, transformation[0].getValue());
            msg2.setFieldInt16(187L, transformation[1].getValue());
            msg2.setFieldInt16(188L, transformation[2].getValue());
            msg2.setFieldInt16(189L, transformation[3].getValue());
            msg2.setFieldInt16(190L, data.getStatusSingleThreshold());
            int[] thresholds = data.getStatusThresholds();
            msg2.setFieldInt16(191L, thresholds[0]);
            msg2.setFieldInt16(192L, thresholds[1]);
            msg2.setFieldInt16(193L, thresholds[2]);
            msg2.setFieldInt16(194L, thresholds[3]);
        }
        if (data.getExpectedState() != null) {
            msg2.setFieldInt16(416L, data.getExpectedState());
        }
        if (data.getLinkColor() != null) {
            msg2.setFieldInt32(417L, data.getLinkColor());
        }
        if (data.getConnectionRouting() != null) {
            msg2.setFieldInt16(423L, data.getConnectionRouting());
        }
        if (data.getDiscoveryRadius() != null) {
            msg2.setFieldInt32(426L, data.getDiscoveryRadius());
        }
        if (data.getHeight() != null) {
            msg2.setFieldInt16(441L, data.getHeight());
        }
        if (data.isRackNumberingTopBottom() != null) {
            msg2.setField(539L, data.isRackNumberingTopBottom());
        }
        if (data.getPeerGatewayId() != null) {
            msg2.setFieldInt32(22L, data.getPeerGatewayId().intValue());
        }
        if (data.getLocalNetworks() != null || data.getRemoteNetworks() != null) {
            if (data.getLocalNetworks() == null || data.getRemoteNetworks() == null) {
                throw new NXCException(39);
            }
            long fieldId = 0x10000000L;
            msg2.setFieldInt32(161L, data.getLocalNetworks().size());
            for (InetAddressEx a : data.getLocalNetworks()) {
                msg2.setField(fieldId++, a);
            }
            msg2.setFieldInt32(162L, data.getRemoteNetworks().size());
            for (InetAddressEx a : data.getRemoteNetworks()) {
                msg2.setField(fieldId++, a);
            }
        }
        if (data.getPostalAddress() != null) {
            data.getPostalAddress().fillMessage(msg2);
        }
        if (data.getAgentCacheMode() != null) {
            msg2.setFieldInt16(503L, data.getAgentCacheMode().getValue());
        }
        if (data.getAgentCompressionMode() != null) {
            msg2.setFieldInt16(571L, data.getAgentCompressionMode().getValue());
        }
        if (data.getMapObjectDisplayMode() != null) {
            msg2.setFieldInt16(506L, data.getMapObjectDisplayMode().getValue());
        }
        if (data.getFrontRackImage() != null || data.getRearRackImage() != null || data.getRackPosition() != null || data.getRackHeight() != null || data.getRackOrientation() != null) {
            if (data.getFrontRackImage() == null || data.getRearRackImage() == null || data.getRackPosition() == null || data.getRackHeight() == null || data.getRackOrientation() == null) {
                throw new NXCException(39);
            }
            msg2.setFieldInt32(517L, data.getPhysicalContainerObjectId() != null ? data.getPhysicalContainerObjectId().intValue() : 0);
            msg2.setField(518L, data.getFrontRackImage());
            msg2.setField(613L, data.getRearRackImage());
            msg2.setFieldInt16(519L, data.getRackPosition().shortValue());
            msg2.setFieldInt16(520L, data.getRackHeight().shortValue());
            msg2.setFieldInt16(611L, data.getRackOrientation().getValue());
        }
        if (data.getChassisPlacement() != null) {
            if (data.getPhysicalContainerObjectId() == null || data.getChassisPlacement() == null) {
                throw new NXCException(39);
            }
            msg2.setFieldInt32(517L, data.getPhysicalContainerObjectId().intValue());
            msg2.setField(673L, data.getChassisPlacement());
        }
        if (data.getDashboards() != null) {
            msg2.setField(528L, data.getDashboards());
        }
        if (data.getControllerId() != null) {
            msg2.setFieldInt32(543L, data.getControllerId().intValue());
        }
        if (data.getSshProxy() != null) {
            msg2.setFieldInt32(548L, data.getSshProxy().intValue());
        }
        if (data.getSshKeyId() != null) {
            msg2.setFieldInt32(747L, data.getSshKeyId());
        }
        if (data.getSshLogin() != null) {
            msg2.setField(546L, data.getSshLogin());
        }
        if (data.getSshPassword() != null) {
            msg2.setField(547L, data.getSshPassword());
        }
        if (data.getSshPort() != null) {
            msg2.setFieldInt16(727L, data.getSshPort());
        }
        if (data.getZoneProxies() != null) {
            msg2.setField(637L, data.getZoneProxies());
        }
        if (data.getSeedObjectIds() != null) {
            msg2.setField(359L, data.getSeedObjectIds());
        }
        if (data.getMacAddress() != null) {
            msg2.setField(113L, data.getMacAddress());
        }
        if (data.getDeviceClass() != null) {
            msg2.setFieldInt32(582L, data.getDeviceClass());
        }
        if (data.getVendor() != null) {
            msg2.setField(428L, data.getVendor());
        }
        if (data.getSerialNumber() != null) {
            msg2.setField(432L, data.getSerialNumber());
        }
        if (data.getDeviceAddress() != null) {
            msg2.setField(585L, data.getDeviceAddress());
        }
        if (data.getMetaType() != null) {
            msg2.setField(586L, data.getMetaType());
        }
        if (data.getSensorProxy() != null) {
            msg2.setFieldInt32(592L, data.getSensorProxy().intValue());
        }
        if (data.getXmlConfig() != null) {
            msg2.setField(584L, data.getXmlConfig());
        }
        if (data.getPassiveElements() != null) {
            List<PassiveRackElement> elements = data.getPassiveElements();
            msg2.setFieldInt32(361L, elements.size());
            long base2 = 0x10000000L;
            for (int i = 0; i < elements.size(); ++i) {
                elements.get(i).fillMessage(msg2, base2);
                base2 += 10L;
            }
        }
        if (data.getResponsibleUsers() != null) {
            msg2.setFieldInt32(615L, data.getResponsibleUsers().size());
            long fieldId = 0x69000000L;
            for (ResponsibleUser r : data.getResponsibleUsers()) {
                r.fillMessage(msg2, fieldId);
                fieldId += 10L;
            }
        }
        if (data.getIcmpStatCollectionMode() != null) {
            msg2.setFieldInt16(651L, data.getIcmpStatCollectionMode().getValue());
        }
        if (data.getIcmpTargets() != null) {
            msg2.setFieldInt32(652L, data.getIcmpTargets().size());
            long fieldId = 0x75000000L;
            for (InetAddress a : data.getIcmpTargets()) {
                msg2.setField(fieldId++, a);
            }
        }
        if (data.getEtherNetIPPort() != null) {
            msg2.setFieldInt16(688L, data.getEtherNetIPPort());
        }
        if (data.getEtherNetIPProxy() != null) {
            msg2.setFieldInt32(687L, data.getEtherNetIPProxy().intValue());
        }
        if (data.getCertificateMappingData() != null || data.getCertificateMappingMethod() != null) {
            if (data.getCertificateMappingData() == null || data.getCertificateMappingMethod() == null) {
                throw new NXCException(39);
            }
            msg2.setFieldInt16(279L, data.getCertificateMappingMethod().getValue());
            msg2.setField(280L, data.getCertificateMappingData());
        }
        if (data.getCategoryId() != null) {
            msg2.setFieldInt32(104L, data.getCategoryId());
        }
        if (data.getGeoLocationControlMode() != null) {
            msg2.setFieldInt16(724L, data.getGeoLocationControlMode().getValue());
        }
        if (data.getGeoAreas() != null) {
            msg2.setField(725L, data.getGeoAreas());
        }
        if (data.getInstanceDiscoveryMethod() != null) {
            msg2.setFieldInt32(435L, data.getInstanceDiscoveryMethod());
        }
        if (data.getInstanceDiscoveryData() != null) {
            msg2.setField(436L, data.getInstanceDiscoveryData());
        }
        if (data.getInstanceDiscoveryFilter() != null) {
            msg2.setField(437L, data.getInstanceDiscoveryFilter());
        }
        if (data.getObjectStatusThreshold() != null) {
            msg2.setFieldInt32(773L, data.getObjectStatusThreshold());
        }
        if (data.getDciStatusThreshold() != null) {
            msg2.setFieldInt32(774L, data.getDciStatusThreshold());
        }
        if (data.getSourceNode() != null) {
            msg2.setFieldInt32(393L, data.getSourceNode().intValue());
        }
        if (data.getWebServiceProxy() != null) {
            msg2.setFieldInt32(778L, data.getWebServiceProxy().intValue());
        }
        if (data.getSyslogCodepage() != null) {
            msg2.setField(780L, data.getSyslogCodepage());
        }
        if (data.getSNMPCodepage() != null) {
            msg2.setField(781L, data.getSNMPCodepage());
        }
        if (data.getDisplayPriority() != null) {
            msg2.setFieldInt32(795L, data.getDisplayPriority());
        }
        this.modifyCustomObject(data, userData, msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifyObject(NXCObjectModificationData data) throws IOException, NXCException {
        this.modifyObject(data, null);
    }

    public void setObjectName(long objectId, String name) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setName(name);
        this.modifyObject(data);
    }

    public void setObjectCustomAttributes(long objectId, Map<String, CustomAttribute> attrList) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setCustomAttributes(attrList);
        this.modifyObject(data);
    }

    public void setObjectACL(long objectId, Collection<AccessListElement> acl, boolean inheritAccessRights) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setACL(acl);
        data.setInheritAccessRights(inheritAccessRights);
        this.modifyObject(data);
    }

    public void changeObjectZone(long objectId, int zoneUIN) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(253);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt32(147L, zoneUIN);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void updateObjectComments(long objectId, String comments) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(185);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(82L, comments);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setObjectManaged(long objectId, boolean isManaged) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(47);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt16(49L, isManaged ? 1 : 0);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public int getEffectiveRights(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(290);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsInt32(463L);
    }

    private void changeObjectBinding(long parentId, long childId, boolean bind, boolean removeDci) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(bind ? 58 : 59);
        msg2.setFieldInt32(78L, (int)parentId);
        msg2.setFieldInt32(79L, (int)childId);
        msg2.setFieldInt16(152L, removeDci ? 1 : 0);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void bindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, true, false);
    }

    public void unbindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, false, false);
    }

    public void removeTemplate(long templateId, long nodeId, boolean removeDci) throws IOException, NXCException {
        this.changeObjectBinding(templateId, nodeId, false, removeDci);
    }

    public void applyTemplate(long templateId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(122);
        msg2.setFieldInt32(109L, (int)templateId);
        msg2.setFieldInt32(110L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void addClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(76);
        msg2.setFieldInt32(78L, (int)clusterId);
        msg2.setFieldInt32(79L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void removeClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        this.changeObjectBinding(clusterId, nodeId, false, true);
    }

    private NetworkMapPage queryAdHocTopologyMap(long nodeId, int command2, String pageIdSuffix) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(command2);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(138L);
        long[] idList = response.getFieldAsUInt32Array(139L);
        if (idList.length != count2) {
            throw new NXCException(46);
        }
        NetworkMapPage page = new NetworkMapPage(msg2.getMessageId() + pageIdSuffix);
        for (int i = 0; i < count2; ++i) {
            page.addElement(new NetworkMapObject(page.createElementId(), idList[i]));
        }
        count2 = response.getFieldAsInt32(214L);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            NetworkMapObject obj1 = page.findObjectElement(response.getFieldAsInt64(varId++));
            NetworkMapObject obj2 = page.findObjectElement(response.getFieldAsInt64(varId++));
            int type = response.getFieldAsInt32(varId++);
            String port1 = response.getFieldAsString(varId++);
            String port2 = response.getFieldAsString(varId++);
            String name = response.getFieldAsString(varId++);
            int flags = response.getFieldAsInt32(varId++);
            if (obj1 != null && obj2 != null) {
                page.addLink(new NetworkMapLink(page.createLinkId(), name, type, obj1.getId(), obj2.getId(), port1, port2, flags));
            }
            ++i;
            varId += 3L;
        }
        return page;
    }

    public NetworkMapPage queryLayer2Topology(long nodeId) throws IOException, NXCException {
        return this.queryAdHocTopologyMap(nodeId, 205, ".L2Topology");
    }

    public NetworkMapPage queryOSPFTopology(long nodeId) throws IOException, NXCException {
        return this.queryAdHocTopologyMap(nodeId, 441, ".OSPFTopology");
    }

    public NetworkMapPage queryInternalConnectionTopology(long nodeId) throws IOException, NXCException {
        return this.queryAdHocTopologyMap(nodeId, 370, ".InternalConnectionTopology");
    }

    public String executeActionWithExpansion(long nodeId, long alarmId, String action, Map<String, String> inputValues, List<String> maskedFields) throws IOException, NXCException {
        return this.executeActionWithExpansion(nodeId, alarmId, action, false, inputValues, maskedFields, null, null);
    }

    public String executeActionWithExpansion(long nodeId, long alarmId, String action, boolean receiveOutput, Map<String, String> inputValues, List<String> maskedFields, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler2;
        NXCPMessage msg2 = this.newMessage(16);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(605L, true);
        msg2.setField(87L, action);
        msg2.setField(482L, receiveOutput);
        msg2.setFieldInt32(93L, (int)alarmId);
        if (inputValues != null) {
            msg2.setFieldInt32(603L, inputValues.size());
            long varId = 0x20000000L;
            for (Map.Entry<String, String> e : inputValues.entrySet()) {
                msg2.setField(varId++, e.getKey());
                msg2.setField(varId++, e.getValue());
            }
        } else {
            msg2.setFieldInt16(603L, 0);
        }
        if (maskedFields != null && !maskedFields.isEmpty()) {
            msg2.setFieldsFromStringCollection(maskedFields, 0x10000000L, 717L);
        }
        MessageHandler messageHandler = handler2 = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text2 = m.getFieldAsString(26L);
                if (text2 != null) {
                    if (listener != null) {
                        listener.messageReceived(text2);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            this.addMessageSubscription(300, msg2.getMessageId(), handler2);
        }
        this.sendMessage(msg2);
        NXCPMessage result2 = this.waitForRCC(msg2.getMessageId());
        if (receiveOutput) {
            handler2.waitForCompletion();
            if (handler2.isExpired()) {
                throw new NXCException(4);
            }
        }
        return result2.getFieldAsString(87L);
    }

    public void executeAction(long nodeId, String action, String[] args) throws IOException, NXCException {
        this.executeAction(nodeId, action, args, false, null, null);
    }

    public void executeAction(long nodeId, String action, String[] args, boolean receiveOutput, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler2;
        NXCPMessage msg2 = this.newMessage(16);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(87L, action);
        msg2.setField(482L, receiveOutput);
        if (args != null) {
            msg2.setFieldInt16(88L, args.length);
            long fieldId = 0x10000000L;
            for (String a : args) {
                msg2.setField(fieldId++, a);
            }
        } else {
            msg2.setFieldInt16(88L, 0);
        }
        MessageHandler messageHandler = handler2 = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text2 = m.getFieldAsString(26L);
                if (text2 != null) {
                    if (listener != null) {
                        listener.messageReceived(text2);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            this.addMessageSubscription(300, msg2.getMessageId(), handler2);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        if (receiveOutput) {
            handler2.waitForCompletion();
            if (handler2.isExpired()) {
                throw new NXCException(4);
            }
        }
    }

    public void executeSshCommand(long nodeId, String command2, boolean receiveOutput, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler2;
        NXCPMessage msg2 = this.newMessage(448);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(145L, command2);
        msg2.setField(482L, receiveOutput);
        MessageHandler messageHandler = handler2 = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text2 = m.getFieldAsString(26L);
                if (text2 != null) {
                    if (listener != null) {
                        listener.messageReceived(text2);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            this.addMessageSubscription(300, msg2.getMessageId(), handler2);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        if (receiveOutput) {
            handler2.waitForCompletion();
            if (handler2.isExpired()) {
                throw new NXCException(4);
            }
        }
    }

    public void wakeupNode(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(92);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public PhysicalComponent getNodePhysicalComponents(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(257);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new PhysicalComponent(response, 0x20000000L, null);
    }

    public List<WinPerfObject> getNodeWinPerfObjects(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(275);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return WinPerfObject.createListFromMessage(response);
    }

    public List<SoftwarePackage> getNodeSoftwarePackages(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(274);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<SoftwarePackage> packages = new ArrayList<SoftwarePackage>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            packages.add(new SoftwarePackage(response, varId));
            varId += 10L;
        }
        return packages;
    }

    public List<HardwareComponent> getNodeHardwareComponents(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(379);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<HardwareComponent> components = new ArrayList<HardwareComponent>(count2);
        long baseId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            components.add(new HardwareComponent(response, baseId));
            baseId += 64L;
        }
        return components;
    }

    public List<DependentNode> getDependentNodes(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(367);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<DependentNode> nodes = new ArrayList<DependentNode>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            nodes.add(new DependentNode(msg2, fieldId));
            ++i;
            fieldId += 10L;
        }
        return nodes;
    }

    public ServerJob[] getServerJobList() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(54);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(330L);
        ServerJob[] jobList = new ServerJob[count2];
        long baseVarId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            jobList[i] = new ServerJob(response, baseVarId);
            ++i;
            baseVarId += 10L;
        }
        return jobList;
    }

    public void cancelServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(137);
        msg2.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void holdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(251);
        msg2.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void unholdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(252);
        msg2.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deployAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(142);
        msg2.setFieldInt32(83L, (int)policyId);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void uninstallAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(60);
        msg2.setFieldInt32(83L, (int)policyId);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    private EventProcessingPolicy getEventProcessingPolicyInternal(boolean readOnly) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(20);
        msg2.setFieldInt16(451L, readOnly ? 1 : 0);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int numRules = response.getFieldAsInt32(74L);
        EventProcessingPolicy policy = new EventProcessingPolicy(numRules);
        for (int i = 0; i < numRules; ++i) {
            response = this.waitForMessage(23, msg2.getMessageId());
            policy.addRule(new EventProcessingPolicyRule(response, i + 1));
        }
        return policy;
    }

    public EventProcessingPolicy getEventProcessingPolicy() throws IOException, NXCException {
        return this.getEventProcessingPolicyInternal(true);
    }

    public EventProcessingPolicy openEventProcessingPolicy() throws IOException, NXCException {
        return this.getEventProcessingPolicyInternal(false);
    }

    public void saveEventProcessingPolicy(EventProcessingPolicy epp) throws IOException, NXCException {
        List<EventProcessingPolicyRule> rules = epp.getRules();
        NXCPMessage msg2 = this.newMessage(22);
        msg2.setFieldInt32(74L, rules.size());
        this.sendMessage(msg2);
        long msgId = msg2.getMessageId();
        this.waitForRCC(msgId);
        int id = 1;
        for (EventProcessingPolicyRule rule : rules) {
            msg2 = new NXCPMessage(23);
            msg2.setMessageId(msgId);
            msg2.setFieldInt32(67L, id++);
            rule.fillMessage(msg2);
            this.sendMessage(msg2);
        }
        if (rules.size() > 0) {
            this.waitForRCC(msgId);
        }
    }

    public void closeEventProcessingPolicy() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(21);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public DataCollectionConfiguration openDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        return this.openDataCollectionConfiguration(nodeId, null);
    }

    public DataCollectionConfiguration openDataCollectionConfiguration(long nodeId, RemoteChangeListener changeListener) throws IOException, NXCException {
        DataCollectionConfiguration cfg = new DataCollectionConfiguration(this, nodeId);
        cfg.open(changeListener);
        return cfg;
    }

    public long modifyDataCollectionObject(DataCollectionObject dcObject) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(45);
        msg2.setFieldInt32(3L, (int)dcObject.getNodeId());
        dcObject.fillMessage(msg2);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsInt64(43L);
    }

    public void clearAgentDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(318);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void resyncAgentDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(319);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public TransformationTestResult testTransformationScript(long nodeId, String script, String inputValue, DataCollectionObject dcObject) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(53);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(228L, script);
        msg2.setField(21L, inputValue);
        if (dcObject != null) {
            dcObject.fillMessage(msg2);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        TransformationTestResult r = new TransformationTestResult();
        r.success = response.getFieldAsBoolean(326L);
        r.result = response.getFieldAsString(327L);
        return r;
    }

    private Map<String, String> processScriptExecution(NXCPMessage msg2, TextOutputListener listener, boolean resultAsMap) throws IOException, NXCException {
        msg2.setField(788L, resultAsMap);
        ScriptExecutionUpdateHandler handler2 = new ScriptExecutionUpdateHandler(listener);
        handler2.setMessageWaitTimeout(this.commandTimeout);
        this.addMessageSubscription(304, msg2.getMessageId(), handler2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        handler2.waitForCompletion();
        if (handler2.isExpired()) {
            throw new NXCException(4);
        }
        if (handler2.isFailure()) {
            throw new NXCException(handler2.getErrorCode(), handler2.getErrorMessage());
        }
        if (!resultAsMap) {
            return null;
        }
        NXCPMessage response = this.waitForMessage(437, msg2.getMessageId());
        return response.getStringMapFromFields(0x10000000L, 361L);
    }

    public void executeLibraryScript(long nodeId, String script, Map<String, String> inputFields, TextOutputListener listener) throws IOException, NXCException {
        this.executeLibraryScript(nodeId, 0L, script, inputFields, listener);
    }

    public void executeLibraryScript(long objectId, long alarmId, String script, Map<String, String> inputFields, TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(85);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(228L, script);
        msg2.setFieldInt32(93L, (int)alarmId);
        msg2.setField(482L, listener != null);
        if (inputFields != null) {
            msg2.setFieldInt16(507L, inputFields.size());
            long fieldId = 0x70000000L;
            for (Map.Entry<String, String> e : inputFields.entrySet()) {
                msg2.setField(fieldId++, e.getKey());
                msg2.setField(fieldId++, e.getValue());
            }
        }
        this.processScriptExecution(msg2, listener, false);
    }

    public void executeScript(long objectId, String script, String parameters, TextOutputListener listener) throws IOException, NXCException {
        this.executeScript(objectId, script, parameters, listener, false);
    }

    public void executeScript(long objectId, String script, String parameters, TextOutputListener listener, boolean developmentMode) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(303);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(228L, script);
        msg2.setField(794L, developmentMode);
        if (parameters != null) {
            msg2.setField(85L, parameters);
        }
        this.processScriptExecution(msg2, listener, false);
    }

    public void executeScript(long objectId, String script, List<String> parameterList, TextOutputListener listener) throws IOException, NXCException {
        this.executeScript(objectId, script, parameterList, listener, false);
    }

    public void executeScript(long objectId, String script, List<String> parameterList, TextOutputListener listener, boolean developmentMode) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(303);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(228L, script);
        msg2.setField(794L, developmentMode);
        if (parameterList != null) {
            msg2.setFieldInt16(507L, parameterList.size());
            long fieldId = 0x70000000L;
            for (String param : parameterList) {
                msg2.setField(fieldId++, param);
            }
        }
        this.processScriptExecution(msg2, listener, false);
    }

    public Map<String, String> queryScript(long nodeId, String script, List<String> parameterList, TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(303);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(228L, script);
        if (parameterList != null) {
            msg2.setFieldInt16(507L, parameterList.size());
            long fieldId = 0x70000000L;
            for (String param : parameterList) {
                msg2.setField(fieldId++, param);
            }
        }
        return this.processScriptExecution(msg2, listener, true);
    }

    public ScriptCompilationResult compileScript(String source, boolean serialize) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(317);
        msg2.setField(228L, source);
        msg2.setField(509L, serialize);
        this.sendMessage(msg2);
        return new ScriptCompilationResult(this.waitForRCC(msg2.getMessageId()));
    }

    public Log openServerLog(String logName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(61);
        msg2.setField(171L, logName);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        Log log2 = new Log(this, response, logName);
        return log2;
    }

    public List<AlarmCategory> getAlarmCategories() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(339);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        ArrayList<AlarmCategory> list = new ArrayList<AlarmCategory>();
        long fieldId = 0x10000000L;
        int count2 = response.getFieldAsInt32(361L);
        for (int i = 0; i < count2; ++i) {
            list.add(new AlarmCategory(response, fieldId));
            fieldId += 10L;
        }
        return list;
    }

    public long modifyAlarmCategory(AlarmCategory object) throws IOException, NXCException {
        if (object.getName().isEmpty()) {
            return 0L;
        }
        NXCPMessage msg2 = this.newMessage(340);
        object.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt32(104L);
    }

    public void deleteAlarmCategory(long id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(341);
        msg2.setFieldInt32(104L, (int)id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAlarmCategories() throws IOException, NXCException {
        List<AlarmCategory> categories = this.getAlarmCategories();
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            this.alarmCategories.clear();
            for (AlarmCategory c : categories) {
                this.alarmCategories.put(c.getId(), c);
            }
            this.alarmCategoriesSynchronized = true;
        }
    }

    public boolean isAlarmCategoriesSynchronized() {
        return this.alarmCategoriesSynchronized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmCategory findAlarmCategoryById(long id) {
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            return this.alarmCategories.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmCategory findAlarmCategoryByName(String name) {
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            for (Map.Entry<Long, AlarmCategory> c : this.alarmCategories.entrySet()) {
                if (!c.getValue().getName().equals(name)) continue;
                return c.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlarmCategory> findMultipleAlarmCategories(List<Long> ids) {
        ArrayList<AlarmCategory> list = new ArrayList<AlarmCategory>();
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            for (Long id : ids) {
                AlarmCategory e = this.alarmCategories.get(id);
                if (e == null) continue;
                list.add(e);
            }
        }
        return list;
    }

    public boolean isEventObjectsSynchronized() {
        return this.eventTemplatesSynchronized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncEventTemplates() throws IOException, NXCException {
        List<EventTemplate> templates = this.getEventTemplates();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            this.eventTemplates.clear();
            for (EventTemplate t : templates) {
                this.eventTemplates.put(t.getCode(), t);
            }
            this.eventTemplatesSynchronized = true;
        }
    }

    private void resyncEventTemplates() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NXCSession.this.syncEventTemplates();
                }
                catch (Exception e) {
                    logger.error("Exception in worker thread", e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate[] getCachedEventTemplates() {
        EventTemplate[] events = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            events = this.eventTemplates.values().toArray(new EventTemplate[this.eventTemplates.size()]);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate findEventTemplateByName(String name) {
        EventTemplate result2 = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            for (EventTemplate t : this.eventTemplates.values()) {
                if (!t.getName().equalsIgnoreCase(name)) continue;
                result2 = t;
                break;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventName(long code2) {
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            EventTemplate e = this.eventTemplates.get(code2);
            return e != null ? e.getName() : "[" + Long.toString(code2) + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate findEventTemplateByCode(long code2) {
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            return this.eventTemplates.get(code2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(Collection<Long> codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            for (long code2 : codes) {
                EventTemplate t = this.eventTemplates.get(code2);
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(long[] codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            for (long code2 : codes) {
                EventTemplate t = this.eventTemplates.get(code2);
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<EventTemplate> getEventTemplates() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(28);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(69L);
        long base2 = 0x10000000L;
        ArrayList<EventTemplate> objects = new ArrayList<EventTemplate>(count2);
        for (int i = 0; i < count2; ++i) {
            objects.add(new EventTemplate(response, base2));
            base2 += 10L;
        }
        return objects;
    }

    public long generateEventCode() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(94);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(24L);
    }

    public void deleteEventTemplate(long eventCode) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(93);
        msg2.setFieldInt32(24L, (int)eventCode);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifyEventObject(EventTemplate tmpl) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(26);
        tmpl.fillMessage(msg2);
        this.sendMessage(msg2);
        tmpl.setCode(this.waitForRCC(msg2.getMessageId()).getFieldAsInt32(24L));
    }

    public void sendEvent(long eventCode, String eventName, long objectId, String[] parameters, String userTag, Date originTimestamp) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(19);
        msg2.setFieldInt32(24L, (int)eventCode);
        if (eventName != null) {
            msg2.setField(169L, eventName);
        }
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(298L, userTag != null ? userTag : "");
        if (originTimestamp != null) {
            msg2.setField(726L, originTimestamp);
        }
        msg2.setFieldInt16(88L, parameters.length);
        long varId = 32768L;
        for (int i = 0; i < parameters.length; ++i) {
            msg2.setField(varId++, parameters[i]);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void sendEvent(long eventCode, String[] parameters) throws IOException, NXCException {
        this.sendEvent(eventCode, null, 0L, parameters, null, null);
    }

    public void sendEvent(String eventName, String[] parameters) throws IOException, NXCException {
        this.sendEvent(0L, eventName, 0L, parameters, null, null);
    }

    public Map<Integer, List<String>> getSnmpCommunities() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(209);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(86L);
        long stringBase = 0x10000000L;
        long zoneBase = 0x20000000L;
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>(count2);
        ArrayList<String> communities = new ArrayList<String>();
        int currentZoneUIN = response.getFieldAsInt32(zoneBase);
        for (int i = 0; i < count2; ++i) {
            int zoneUIN;
            if (currentZoneUIN != (zoneUIN = response.getFieldAsInt32(zoneBase++))) {
                map.put(currentZoneUIN, communities);
                communities = new ArrayList();
                currentZoneUIN = zoneUIN;
            }
            communities.add(response.getFieldAsString(stringBase++));
        }
        if (count2 > 0) {
            map.put(currentZoneUIN, communities);
        }
        return map;
    }

    public List<String> getSnmpCommunities(int zoneUIN) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(209);
        msg2.setFieldInt32(147L, zoneUIN);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(86L);
        long stringBase = 0x10000000L;
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < count2; ++i) {
            stringList.add(response.getFieldAsString(stringBase++));
        }
        return stringList;
    }

    public void updateSnmpCommunities(int zoneUIN, List<String> communityStrings) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(210);
        msg2.setFieldInt32(147L, zoneUIN);
        long stringBase = 0x10000000L;
        for (String s : communityStrings) {
            msg2.setField(stringBase++, s);
        }
        msg2.setFieldInt32(86L, communityStrings.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Integer, List<SnmpUsmCredential>> getSnmpUsmCredentials() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(236);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(174L);
        HashMap<Integer, List<SnmpUsmCredential>> map = new HashMap<Integer, List<SnmpUsmCredential>>(count2);
        ArrayList<SnmpUsmCredential> credentials = new ArrayList<SnmpUsmCredential>();
        long fieldId = 0x10000000L;
        int zoneId = 0;
        int i = 0;
        while (i < count2) {
            SnmpUsmCredential cred = new SnmpUsmCredential(response, fieldId);
            if (i != 0 && zoneId != cred.getZoneId()) {
                map.put(zoneId, credentials);
                credentials = new ArrayList();
            }
            credentials.add(cred);
            zoneId = cred.getZoneId();
            ++i;
            fieldId += 10L;
        }
        if (count2 > 0) {
            map.put(zoneId, credentials);
        }
        return map;
    }

    public List<SnmpUsmCredential> getSnmpUsmCredentials(int zoneUIN) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(236);
        msg2.setFieldInt32(147L, zoneUIN);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(174L);
        ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>(count2);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list.add(new SnmpUsmCredential(response, varId));
            ++i;
            varId += 10L;
        }
        return list;
    }

    public void updateSnmpUsmCredentials(int zoneUIN, List<SnmpUsmCredential> usmCredentials) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(237);
        msg2.setFieldInt32(147L, zoneUIN);
        long varId = 0x10000000L;
        for (SnmpUsmCredential element : usmCredentials) {
            element.fillMessage(msg2, varId);
            varId += 10L;
        }
        msg2.setFieldInt32(174L, usmCredentials.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Integer, List<SSHCredentials>> getSshCredentials() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(455);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        HashMap<Integer, List<SSHCredentials>> credentials = new HashMap<Integer, List<SSHCredentials>>(count2);
        if (count2 > 0) {
            ArrayList<SSHCredentials> zoneCredentials = new ArrayList<SSHCredentials>();
            long fieldId = 0x10000000L;
            int currentZoneUIN = response.getFieldAsInt32(fieldId);
            int i = 0;
            while (i < count2) {
                int zoneUIN = response.getFieldAsInt32(fieldId);
                if (zoneUIN != currentZoneUIN) {
                    credentials.put(currentZoneUIN, zoneCredentials);
                    zoneCredentials = new ArrayList();
                }
                zoneCredentials.add(new SSHCredentials(response, fieldId + 1L));
                ++i;
                fieldId += 10L;
            }
            credentials.put(currentZoneUIN, zoneCredentials);
        }
        return credentials;
    }

    public List<SSHCredentials> getSshCredentials(int zoneUIN) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(455);
        msg2.setFieldInt32(147L, zoneUIN);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<SSHCredentials> credentials = new ArrayList<SSHCredentials>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            credentials.add(new SSHCredentials(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        return credentials;
    }

    public void updateSshCredentials(int zoneUIN, List<SSHCredentials> sshCredentials) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(456);
        msg2.setFieldInt32(147L, zoneUIN);
        long fieldId = 0x10000000L;
        for (SSHCredentials element : sshCredentials) {
            element.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
        msg2.setFieldInt32(361L, sshCredentials.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public String readAgentConfigurationFile(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(116);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(159L);
    }

    public void writeAgentConfigurationFile(long nodeId, String config2, boolean apply) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(117);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(159L, config2);
        msg2.setFieldInt16(163L, apply ? 1 : 0);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<AgentParameter> getSupportedParameters(long nodeId, DataOrigin origin) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(118);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt16(13L, 1);
        msg2.setFieldInt16(46L, origin.getValue());
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(137L);
        ArrayList<AgentParameter> list = new ArrayList<AgentParameter>(count2);
        long baseId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new AgentParameter(response, baseId));
            baseId += 3L;
        }
        return list;
    }

    public List<AgentParameter> getSupportedParameters(long nodeId) throws IOException, NXCException {
        return this.getSupportedParameters(nodeId, DataOrigin.AGENT);
    }

    public List<AgentTable> getSupportedTables(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(118);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt16(13L, 2);
        msg2.setFieldInt16(46L, DataOrigin.AGENT.getValue());
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(378L);
        ArrayList<AgentTable> list = new ArrayList<AgentTable>(count2);
        long baseId = 0x40000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new AgentTable(response, baseId));
            baseId += response.getFieldAsInt64(baseId);
        }
        return list;
    }

    public long[] getRelatedEvents(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(191);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        if (response.getFieldAsInt32(69L) == 0) {
            return new long[0];
        }
        return response.getFieldAsUInt32Array(255L);
    }

    public List<Script> getDataCollectionScripts(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(310);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(206L);
        ArrayList<Script> scripts = new ArrayList<Script>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            long id = response.getFieldAsInt64(fieldId++);
            String name = response.getFieldAsString(fieldId++);
            scripts.add(new Script(id, name, null));
        }
        return scripts;
    }

    public String exportConfiguration(String description, long[] events, long[] traps, long[] templates, UUID[] rules, long[] scripts, long[] objectTools, long[] dciSummaryTables, long[] actions, long[] webService) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(192);
        msg2.setField(27L, description);
        msg2.setFieldInt32(69L, events.length);
        msg2.setField(255L, events);
        msg2.setFieldInt32(138L, templates.length);
        msg2.setField(139L, templates);
        msg2.setFieldInt32(256L, traps.length);
        msg2.setField(257L, traps);
        msg2.setFieldInt32(206L, scripts.length);
        msg2.setField(497L, scripts);
        msg2.setFieldInt32(164L, objectTools.length);
        msg2.setField(498L, objectTools);
        msg2.setFieldInt32(499L, dciSummaryTables.length);
        msg2.setField(500L, dciSummaryTables);
        msg2.setFieldInt32(70L, actions.length);
        msg2.setField(606L, actions);
        msg2.setFieldInt32(702L, webService.length);
        msg2.setField(722L, webService);
        msg2.setFieldInt32(74L, rules.length);
        long varId = 0x10000000L;
        for (int i = 0; i < rules.length; ++i) {
            msg2.setField(varId++, rules[i]);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsString(258L);
    }

    public void importConfiguration(String config2, int flags) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(193);
        msg2.setField(258L, config2);
        msg2.setFieldInt32(13L, flags);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<String, Object> getServerStats() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(151);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("VERSION", response.getFieldAsString(121L));
        stats.put("UPTIME", response.getFieldAsInt32(200L));
        stats.put("SESSION_COUNT", response.getFieldAsInt32(205L));
        stats.put("DCI_COUNT", response.getFieldAsInt32(111L));
        stats.put("OBJECT_COUNT", response.getFieldAsInt32(138L));
        stats.put("NODE_COUNT", response.getFieldAsInt32(179L));
        stats.put("PHYSICAL_MEMORY_USED", response.getFieldAsInt32(203L));
        stats.put("VIRTUAL_MEMORY_USED", response.getFieldAsInt32(204L));
        stats.put("QSIZE_CONDITION_POLLER", response.getFieldAsInt32(285L));
        stats.put("QSIZE_CONF_POLLER", response.getFieldAsInt32(286L));
        stats.put("QSIZE_DCI_POLLER", response.getFieldAsInt32(287L));
        stats.put("QSIZE_DCI_CACHE_LOADER", response.getFieldAsInt32(492L));
        stats.put("QSIZE_DBWRITER", response.getFieldAsInt32(288L));
        stats.put("QSIZE_EVENT", response.getFieldAsInt32(289L));
        stats.put("QSIZE_DISCOVERY", response.getFieldAsInt32(290L));
        stats.put("QSIZE_NODE_POLLER", response.getFieldAsInt32(291L));
        stats.put("QSIZE_ROUTE_POLLER", response.getFieldAsInt32(292L));
        stats.put("QSIZE_STATUS_POLLER", response.getFieldAsInt32(293L));
        stats.put("ALARM_COUNT", response.getFieldAsInt32(201L));
        stats.put("ALARMS_BY_SEVERITY", response.getFieldAsUInt32Array(202L));
        return stats;
    }

    public List<ServerAction> getActions() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg2 = this.newMessage(78);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        ArrayList<ServerAction> actions = new ArrayList<ServerAction>();
        while ((response = this.waitForMessage(83, msg2.getMessageId())).getFieldAsInt64(97L) != 0L) {
            actions.add(new ServerAction(response));
        }
        return actions;
    }

    public long createAction(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(81);
        msg2.setField(87L, name);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(97L);
    }

    public void modifyAction(ServerAction action) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(80);
        action.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteAction(long actionId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(82);
        msg2.setFieldInt32(97L, (int)actionId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<ObjectTool> getObjectTools() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(15);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(164L);
        ArrayList<ObjectTool> list = new ArrayList<ObjectTool>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new ObjectTool(response, fieldId));
            fieldId += 10000L;
        }
        return list;
    }

    public ObjectToolFolder createToolTree(List<ObjectTool> tools) {
        ObjectToolFolder root = new ObjectToolFolder("[root]");
        HashMap<String, ObjectToolFolder> folders = new HashMap<String, ObjectToolFolder>();
        for (ObjectTool t : tools) {
            ObjectToolFolder folder = root;
            String[] path = t.getName().split("\\-\\>");
            for (int i = 0; i < path.length - 1; ++i) {
                String key = folder.hashCode() + "@" + path[i].replace("&", "");
                ObjectToolFolder curr = (ObjectToolFolder)folders.get(key);
                if (curr == null) {
                    curr = new ObjectToolFolder(path[i]);
                    folders.put(key, curr);
                    folder.addFolder(curr);
                }
                folder = curr;
            }
            folder.addTool(t);
        }
        return root;
    }

    public ObjectToolFolder getObjectToolsAsTree() throws IOException, NXCException {
        return this.createToolTree(this.getObjectTools());
    }

    public ObjectToolDetails getObjectToolDetails(long toolId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(144);
        msg2.setFieldInt32(165L, (int)toolId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new ObjectToolDetails(response);
    }

    public long generateObjectToolId() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(150);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(165L);
    }

    public void modifyObjectTool(ObjectToolDetails tool2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(147);
        tool2.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteObjectTool(long toolId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(148);
        msg2.setFieldInt32(165L, (int)toolId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void enableObjectTool(long toolId, boolean enable) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(287);
        msg2.setFieldInt32(165L, (int)toolId);
        msg2.setField(243L, enable);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Table executeTableTool(long toolId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(135);
        msg2.setFieldInt32(165L, (int)toolId);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        NXCPMessage response = this.waitForMessage(136, msg2.getMessageId(), 300000);
        return new Table(response);
    }

    public void executeServerCommand(long objectId, String command2, Map<String, String> inputFields, List<String> maskedFields) throws IOException, NXCException {
        this.executeServerCommand(objectId, command2, inputFields, maskedFields, false, null, null);
    }

    public void executeServerCommand(long objectId, String command2, Map<String, String> inputFields, List<String> maskedFields, boolean receiveOutput, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler2;
        NXCPMessage msg2 = this.newMessage(145);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(145L, command2);
        msg2.setField(482L, receiveOutput);
        if (inputFields != null) {
            msg2.setFieldInt16(507L, inputFields.size());
            long fieldId = 0x70000000L;
            for (Map.Entry<String, String> e : inputFields.entrySet()) {
                msg2.setField(fieldId++, e.getKey());
                msg2.setField(fieldId++, e.getValue());
            }
        }
        if (maskedFields != null && !maskedFields.isEmpty()) {
            msg2.setFieldsFromStringCollection(maskedFields, 0x10000000L, 717L);
        }
        MessageHandler messageHandler = handler2 = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text2 = m.getFieldAsString(26L);
                if (text2 != null) {
                    if (listener != null) {
                        listener.messageReceived(text2);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            handler2.setMessageWaitTimeout(this.serverCommandOutputTimeout);
            this.addMessageSubscription(300, msg2.getMessageId(), handler2);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        if (receiveOutput) {
            if (listener != null) {
                listener.setStreamId(response.getFieldAsInt64(568L));
            }
            handler2.waitForCompletion();
            if (handler2.isExpired()) {
                throw new NXCException(4);
            }
        }
    }

    public void stopServerCommand(long commandId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(88);
        msg2.setFieldInt32(568L, (int)commandId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<SnmpTrap> getSnmpTrapsConfigurationSummary() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(194);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(256L);
        ArrayList<SnmpTrap> list = new ArrayList<SnmpTrap>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new SnmpTrap(response, varId));
            varId += 10L;
        }
        return list;
    }

    public List<SnmpTrap> getSnmpTrapsConfiguration() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg2 = this.newMessage(100);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        ArrayList<SnmpTrap> traps = new ArrayList<SnmpTrap>();
        while ((response = this.waitForMessage(101, msg2.getMessageId())).getFieldAsInt64(117L) != 0L) {
            traps.add(new SnmpTrap(response));
        }
        return traps;
    }

    public long createSnmpTrapConfiguration() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(97);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(117L);
    }

    public void deleteSnmpTrapConfiguration(long trapId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(99);
        msg2.setFieldInt32(117L, (int)trapId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifySnmpTrapConfiguration(SnmpTrap trap) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(98);
        trap.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Date getMibFileTimestamp() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(51);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsDate(94L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadMibFile() throws IOException, NXCException {
        NXCReceivedFile file;
        NXCPMessage msg2 = this.newMessage(52);
        this.sendMessage(msg2);
        int ttw = 120;
        do {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                file = this.receivedFiles.get(msg2.getMessageId());
                if (file != null && file.getStatus() != 0) {
                    this.receivedFiles.remove(file.getId());
                    break;
                }
                try {
                    this.receivedFiles.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (--ttw > 0);
        if (ttw == 0) {
            throw new NXCException(4);
        }
        if (file.getStatus() == 2) {
            throw file.getException();
        }
        return file.getFile();
    }

    public GraphDefinition getPredefinedGraph(long graphId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(373);
        msg2.setFieldInt32(274L, (int)graphId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return GraphDefinition.createGraphSettings(response, 0x10000000L);
    }

    public List<GraphDefinition> getPredefinedGraphs(boolean graphTemplates) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(197);
        msg2.setField(533L, graphTemplates);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(273L);
        ArrayList<GraphDefinition> list = new ArrayList<GraphDefinition>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(GraphDefinition.createGraphSettings(response, fieldId));
            fieldId += 10L;
        }
        return list;
    }

    public static GraphFolder createGraphTree(List<GraphDefinition> graphs) {
        GraphFolder root = new GraphFolder("[root]");
        HashMap<String, GraphFolder> folders = new HashMap<String, GraphFolder>();
        for (GraphDefinition s : graphs) {
            GraphFolder folder = root;
            String[] path = s.getName().split("\\-\\>");
            for (int i = 0; i < path.length - 1; ++i) {
                String key = folder.hashCode() + "@" + path[i].replace("&", "");
                GraphFolder curr = (GraphFolder)folders.get(key);
                if (curr == null) {
                    curr = new GraphFolder(path[i]);
                    folders.put(key, curr);
                    folder.addFolder(curr);
                }
                folder = curr;
            }
            folder.addGraph(s);
        }
        return root;
    }

    public GraphFolder getPredefinedGraphsAsTree() throws IOException, NXCException {
        return NXCSession.createGraphTree(this.getPredefinedGraphs(false));
    }

    public long saveGraph(GraphDefinition graph, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(198);
        graph.fillMessage(msg2);
        msg2.setField(534L, overwrite);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(274L);
    }

    public void deletePredefinedGraph(long graphId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(199);
        msg2.setFieldInt32(274L, (int)graphId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<Script> getScriptLibrary() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(152);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(206L);
        ArrayList<Script> scripts = new ArrayList<Script>(count2);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            scripts.add(new Script(response, varId));
            ++i;
            varId += 2L;
        }
        return scripts;
    }

    public Script getScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(153);
        msg2.setFieldInt32(207L, (int)scriptId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Script(response);
    }

    public long modifyScript(long scriptId, String name, String source) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(154);
        msg2.setFieldInt32(207L, (int)scriptId);
        msg2.setField(20L, name);
        msg2.setField(208L, source);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(207L);
    }

    public void renameScript(long scriptId, String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(156);
        msg2.setFieldInt32(207L, (int)scriptId);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(155);
        msg2.setFieldInt32(207L, (int)scriptId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public ConnectionPoint findConnectionPoint(long objectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(95);
        msg2.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.isFieldPresent(418L) ? new ConnectionPoint(response) : null;
    }

    public ConnectionPoint findConnectionPoint(MacAddress macAddr) throws IOException, NXCException {
        List<ConnectionPoint> cpl = this.findConnectionPoints(macAddr.getValue(), 0);
        return cpl.isEmpty() ? null : cpl.get(0);
    }

    public List<ConnectionPoint> findConnectionPoints(byte[] pattern, int searchLimit) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(96);
        msg2.setField(113L, pattern);
        msg2.setFieldInt32(173L, searchLimit);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        ArrayList<ConnectionPoint> out = new ArrayList<ConnectionPoint>();
        int count2 = response.getFieldAsInt32(361L);
        long base2 = 0x10000000L;
        int i = 0;
        while (i < count2) {
            out.add(new ConnectionPoint(response, base2));
            ++i;
            base2 += 10L;
        }
        return out;
    }

    public ConnectionPoint findConnectionPoint(int zoneId, InetAddress ipAddr) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(264);
        msg2.setFieldInt32(147L, zoneId);
        msg2.setField(8L, ipAddr);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.isFieldPresent(418L) ? new ConnectionPoint(response) : null;
    }

    public List<AbstractNode> findNodesByHostname(int zoneId, String hostname) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(347);
        msg2.setFieldInt32(147L, zoneId);
        msg2.setField(569L, hostname);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        long base2 = 0x10000000L;
        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
        for (int i = 0; i < count2; ++i) {
            nodes.add((AbstractNode)this.findObjectById(response.getFieldAsInt32(base2++)));
        }
        return nodes;
    }

    public boolean checkConnection() {
        if (!this.connected) {
            return false;
        }
        NXCPMessage msg2 = this.newMessage(3);
        try {
            this.sendMessage(msg2);
            this.waitForRCC(msg2.getMessageId());
            return true;
        }
        catch (Exception e) {
            this.sendNotification(new SessionNotification(1));
            return false;
        }
    }

    public List<LibraryImage> getImageLibrary() throws IOException, NXCException {
        return this.getImageLibrary(null);
    }

    public List<LibraryImage> getImageLibrary(String category) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(243);
        if (category != null) {
            msg2.setField(75L, category);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(174L);
        ArrayList<LibraryImage> images = new ArrayList<LibraryImage>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            images.add(new LibraryImage(response, fieldId));
            ++i;
            fieldId += 5L;
        }
        return images;
    }

    public LibraryImage getImage(UUID guid) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(239);
        msg2.setField(222L, guid);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        ReceivedFile imageFile = this.waitForFile(msg2.getMessageId(), 60000);
        if (imageFile.isFailed()) {
            throw new NXCException(16);
        }
        return new LibraryImage(response, imageFile.getFile());
    }

    public LibraryImage createImage(LibraryImage image2, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(240);
        image2.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        UUID imageGuid = response.getFieldAsUUID(222L);
        image2.setGuid(imageGuid);
        this.sendFile(msg2.getMessageId(), image2.getBinaryData(), listener, this.allowCompression);
        this.waitForRCC(msg2.getMessageId());
        return image2;
    }

    public void deleteImage(LibraryImage image2) throws IOException, NXCException {
        if (image2.isProtected()) {
            throw new NXCException(156);
        }
        this.deleteImage(image2.getGuid());
    }

    public void deleteImage(UUID guid) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(241);
        msg2.setField(222L, guid);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifyImage(LibraryImage image2, ProgressListener listener) throws IOException, NXCException {
        if (image2.isProtected()) {
            throw new NXCException(156);
        }
        NXCPMessage msg2 = this.newMessage(240);
        image2.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.sendFile(msg2.getMessageId(), image2.getBinaryData(), listener, this.allowCompression);
        this.waitForRCC(msg2.getMessageId());
    }

    public void pollObject(long objectId, ObjectPollType pollType, final TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(89);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt16(107L, pollType.getValue());
        MessageHandler handler2 = new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                int rcc = m.getFieldAsInt32(28L);
                if (rcc == 23) {
                    if (listener != null) {
                        listener.messageReceived(m.getFieldAsString(108L));
                    }
                } else {
                    this.setComplete();
                }
                return true;
            }
        };
        handler2.setMessageWaitTimeout(600000);
        this.addMessageSubscription(90, msg2.getMessageId(), handler2);
        this.sendMessage(msg2);
        try {
            this.waitForRCC(msg2.getMessageId());
        }
        catch (NXCException e) {
            this.removeMessageSubscription(90, msg2.getMessageId());
            throw e;
        }
        handler2.waitForCompletion();
        if (handler2.isExpired()) {
            throw new NXCException(4);
        }
    }

    public HashMap<String, String> getPersistentStorageList() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(211);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(567L);
        HashMap<String, String> map = new HashMap<String, String>();
        long base2 = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            map.put(response.getFieldAsString(base2++), response.getFieldAsString(base2++));
        }
        return map;
    }

    public void setPersistentStorageValue(String key, String value) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(213);
        msg2.setField(301L, key);
        msg2.setField(302L, value);
        this.sendMessage(msg2);
    }

    public void deletePersistentStorageValue(String key) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(212);
        msg2.setField(301L, key);
        this.sendMessage(msg2);
    }

    public ServerFile[] listServerFiles() throws IOException, NXCException {
        return this.listServerFiles(null);
    }

    public ServerFile[] listServerFiles(String[] filter) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(244);
        if (filter != null) {
            msg2.setFieldInt32(464L, filter.length);
            int i = 0;
            long j = 0x10000000L;
            while (i < filter.length) {
                msg2.setField(j, filter[i]);
                ++i;
                ++j;
            }
        } else {
            msg2.setFieldInt32(464L, 0);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(304L);
        ServerFile[] files = new ServerFile[count2];
        long varId = 0x20000000L;
        for (int i = 0; i < count2; ++i) {
            files[i] = new ServerFile(response, varId);
            varId += 10L;
        }
        return files;
    }

    public List<AgentFile> listAgentFiles(AgentFile file, String fullPath, long objectId) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg2 = this.newMessage(294);
        msg2.setField(125L, fullPath);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt16(480L, file == null ? 1 : 0);
        msg2.setFieldInt16(558L, 1);
        this.sendMessage(msg2);
        ArrayList<AgentFile> files = new ArrayList<AgentFile>(64);
        do {
            response = this.waitForRCC(msg2.getMessageId());
            int count2 = response.getFieldAsInt32(304L);
            long fieldId = 0x20000000L;
            for (int i = 0; i < count2; ++i) {
                files.add(new AgentFile(response, fieldId, file, objectId));
                fieldId += 10L;
            }
            if (response.getFieldAsBoolean(558L)) continue;
            return files;
        } while (!response.isEndOfSequence());
        this.waitForRCC(msg2.getMessageId());
        return files;
    }

    public AgentFileInfo getAgentFileInfo(AgentFile file) throws IOException, NXCException {
        if (!file.isDirectory()) {
            return new AgentFileInfo(file.getName(), 0L, file.getSize());
        }
        NXCPMessage msg2 = this.newMessage(346);
        msg2.setField(125L, file.getFullName());
        msg2.setFieldInt32(3L, (int)file.getNodeId());
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new AgentFileInfo(file.getName(), response.getFieldAsInt64(556L), response.getFieldAsInt64(554L));
    }

    public long uploadFileToAgent(long nodeId, String serverFileName, String remoteFileName, boolean jobOnHold) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(146);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, serverFileName);
        if (remoteFileName != null) {
            msg2.setField(377L, remoteFileName);
        }
        msg2.setFieldInt16(383L, jobOnHold ? 1 : 0);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(331L);
    }

    public void uploadFileToServer(File localFile, String serverFileName, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(219);
        if (serverFileName == null || serverFileName.isEmpty()) {
            serverFileName = localFile.getName();
        }
        msg2.setField(125L, serverFileName);
        msg2.setField(406L, new Date(localFile.lastModified()));
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.sendFile(msg2.getMessageId(), localFile, listener, this.allowCompression, 0L);
    }

    private static byte[] calculateFileHash(File file, long size) throws IOException, NoSuchAlgorithmException {
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest hash = MessageDigest.getInstance("MD5");
        long numRead = 0L;
        while ((numRead = (long)((InputStream)in).read(buffer)) != -1L && size > 0L) {
            hash.update(buffer, 0, (int)Math.min(numRead, size));
            size -= numRead;
        }
        ((InputStream)in).close();
        return hash.digest();
    }

    public void uploadLocalFileToAgent(long nodeId, File localFile, String remoteFileName, boolean overwrite, ProgressListener listener) throws IOException, NXCException {
        boolean messageResendRequired;
        int resumeMode = 1;
        long offset = 0L;
        NXCPMessage msg2 = null;
        NXCPMessage response = null;
        do {
            messageResendRequired = false;
            msg2 = this.newMessage(298);
            if (remoteFileName == null || remoteFileName.isEmpty()) {
                remoteFileName = localFile.getName();
            }
            msg2.setFieldInt32(3L, (int)nodeId);
            msg2.setField(125L, remoteFileName);
            msg2.setField(406L, new Date(localFile.lastModified()));
            msg2.setField(534L, overwrite);
            msg2.setField(785L, true);
            msg2.setFieldInt16(792L, resumeMode);
            this.sendMessage(msg2);
            response = this.waitForRCC(msg2.getMessageId());
            if (response.getFieldAsInt32(28L) != 158) continue;
            byte[] remoteFileHash = response.getFieldAsBinary(760L);
            long remoteFileSize = response.getFieldAsInt32(356L);
            byte[] localFileHash = new byte[1];
            try {
                localFileHash = NXCSession.calculateFileHash(localFile, remoteFileSize);
            }
            catch (NoSuchAlgorithmException e) {
                messageResendRequired = true;
                resumeMode = 0;
            }
            if (Arrays.equals(remoteFileHash, localFileHash)) {
                messageResendRequired = true;
                resumeMode = 2;
                offset = remoteFileSize;
                continue;
            }
            messageResendRequired = true;
            resumeMode = 0;
        } while (messageResendRequired);
        boolean serverSideProgressReport = response.getFieldAsBoolean(785L);
        this.sendFile(msg2.getMessageId(), localFile, serverSideProgressReport ? null : listener, response.getFieldAsBoolean(570L), offset);
        if (serverSideProgressReport) {
            if (listener != null) {
                listener.setTotalWorkAmount(localFile.length());
            }
            while (!(response = this.waitForRCC(msg2.getMessageId(), 900000)).isEndOfSequence()) {
                if (listener == null) continue;
                listener.markProgress(response.getFieldAsInt64(356L));
            }
        } else {
            this.waitForRCC(msg2.getMessageId(), 900000);
        }
    }

    public void createFolderOnAgent(long nodeId, String folder) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(305);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, folder);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyProgressListener(long id, int length) {
        Map<Long, ProgressListener> map = this.progressListeners;
        synchronized (map) {
            ProgressListener listener = this.progressListeners.get(id);
            if (listener != null) {
                listener.markProgress(length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProgressListener(long id) {
        Map<Long, ProgressListener> map = this.progressListeners;
        synchronized (map) {
            this.progressListeners.remove(id);
        }
    }

    public AgentFileData downloadFileFromAgent(long nodeId, String remoteFileName, long maxFileSize, boolean follow, ProgressListener listener, ServerJobIdUpdater updateServerJobId) throws IOException, NXCException {
        return this.downloadFileFromAgent(nodeId, remoteFileName, false, 0L, null, maxFileSize, follow, listener, updateServerJobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentFileData downloadFileFromAgent(long nodeId, String remoteFileName, boolean expandMacros, long alarmId, Map<String, String> inputValues, long maxFileSize, boolean follow, ProgressListener listener, ServerJobIdUpdater updateServerJobId) throws IOException, NXCException {
        ReceivedFile remoteFile;
        NXCPMessage msg2 = this.newMessage(254);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, remoteFileName);
        msg2.setFieldInt32(458L, (int)maxFileSize);
        msg2.setField(459L, follow);
        msg2.setField(605L, expandMacros);
        msg2.setFieldInt32(93L, (int)alarmId);
        if (inputValues != null) {
            msg2.setFieldInt32(603L, inputValues.size());
            long varId = 0x20000000L;
            for (Map.Entry<String, String> e : inputValues.entrySet()) {
                msg2.setField(varId++, e.getKey());
                msg2.setField(varId++, e.getValue());
            }
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        String id = response.getFieldAsString(20L);
        remoteFileName = response.getFieldAsString(125L);
        if (updateServerJobId != null) {
            updateServerJobId.setJobIdCallback(response.getFieldAsInt32(455L));
        }
        if (listener != null) {
            long fileSize = response.getFieldAsInt64(356L);
            listener.setTotalWorkAmount(fileSize);
            Map<Long, ProgressListener> map = this.progressListeners;
            synchronized (map) {
                this.progressListeners.put(msg2.getMessageId(), listener);
            }
        }
        if ((remoteFile = this.waitForFile(msg2.getMessageId(), 120000)).isFailed()) {
            throw new NXCException(124);
        }
        AgentFileData file = new AgentFileData(id, remoteFileName, remoteFile.getFile());
        try {
            this.waitForRCC(msg2.getMessageId());
        }
        finally {
            this.removeProgressListener(msg2.getMessageId());
        }
        return file;
    }

    public File downloadFileFromServer(String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(234);
        msg2.setField(125L, remoteFileName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        return this.waitForFile(msg2.getMessageId(), 60000).getFile();
    }

    public void cancelFileMonitoring(long nodeId, String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(286);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, remoteFileName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public AgentFileFingerprint getAgentFileFingerprint(long nodeId, String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(334);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, remoteFileName);
        this.sendMessage(msg2);
        return new AgentFileFingerprint(this.waitForRCC(msg2.getMessageId()));
    }

    public void renameServerFile(String oldFileName, String newFileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(221);
        msg2.setField(125L, oldFileName);
        msg2.setField(477L, newFileName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteServerFile(String serverFileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(220);
        msg2.setField(125L, serverFileName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteAgentFile(long nodeId, String fileName) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(295);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, fileName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void renameAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(296);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, oldName);
        msg2.setField(477L, newFileName);
        msg2.setField(534L, overwrite);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void moveAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(297);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, oldName);
        msg2.setField(477L, newFileName);
        msg2.setField(534L, overwrite);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void copyAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(361);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(125L, oldName);
        msg2.setField(477L, newFileName);
        msg2.setField(534L, overwrite);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void openConsole() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(247);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.serverConsoleConnected = true;
    }

    public void closeConsole() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(248);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        this.serverConsoleConnected = false;
    }

    public boolean processConsoleCommand(String command2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(128);
        msg2.setField(145L, command2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId(), 3600000);
        return response.isEndOfSequence();
    }

    public boolean isServerConsoleConnected() {
        return this.serverConsoleConnected;
    }

    public void snmpWalk(long nodeId, String rootOid, SnmpWalkListener listener) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg2 = this.newMessage(161);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setField(19L, rootOid);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        do {
            response = this.waitForMessage(162, msg2.getMessageId());
            int count2 = response.getFieldAsInt32(144L);
            ArrayList<SnmpValue> data = new ArrayList<SnmpValue>(count2);
            long varId = 0x10000000L;
            for (int i = 0; i < count2; ++i) {
                String name = response.getFieldAsString(varId++);
                int type = response.getFieldAsInt32(varId++);
                String value = response.getFieldAsString(varId++);
                data.add(new SnmpValue(name, type, value, nodeId));
            }
            listener.onSnmpWalkData(data);
        } while (!response.isEndOfSequence());
    }

    public List<VlanInfo> getVlans(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(250);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(382L);
        ArrayList<VlanInfo> vlans = new ArrayList<VlanInfo>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            VlanInfo v = new VlanInfo(response, fieldId);
            vlans.add(v);
            fieldId = v.getNextFieldId();
        }
        return vlans;
    }

    public boolean areObjectsSynchronized() {
        return this.objectsSynchronized;
    }

    public List<InetAddressListElement> getAddressList(int listId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(188);
        msg2.setFieldInt32(252L, listId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(174L);
        ArrayList<InetAddressListElement> list = new ArrayList<InetAddressListElement>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new InetAddressListElement(response, varId));
            varId += 10L;
        }
        return list;
    }

    public void setAddressList(int listId, List<InetAddressListElement> list) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(189);
        msg2.setFieldInt32(252L, listId);
        msg2.setFieldInt32(174L, list.size());
        long fieldId = 0x10000000L;
        for (InetAddressListElement e : list) {
            e.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void resetServerComponent(int component) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(190);
        msg2.setFieldInt32(253L, component);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public NetworkPath getNetworkPath(long node1, long node2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(129);
        msg2.setFieldInt32(109L, (int)node1);
        msg2.setFieldInt32(110L, (int)node2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new NetworkPath(response);
    }

    public List<Route> getRoutingTable(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(134);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<Route> rt = new ArrayList<Route>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            rt.add(new Route(response, varId));
            varId += 10L;
        }
        return rt;
    }

    public OSPFInfo getOSPFInfo(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(433);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new OSPFInfo(response);
    }

    public List<FdbEntry> getSwitchForwardingDatabase(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(299);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<FdbEntry> fdb = new ArrayList<FdbEntry>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            fdb.add(new FdbEntry(response, varId));
            varId += 10L;
        }
        return fdb;
    }

    public List<WirelessStation> getWirelessStations(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(276);
        msg2.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<WirelessStation> stations = new ArrayList<WirelessStation>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            stations.add(new WirelessStation(response, varId));
            varId += 10L;
        }
        return stations;
    }

    public void removePackage(long packageId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(110);
        msg2.setFieldInt32(126L, (int)packageId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public long installPackage(PackageInfo info, File pkgFile, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(111);
        info.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        long id = response.getFieldAsInt64(126L);
        try {
            this.sendFile(msg2.getMessageId(), pkgFile, listener, this.allowCompression, 0L);
            this.waitForRCC(msg2.getMessageId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }

    public void updatePackageMetadata(PackageInfo info) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(450);
        info.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<PackageInfo> getInstalledPackages() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg2 = this.newMessage(108);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
        while ((response = this.waitForMessage(109, msg2.getMessageId())).getFieldAsInt64(126L) != 0L) {
            list.add(new PackageInfo(response));
        }
        return list;
    }

    public void deployPackage(long packageId, Long[] nodeList, PackageDeploymentListener listener) throws IOException, NXCException {
        NXCPMessage response;
        int status;
        NXCPMessage msg2 = this.newMessage(119);
        msg2.setFieldInt32(126L, (int)packageId);
        msg2.setFieldInt32(138L, nodeList.length);
        msg2.setField(139L, nodeList);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        if (listener != null) {
            listener.deploymentStarted();
        }
        while ((status = (response = this.waitForMessage(120, msg2.getMessageId(), 600000)).getFieldAsInt32(140L)) != 255) {
            if (listener == null) continue;
            if (status == 4) {
                listener.statusUpdate(response.getFieldAsInt64(3L), status, response.getFieldAsString(141L));
                continue;
            }
            listener.statusUpdate(response.getFieldAsInt64(3L), status, "");
        }
        if (listener != null) {
            listener.deploymentComplete();
        }
    }

    public void sendNotification(String channelName, String phoneNumber, String subject, String message2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(208);
        msg2.setField(654L, channelName);
        msg2.setField(102L, phoneNumber);
        msg2.setField(101L, subject);
        msg2.setField(26L, message2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void pushDciData(DciPushData[] data) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(187);
        msg2.setFieldInt32(111L, data.length);
        long varId = 0x10000000L;
        for (DciPushData d : data) {
            msg2.setFieldInt32(varId++, (int)d.nodeId);
            if (d.nodeId == 0L) {
                msg2.setField(varId++, d.nodeName);
            }
            msg2.setFieldInt32(varId++, (int)d.dciId);
            if (d.dciId == 0L) {
                msg2.setField(varId++, d.dciName);
            }
            msg2.setField(varId++, d.value);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void pushDciData(long nodeId, long dciId, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeId, dciId, value)});
    }

    public void pushDciData(String nodeName, String dciName, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeName, dciName, value)});
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getShortTimeFormat() {
        return this.shortTimeFormat;
    }

    public void handover(NXCSession target) {
        target.objectList = this.objectList;
        target.objectListGUID = this.objectListGUID;
        target.zoneList = this.zoneList;
        for (AbstractObject o : this.objectList.values()) {
            o.setSession(target);
        }
        this.objectList = null;
        this.objectListGUID = null;
        this.zoneList = null;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public List<MappingTableDescriptor> listMappingTables() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(273);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<MappingTableDescriptor> list = new ArrayList<MappingTableDescriptor>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new MappingTableDescriptor(response, varId));
            varId += 10L;
        }
        return list;
    }

    public MappingTable getMappingTable(int id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(270);
        msg2.setFieldInt32(434L, id);
        this.sendMessage(msg2);
        return new MappingTable(this.waitForRCC(msg2.getMessageId()));
    }

    public int createMappingTable(String name, String description, int flags) throws IOException, NXCException {
        MappingTable mt = new MappingTable(name, description);
        mt.setFlags(flags);
        return this.updateMappingTable(mt);
    }

    public int updateMappingTable(MappingTable table) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(271);
        table.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt32(434L);
    }

    public void deleteMappingTable(int id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(272);
        msg2.setFieldInt32(434L, id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public final int getDefaultDciRetentionTime() {
        return this.defaultDciRetentionTime;
    }

    public final int getDefaultDciPollingInterval() {
        return this.defaultDciPollingInterval;
    }

    public int getMinViewRefreshInterval() {
        return this.minViewRefreshInterval;
    }

    public final boolean isStrictAlarmStatusFlow() {
        return this.strictAlarmStatusFlow;
    }

    public boolean isTimedAlarmAckEnabled() {
        return this.timedAlarmAckEnabled;
    }

    public List<DciSummaryTableDescriptor> listDciSummaryTables() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(277);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<DciSummaryTableDescriptor> list = new ArrayList<DciSummaryTableDescriptor>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new DciSummaryTableDescriptor(response, varId));
            varId += 10L;
        }
        return list;
    }

    public DciSummaryTable getDciSummaryTable(int id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(280);
        msg2.setFieldInt32(444L, id);
        this.sendMessage(msg2);
        return new DciSummaryTable(this.waitForRCC(msg2.getMessageId()));
    }

    public int modifyDciSummaryTable(DciSummaryTable table) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(278);
        table.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt32(444L);
    }

    public void deleteDciSummaryTable(int id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(279);
        msg2.setFieldInt32(444L, id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Table queryDciSummaryTable(int tableId, long baseObjectId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(281);
        msg2.setFieldInt32(444L, tableId);
        msg2.setFieldInt32(3L, (int)baseObjectId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Table(response);
    }

    public Table queryAdHocDciSummaryTable(long baseObjectId, List<DciSummaryTableColumn> columns, AggregationFunction function, Date periodStart, Date periodEnd, boolean multiInstance) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(306);
        msg2.setFieldInt32(3L, (int)baseObjectId);
        msg2.setFieldInt32(166L, columns.size());
        msg2.setFieldInt16(490L, function != null ? function.getValue() : AggregationFunction.LAST.getValue());
        msg2.setField(51L, periodStart);
        msg2.setField(52L, periodEnd);
        msg2.setFieldInt32(13L, multiInstance ? 1 : 0);
        long id = 0x10000000L;
        for (DciSummaryTableColumn c : columns) {
            c.fillMessage(msg2, id);
            id += 10L;
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return new Table(response);
    }

    public List<UUID> listReports() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4352);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        ArrayList<UUID> ret = new ArrayList<UUID>(count2);
        long base2 = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            ret.add(response.getFieldAsUUID(base2 + (long)i));
        }
        return ret;
    }

    public ReportDefinition getReportDefinition(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4353);
        msg2.setField(390L, reportId);
        msg2.setField(450L, Locale.getDefault().getLanguage());
        this.sendMessage(msg2);
        return new ReportDefinition(reportId, this.waitForRCC(msg2.getMessageId()));
    }

    public UUID executeReport(ReportingJobConfiguration jobConfiguration) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4354);
        msg2.setField(390L, jobConfiguration.reportId);
        try {
            msg2.setField(730L, jobConfiguration.createXml());
        }
        catch (Exception e) {
            throw new NXCException(46, (Throwable)e);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsUUID(331L);
    }

    public List<ReportResult> getReportResults(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4355);
        msg2.setField(390L, reportId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        ArrayList<ReportResult> results = new ArrayList<ReportResult>(count2);
        long fieldId = 0x30000000L;
        int i = 0;
        while (i < count2) {
            results.add(new ReportResult(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        return results;
    }

    public void deleteReportResult(UUID reportId, UUID jobId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4357);
        msg2.setField(390L, reportId);
        msg2.setField(331L, jobId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public File renderReport(UUID reportId, UUID jobId, ReportRenderFormat format) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(4356);
        msg2.setField(390L, reportId);
        msg2.setField(331L, jobId);
        msg2.setFieldInt32(400L, format.getCode());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
        ReceivedFile file = this.waitForFile(msg2.getMessageId(), 60000);
        if (file.isFailed()) {
            throw new NXCException(16);
        }
        return file.getFile();
    }

    public List<ReportingJob> getScheduledReportingJobs(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(421);
        msg2.setField(390L, reportId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        long fieldId = 0x10000000L;
        int count2 = response.getFieldAsInt32(521L);
        ArrayList<ReportingJob> result2 = new ArrayList<ReportingJob>(count2);
        for (int i = 0; i < count2; ++i) {
            result2.add(new ReportingJob(response, fieldId));
            fieldId += 100L;
        }
        return result2;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    private byte[] signChallenge(Signature signature, byte[] challenge) throws NXCException {
        byte[] signed;
        try {
            signature.update(challenge);
            signed = signature.sign();
        }
        catch (SignatureException e) {
            throw new NXCException(98);
        }
        return signed;
    }

    public String getClientLanguage() {
        return this.clientLanguage;
    }

    public void setClientLanguage(String clientLanguage) {
        this.clientLanguage = clientLanguage;
    }

    public long[] getSubnetAddressMap(long subnetId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(284);
        msg2.setFieldInt32(3L, (int)subnetId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsUInt32Array(456L);
    }

    public List<AgentConfigurationHandle> getAgentConfigurations() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(176);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(174L);
        ArrayList<AgentConfigurationHandle> elements = new ArrayList<AgentConfigurationHandle>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            elements.add(new AgentConfigurationHandle(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        Collections.sort(elements);
        return elements;
    }

    public AgentConfiguration getAgentConfiguration(long id) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(177);
        msg2.setFieldInt32(231L, (int)id);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        AgentConfiguration content = new AgentConfiguration(id, response);
        return content;
    }

    public void saveAgentConfig(AgentConfiguration configuration) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(178);
        configuration.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteAgentConfig(long id) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(179);
        msg2.setFieldInt32(231L, (int)id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void swapAgentConfigs(long id1, long id2) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(180);
        msg2.setFieldInt32(231L, (int)id1);
        msg2.setFieldInt32(237L, (int)id2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<GeoLocation> getLocationHistory(long objectId, Date from, Date to) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(301);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(51L, from);
        msg2.setField(52L, to);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int size = response.getFieldAsInt32(174L);
        ArrayList<GeoLocation> elements = new ArrayList<GeoLocation>();
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < size) {
            elements.add(new GeoLocation(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        Collections.sort(elements, new Comparator<GeoLocation>(){

            @Override
            public int compare(GeoLocation l1, GeoLocation l2) {
                return l1.getTimestamp().compareTo(l2.getTimestamp());
            }
        });
        return elements;
    }

    public byte[] takeScreenshot(long nodeId, String sessionName) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(302);
        msg2.setFieldInt32(393L, (int)nodeId);
        if (sessionName != null) {
            msg2.setField(20L, sessionName);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId(), this.msgWaitQueue.getDefaultTimeout() + 60000);
        return response.getFieldAsBinary(460L);
    }

    public List<String> getScheduledTaskHandlers() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(320);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getStringListFromFields(0x10000000L, 527L);
    }

    public List<ScheduledTask> getScheduledTasks() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(321);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int size = response.getFieldAsInt32(521L);
        ArrayList<ScheduledTask> list = new ArrayList<ScheduledTask>(size);
        long i = 0L;
        long base2 = 0x10000000L;
        while (i < (long)size) {
            list.add(new ScheduledTask(response, base2));
            ++i;
            base2 += 100L;
        }
        return list;
    }

    public void addScheduledTask(ScheduledTask task) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(322);
        task.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void updateScheduledTask(ScheduledTask task) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(323);
        task.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteScheduledTask(long taskId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(324);
        msg2.setFieldInt32(522L, (int)taskId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setObjectMaintenanceMode(long objectId, boolean inMaintenance, String comments) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(inMaintenance ? 325 : 326);
        msg2.setFieldInt32(3L, (int)objectId);
        if (comments != null) {
            msg2.setField(82L, comments);
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void setObjectMaintenanceMode(long objectId, boolean inMaintenance) throws NXCException, IOException {
        this.setObjectMaintenanceMode(objectId, inMaintenance, null);
    }

    public List<Repository> getRepositories() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(335);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<Repository> list = new ArrayList<Repository>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            list.add(new Repository(response, fieldId));
            fieldId += 10L;
        }
        return list;
    }

    public void addRepository(Repository r) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(336);
        r.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        r.setId(response.getFieldAsInt32(3L));
    }

    public void modifyRepository(Repository r) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(337);
        r.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteRepository(int id) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(338);
        msg2.setFieldInt32(541L, id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public synchronized List<PredictionEngine> getPredictionEngines() throws IOException, NXCException {
        if (this.predictionEngines != null) {
            return this.predictionEngines;
        }
        NXCPMessage msg2 = this.newMessage(86);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<PredictionEngine> engines = new ArrayList<PredictionEngine>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            engines.add(new PredictionEngine(response, fieldId));
            fieldId += 10L;
        }
        this.predictionEngines = engines;
        return engines;
    }

    public DciData getPredictedData(long nodeId, long dciId, Date from, Date to) throws IOException, NXCException {
        int rowsReceived;
        NXCPMessage msg2 = this.newMessage(87);
        msg2.setFieldInt32(3L, (int)nodeId);
        msg2.setFieldInt32(43L, (int)dciId);
        DciData data = new DciData(nodeId, dciId);
        int timeFrom = (int)(from.getTime() / 1000L);
        int timeTo = (int)(to.getTime() / 1000L);
        do {
            DciDataRow row;
            msg2.setMessageId(this.requestId.getAndIncrement());
            msg2.setFieldInt32(51L, timeFrom);
            msg2.setFieldInt32(52L, timeTo);
            this.sendMessage(msg2);
            this.waitForRCC(msg2.getMessageId());
            NXCPMessage response = this.waitForMessage(50, msg2.getMessageId());
            if (!response.isBinaryMessage()) {
                throw new NXCException(46);
            }
            rowsReceived = this.parseDataRows(response.getBinaryData(), data);
            if (rowsReceived != 200000 || (row = data.getLastValue()) == null) continue;
            timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
        } while (rowsReceived == 200000 && timeTo > timeFrom);
        return data;
    }

    public List<AgentTunnel> getAgentTunnels() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(214);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<AgentTunnel> tunnels = new ArrayList<AgentTunnel>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            tunnels.add(new AgentTunnel(response, fieldId));
            fieldId += 64L;
        }
        return tunnels;
    }

    public boolean waitForAgentTunnel(long nodeId, long timeout) {
        try {
            while (timeout > 0L) {
                long startTime = System.currentTimeMillis();
                for (AgentTunnel t : this.getAgentTunnels()) {
                    if (!t.isBound() || t.getNodeId() != nodeId) continue;
                    return true;
                }
                Thread.sleep(1000L);
                timeout -= System.currentTimeMillis() - startTime;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void bindAgentTunnel(int tunnelId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(215);
        msg2.setFieldInt32(579L, tunnelId);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void unbindAgentTunnel(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(353);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<String> substituteMacros(ObjectContextBase context, List<String> textsToExpand, Map<String, String> inputValues) throws IOException, NXCException {
        long varId;
        NXCPMessage msg2 = this.newMessage(357);
        if (inputValues != null) {
            msg2.setFieldInt32(603L, inputValues.size());
            varId = 0x20000000L;
            for (Map.Entry entry : inputValues.entrySet()) {
                msg2.setField(varId++, (String)entry.getKey());
                msg2.setField(varId++, (String)entry.getValue());
            }
        }
        msg2.setFieldInt32(604L, textsToExpand.size());
        varId = 0x10000000L;
        for (String string2 : textsToExpand) {
            context.fillMessage(msg2, varId, string2);
            varId += 5L;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        this.sendMessage(msg2);
        NXCPMessage nXCPMessage = this.waitForRCC(msg2.getMessageId());
        varId = 0x10000000L;
        for (int i = 0; i < textsToExpand.size(); ++i) {
            result2.add(nXCPMessage.getFieldAsString(varId++));
        }
        return result2;
    }

    public List<String> substituteMacros(ObjectContextBase[] context, String textToExpand, Map<String, String> inputValues) throws IOException, NXCException {
        long varId;
        NXCPMessage msg2 = this.newMessage(357);
        if (inputValues != null) {
            msg2.setFieldInt32(603L, inputValues.size());
            varId = 0x20000000L;
            for (Map.Entry entry : inputValues.entrySet()) {
                msg2.setField(varId++, (String)entry.getKey());
                msg2.setField(varId++, (String)entry.getValue());
            }
        }
        msg2.setFieldInt32(604L, context.length);
        varId = 0x10000000L;
        for (ObjectContextBase c : context) {
            c.fillMessage(msg2, varId, textToExpand);
            varId += 5L;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        this.sendMessage(msg2);
        NXCPMessage nXCPMessage = this.waitForRCC(msg2.getMessageId());
        varId = 0x10000000L;
        for (int i = 0; i < context.length; ++i) {
            result2.add(nXCPMessage.getFieldAsString(varId++));
        }
        return result2;
    }

    public TcpProxy setupTcpProxy(long proxyId, InetAddress address, int port) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(364);
        msg2.setFieldInt32(803L, (int)proxyId);
        msg2.setField(8L, address);
        msg2.setFieldInt16(268L, port);
        return this.setupTcpProxyInternal(msg2);
    }

    public TcpProxy setupTcpProxy(long nodeId, int port) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(364);
        msg2.setFieldInt32(803L, 0);
        msg2.setFieldInt32(393L, (int)nodeId);
        msg2.setFieldInt16(268L, port);
        return this.setupTcpProxyInternal(msg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpProxy setupTcpProxyInternal(NXCPMessage request) throws IOException, NXCException {
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        Map<Integer, TcpProxy> map = this.tcpProxies;
        synchronized (map) {
            TcpProxy proxy = new TcpProxy(this, response.getFieldAsInt32(574L));
            this.tcpProxies.put(proxy.getChannelId(), proxy);
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTcpProxy(int channelId) {
        NXCPMessage msg2 = this.newMessage(366);
        msg2.setFieldInt32(574L, channelId);
        try {
            this.sendMessage(msg2);
            this.waitForRCC(msg2.getMessageId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<Integer, TcpProxy> map = this.tcpProxies;
        synchronized (map) {
            this.tcpProxies.remove(channelId);
        }
    }

    public AgentPolicy getAgentPolicy(long templateId, UUID policyGUID) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(391);
        msg2.setFieldInt32(153L, (int)templateId);
        msg2.setField(222L, policyGUID);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        AgentPolicy policy = new AgentPolicy(response, 0x10000000L);
        return policy;
    }

    public HashMap<UUID, AgentPolicy> getAgentPolicyList(long templateId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(376);
        msg2.setFieldInt32(153L, (int)templateId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        HashMap<UUID, AgentPolicy> map = new HashMap<UUID, AgentPolicy>();
        long base2 = 0x10000000L;
        int size = response.getFieldAsInt32(629L);
        int i = 0;
        while (i < size) {
            AgentPolicy policy = new AgentPolicy(response, base2);
            map.put(policy.getGuid(), policy);
            ++i;
            base2 += 100L;
        }
        return map;
    }

    public UUID savePolicy(long templateId, AgentPolicy policy, boolean duplicate) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(374);
        msg2.setFieldInt32(153L, (int)templateId);
        msg2.setField(693L, duplicate);
        policy.fillMessage(msg2);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsUUID(222L);
    }

    public void deletePolicy(long templateId, UUID guid) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(375);
        msg2.setFieldInt32(153L, (int)templateId);
        msg2.setField(222L, guid);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void onPolicyEditorClose(long templateId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(377);
        msg2.setFieldInt32(153L, (int)templateId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void forcePolicyInstallation(long templateId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(378);
        msg2.setFieldInt32(153L, (int)templateId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<UserAgentNotification> getUserAgentNotifications() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(381);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(642L);
        ArrayList<UserAgentNotification> list = new ArrayList<UserAgentNotification>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list.add(new UserAgentNotification(response, fieldId, this));
            ++i;
            fieldId += 10L;
        }
        return list;
    }

    public void recallUserAgentNotification(long id) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(383);
        msg2.setFieldInt32(3L, (int)id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void createUserAgentNotification(String message2, long[] objects, Date startTime, Date endTime, boolean onStartup) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(382);
        msg2.setField(0x10000000L, message2);
        msg2.setField(0x10000001L, objects);
        msg2.setField(0x10000002L, startTime);
        msg2.setField(0x10000003L, endTime);
        msg2.setField(0x10000004L, onStartup);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void createUserAgentNotification(String message2, Collection<Long> objects, Date startTime, Date endTime, boolean onStartup) throws NXCException, IOException {
        long[] idList = new long[objects.size()];
        int i = 0;
        for (Long id : objects) {
            idList[i++] = id;
        }
        this.createUserAgentNotification(message2, idList, startTime, endTime, onStartup);
    }

    public List<NotificationChannel> getNotificationChannels() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(385);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(655L);
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(count2);
        long base2 = 0x10000000L;
        int i = 0;
        while (i < count2) {
            channels.add(new NotificationChannel(response, base2));
            ++i;
            base2 += 20L;
        }
        return channels;
    }

    public void createNotificationChannel(NotificationChannel nc) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(386);
        nc.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void updateNotificationChannel(NotificationChannel nc) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(387);
        nc.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deleteNotificationChannel(String name) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(388);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void renameNotificationChannel(String oldName, String newName) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(390);
        msg2.setField(20L, oldName);
        msg2.setField(657L, newName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<String> getNotificationDrivers() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(389);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        List<String> drivers = response.getStringListFromFields(0x10000000L, 656L);
        return drivers;
    }

    public void startManualActiveDiscovery(List<InetAddressListElement> ranges) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(392);
        msg2.setFieldInt32(174L, ranges.size());
        long fieldId = 0x10000000L;
        for (InetAddressListElement e : ranges) {
            e.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<PhysicalLink> getPhysicalLinks(long objectId, long patchPanelId) throws NXCException, IOException {
        ArrayList<PhysicalLink> links = new ArrayList<PhysicalLink>();
        NXCPMessage msg2 = this.newMessage(393);
        if (objectId > 0L) {
            msg2.setFieldInt32(3L, (int)objectId);
        }
        if (patchPanelId > 0L) {
            msg2.setFieldInt32(662L, (int)patchPanelId);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(663L);
        long base2 = 0x40000000L;
        for (int i = 0; i < count2; ++i) {
            links.add(new PhysicalLink(response, base2));
            base2 += 20L;
        }
        return links;
    }

    public void updatePhysicalLink(PhysicalLink link) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(394);
        link.fillMessage(msg2, 0x40000000L);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void deletePhysicalLink(long linkId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(395);
        msg2.setFieldInt32(665L, (int)linkId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<WebServiceDefinition> getWebServiceDefinitions() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(402);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<WebServiceDefinition> definitions = new ArrayList<WebServiceDefinition>(count2);
        for (int i = 0; i < count2; ++i) {
            response = this.waitForMessage(405, msg2.getMessageId());
            definitions.add(new WebServiceDefinition(response));
        }
        return definitions;
    }

    public int modifyWebServiceDefinition(WebServiceDefinition definition) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(403);
        definition.fillMessage(msg2);
        this.sendMessage(msg2);
        return this.waitForRCC(msg2.getMessageId()).getFieldAsInt32(680L);
    }

    public void deleteWebServiceDefinition(int id) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(404);
        msg2.setFieldInt32(680L, id);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Integer, List<String>> getAgentSharedSecrets() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(408);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>(count2);
        ArrayList<String> stringList = new ArrayList<String>();
        long fieldId = 0x10000000L;
        int currentZoneUIN = response.getFieldAsInt32(fieldId + 1L);
        int i = 0;
        while (i < count2) {
            int zoneUIN = response.getFieldAsInt32(fieldId + 1L);
            if (currentZoneUIN != zoneUIN) {
                map.put(currentZoneUIN, stringList);
                stringList = new ArrayList();
                currentZoneUIN = zoneUIN;
            }
            stringList.add(response.getFieldAsString(fieldId));
            ++i;
            fieldId += 10L;
        }
        if (count2 > 0) {
            map.put(currentZoneUIN, stringList);
        }
        return map;
    }

    public List<String> getAgentSharedSecrets(int zoneUIN) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(408);
        msg2.setFieldInt32(147L, zoneUIN);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        long fieldId = 0x10000000L;
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < count2; ++i) {
            stringList.add(response.getFieldAsString(fieldId++));
        }
        return stringList;
    }

    public void updateAgentSharedSecrets(int zoneUIN, List<String> sharedSecrets) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(409);
        msg2.setFieldInt32(147L, zoneUIN);
        long baseId = 0x10000000L;
        for (String s : sharedSecrets) {
            msg2.setField(baseId++, s);
        }
        msg2.setFieldInt32(361L, sharedSecrets.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Integer, List<Integer>> getWellKnownPorts(String tag) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(410);
        msg2.setField(675L, tag);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(607L);
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>(count2);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        long fieldId = 0x10000000L;
        int currentZoneUIN = response.getFieldAsInt32(fieldId + 1L);
        int i = 0;
        while (i < count2) {
            int zoneUIN = response.getFieldAsInt32(fieldId + 1L);
            if (currentZoneUIN != zoneUIN) {
                map.put(currentZoneUIN, portList);
                portList = new ArrayList();
                currentZoneUIN = zoneUIN;
            }
            portList.add(response.getFieldAsInt32(fieldId));
            ++i;
            fieldId += 10L;
        }
        if (count2 > 0) {
            map.put(currentZoneUIN, portList);
        }
        return map;
    }

    public List<Integer> getWellKnownPorts(int zoneUIN, String tag) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(410);
        msg2.setFieldInt32(147L, zoneUIN);
        msg2.setField(675L, tag);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(607L);
        ArrayList<Integer> portList = new ArrayList<Integer>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            portList.add(response.getFieldAsInt32(fieldId++));
        }
        return portList;
    }

    public void updateWellKnownPorts(int zoneUIN, String tag, List<Integer> ports) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(411);
        msg2.setFieldInt32(147L, zoneUIN);
        msg2.setField(675L, tag);
        long fieldId = 0x10000000L;
        for (Integer port : ports) {
            msg2.setFieldInt16(fieldId++, port);
        }
        msg2.setFieldInt32(607L, ports.size());
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<GeoArea> getGeoAreas() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(415);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<GeoArea> areas = new ArrayList<GeoArea>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            areas.add(new GeoArea(response, fieldId));
            ++i;
            fieldId += 4096L;
        }
        return areas;
    }

    public int modifyGeoArea(GeoArea area) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(416);
        area.fillMessage(msg2);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt32(723L);
    }

    public void deleteGeoArea(int areaId, boolean forceDelete) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(417);
        msg2.setFieldInt32(723L, areaId);
        msg2.setField(720L, forceDelete);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public long findProxyForNode(long nodeId) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(419);
        msg2.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsInt64(195L);
    }

    public List<SshKeyPair> getSshKeys(boolean withPublicKey) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(423);
        msg2.setField(745L, withPublicKey);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(746L);
        ArrayList<SshKeyPair> sshKeys = new ArrayList<SshKeyPair>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            sshKeys.add(new SshKeyPair(response, fieldId));
            ++i;
            fieldId += 5L;
        }
        return sshKeys;
    }

    public void deleteSshKey(int id, boolean force) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(424);
        msg2.setFieldInt32(747L, id);
        msg2.setField(720L, force);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void updateSshKey(SshKeyPair sshCertificateData) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(425);
        sshCertificateData.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void generateSshKeys(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(426);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public List<String> get2FADrivers() throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(37);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        List<String> drivers = response.getStringListFromFields(0x10000000L, 656L);
        return drivers;
    }

    public List<TwoFactorAuthenticationMethod> get2FAMethods() throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(432);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(751L);
        ArrayList<TwoFactorAuthenticationMethod> methods = new ArrayList<TwoFactorAuthenticationMethod>(count2);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            methods.add(new TwoFactorAuthenticationMethod(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        return methods;
    }

    public void modify2FAMethod(TwoFactorAuthenticationMethod method) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(434);
        method.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void rename2FAMethod(String oldName, String newName) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(38);
        msg2.setField(20L, oldName);
        msg2.setField(657L, newName);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void delete2FAMethod(String name) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(435);
        msg2.setField(20L, name);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Long, BusinessServiceCheck> getBusinessServiceChecks(long serviceId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(443);
        msg2.setFieldInt32(3L, (int)serviceId);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        HashMap<Long, BusinessServiceCheck> checks = new HashMap<Long, BusinessServiceCheck>();
        int count2 = response.getFieldAsInt32(768L);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            BusinessServiceCheck check2 = new BusinessServiceCheck(response, fieldId);
            checks.put(check2.getId(), check2);
            fieldId += 100L;
        }
        return checks;
    }

    public void deleteBusinessServiceCheck(long businessServiceid, long checkId) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(445);
        msg2.setFieldInt32(3L, (int)businessServiceid);
        msg2.setFieldInt32(769L, (int)checkId);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void modifyBusinessServiceCheck(long businessServiceid, BusinessServiceCheck check2) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(444);
        msg2.setFieldInt32(3L, (int)businessServiceid);
        check2.fillMessage(msg2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public double getBusinessServiceAvailablity(long businessServiceid, TimePeriod timePeriod) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(446);
        msg2.setFieldInt32(3L, (int)businessServiceid);
        msg2.setField(51L, timePeriod.getPeriodStart());
        msg2.setField(52L, timePeriod.getPeriodEnd());
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        return response.getFieldAsDouble(775L);
    }

    public List<BusinessServiceTicket> getBusinessServiceTickets(long businessServiceid, TimePeriod timePeriod) throws NXCException, IOException {
        NXCPMessage msg2 = this.newMessage(447);
        msg2.setFieldInt32(3L, (int)businessServiceid);
        msg2.setField(51L, timePeriod.getPeriodStart());
        msg2.setField(52L, timePeriod.getPeriodEnd());
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        ArrayList<BusinessServiceTicket> tickets = new ArrayList<BusinessServiceTicket>();
        int count2 = response.getFieldAsInt32(776L);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            BusinessServiceTicket ticket = new BusinessServiceTicket(response, fieldId);
            tickets.add(ticket);
            fieldId += 10L;
        }
        return tickets;
    }

    public DciValue[] findDCI(long rootObjectId, String query) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(449);
        msg2.setFieldInt32(3L, (int)rootObjectId);
        msg2.setField(143L, query);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        DciValue[] list = new DciValue[count2];
        long base2 = 0x10000000L;
        int i = 0;
        while (i < count2) {
            list[i] = DciValue.createFromMessage(response, base2);
            ++i;
            base2 += 50L;
        }
        return list;
    }

    public List<EventReference> getEventReferences(long eventCode) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(451);
        msg2.setFieldInt32(24L, (int)eventCode);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<EventReference> eventReferences = new ArrayList<EventReference>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            eventReferences.add(new EventReference(response, fieldId));
            fieldId += 100L;
        }
        return eventReferences;
    }

    public List<MaintenanceJournalEntry> getAllMaintenanceEntries(long objectId, int maxEntries) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(452);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt32(173L, maxEntries);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        ArrayList<MaintenanceJournalEntry> maintenanceEntries = new ArrayList<MaintenanceJournalEntry>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            maintenanceEntries.add(new MaintenanceJournalEntry(response, fieldId));
            fieldId += 10L;
        }
        return maintenanceEntries;
    }

    public void createMaintenanceEntry(long objectId, String description) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(453);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setField(27L, description);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public void editMaintenanceEntry(long objectId, long entryId, String description) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(454);
        msg2.setFieldInt32(3L, (int)objectId);
        msg2.setFieldInt32(704L, (int)entryId);
        msg2.setField(27L, description);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public Map<Long, MeasurementUnit> getDciMeasurementUnits(List<Long> nodeIds, List<Long> dciIds) throws IOException, NXCException {
        if (nodeIds.isEmpty()) {
            return new HashMap<Long, MeasurementUnit>();
        }
        NXCPMessage msg2 = this.newMessage(27);
        msg2.setFieldInt32(111L, nodeIds.size());
        msg2.setField(229L, nodeIds);
        msg2.setField(230L, dciIds);
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(111L);
        HashMap<Long, MeasurementUnit> result2 = new HashMap<Long, MeasurementUnit>(count2);
        long fieldId = 0x40000000L;
        for (int i = 0; i < count2; ++i) {
            result2.put(response.getFieldAsInt64(fieldId++), new MeasurementUnit(response, fieldId));
            fieldId += 2L;
        }
        return result2;
    }

    public Map<Long, MeasurementUnit> getDciMeasurementUnits(List<ChartDciConfig> dciList) throws IOException, NXCException {
        ArrayList<Long> nodeIds = new ArrayList<Long>(dciList.size());
        ArrayList<Long> dciIds = new ArrayList<Long>(dciList.size());
        for (ChartDciConfig dci : dciList) {
            nodeIds.add(dci.nodeId);
            dciIds.add(dci.dciId);
        }
        return this.getDciMeasurementUnits(nodeIds, dciIds);
    }

    public Map<Long, MeasurementUnit> getDciMeasurementUnits(ChartDciConfig[] dciList) throws IOException, NXCException {
        ArrayList<Long> nodeIds = new ArrayList<Long>(dciList.length);
        ArrayList<Long> dciIds = new ArrayList<Long>(dciList.length);
        for (ChartDciConfig dci : dciList) {
            nodeIds.add(dci.nodeId);
            dciIds.add(dci.dciId);
        }
        return this.getDciMeasurementUnits(nodeIds, dciIds);
    }

    public void cloneNetworkMap(long mapId, String newObjectName, String alias2) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(222);
        msg2.setFieldInt32(216L, (int)mapId);
        msg2.setField(20L, newObjectName);
        msg2.setField(494L, alias2);
        this.sendMessage(msg2);
        this.waitForRCC(msg2.getMessageId());
    }

    public String getVendorByMac(MacAddress mac, Runnable callback) {
        return this.ouiCache.getVendor(mac, callback);
    }

    public Map<MacAddress, String> getVendorByMac(Set<MacAddress> macList) throws IOException, NXCException {
        NXCPMessage msg2 = this.newMessage(224);
        msg2.setFieldInt32(361L, macList.size());
        long fieldId = 0x10000000L;
        for (MacAddress mac : macList) {
            msg2.setField(fieldId++, mac);
        }
        this.sendMessage(msg2);
        NXCPMessage response = this.waitForRCC(msg2.getMessageId());
        int count2 = response.getFieldAsInt32(361L);
        HashMap<MacAddress, String> result2 = new HashMap<MacAddress, String>(count2);
        fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            result2.put(response.getFieldAsMacAddress(fieldId), response.getFieldAsString(fieldId + 1L));
            fieldId += 2L;
        }
        return result2;
    }

    static /* synthetic */ LinkedBlockingQueue access$3400(NXCSession x0) {
        return x0.notificationQueue;
    }

    static /* synthetic */ Set access$3500(NXCSession x0) {
        return x0.listeners;
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            super("Network Message Receiver");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object;
            InputStream in;
            NXCPMessageReceiver receiver = new NXCPMessageReceiver(NXCSession.this.defaultRecvBufferSize, NXCSession.this.maxRecvBufferSize);
            try {
                in = NXCSession.this.socket.getInputStream();
            }
            catch (IOException e) {
                return;
            }
            int errorCount = 0;
            while (NXCSession.this.socket.isConnected()) {
                try {
                    NXCPMessage msg2 = receiver.receiveMessage(in, NXCSession.this.encryptionContext);
                    errorCount = 0;
                    switch (msg2.getMessageCode()) {
                        case 130: {
                            NXCSession.this.setupEncryption(msg2);
                            break;
                        }
                        case 3: {
                            NXCSession.this.serverTime = msg2.getFieldAsInt64(94L) * 1000L;
                            NXCSession.this.serverTimeRecvTime = System.currentTimeMillis();
                            break;
                        }
                        case 6: 
                        case 10: {
                            if (!msg2.getFieldAsBoolean(30L)) {
                                AbstractObject abstractObject = NXCSession.this.createObjectFromMessage(msg2);
                                object = NXCSession.this.objectList;
                                synchronized (object) {
                                    NXCSession.this.objectList.put(abstractObject.getObjectId(), abstractObject);
                                    NXCSession.this.objectListGUID.put(abstractObject.getGuid(), abstractObject);
                                    if (abstractObject instanceof Zone) {
                                        NXCSession.this.zoneList.put(((Zone)abstractObject).getUIN(), (Zone)abstractObject);
                                    }
                                    if (msg2.getMessageCode() != 10) break;
                                }
                                NXCSession.this.sendNotification(new SessionNotification(4, abstractObject.getObjectId(), abstractObject));
                                break;
                            }
                            long l = msg2.getFieldAsInt32(3L);
                            Map map = NXCSession.this.objectList;
                            synchronized (map) {
                                AbstractObject abstractObject = (AbstractObject)NXCSession.this.objectList.get(l);
                                if (abstractObject != null) {
                                    NXCSession.this.objectListGUID.remove(abstractObject.getGuid());
                                    NXCSession.this.objectList.remove(l);
                                    if (abstractObject instanceof Zone) {
                                        NXCSession.this.zoneList.remove(((Zone)abstractObject).getUIN());
                                    }
                                }
                            }
                            NXCSession.this.sendNotification(new SessionNotification(99, l));
                            break;
                        }
                        case 9: {
                            NXCSession.this.completeSync(NXCSession.this.syncObjects);
                            break;
                        }
                        case 414: {
                            this.processObjectCategoryUpdate(msg2);
                            break;
                        }
                        case 418: {
                            this.processGeoAreaUpdate(msg2);
                            break;
                        }
                        case 31: {
                            Object o;
                            User user2 = new User(msg2);
                            object = NXCSession.this.userDatabase;
                            synchronized (object) {
                                if (user2.isDeleted()) {
                                    o = (AbstractUserObject)NXCSession.this.userDatabase.remove(user2.getId());
                                    if (o != null) {
                                        NXCSession.this.userDatabaseGUID.remove(((AbstractUserObject)o).getGuid());
                                    }
                                    NXCSession.this.missingUsers.add(user2.getId());
                                } else {
                                    NXCSession.this.userDatabase.put(user2.getId(), user2);
                                    NXCSession.this.userDatabaseGUID.put(user2.getGuid(), user2);
                                    NXCSession.this.missingUsers.remove(user2.getId());
                                }
                                break;
                            }
                        }
                        case 32: {
                            UserGroup group = new UserGroup(msg2);
                            Object o = NXCSession.this.userDatabase;
                            synchronized (o) {
                                if (group.isDeleted()) {
                                    AbstractUserObject abstractUserObject = (AbstractUserObject)NXCSession.this.userDatabase.remove(group.getId());
                                    if (abstractUserObject != null) {
                                        NXCSession.this.userDatabaseGUID.remove(abstractUserObject.getGuid());
                                    }
                                    NXCSession.this.missingUsers.add(group.getId());
                                } else {
                                    NXCSession.this.userDatabase.put(group.getId(), group);
                                    NXCSession.this.userDatabaseGUID.put(group.getGuid(), group);
                                    NXCSession.this.missingUsers.add(group.getId());
                                }
                                break;
                            }
                        }
                        case 33: {
                            NXCSession.this.completeSync(NXCSession.this.syncUserDB);
                            break;
                        }
                        case 39: {
                            this.processUserDBUpdate(msg2);
                            break;
                        }
                        case 73: {
                            NXCSession.this.sendNotification(new SessionNotification(msg2.getFieldAsInt32(23L) + 1000, new Alarm(msg2)));
                            break;
                        }
                        case 345: {
                            this.processBulkAlarmStateChange(msg2);
                            break;
                        }
                        case 141: {
                            NXCSession.this.sendNotification(new SessionNotification(10, new ServerJob(msg2)));
                            break;
                        }
                        case 105: {
                            this.processFileData(msg2);
                            break;
                        }
                        case 285: {
                            this.processFileTail(msg2);
                            break;
                        }
                        case 114: {
                            this.processFileTransferError(msg2);
                            break;
                        }
                        case 18: {
                            this.processNotificationMessage(msg2, true);
                            break;
                        }
                        case 4358: {
                            this.processNotificationMessage(msg2, false);
                            break;
                        }
                        case 12: {
                            this.processNewEvents(msg2);
                            break;
                        }
                        case 160: {
                            this.processNewTraps(msg2);
                            break;
                        }
                        case 140: {
                            this.processSyslogRecords(msg2);
                            break;
                        }
                        case 79: {
                            this.processActionConfigChange(msg2);
                            break;
                        }
                        case 24: {
                            this.processEventConfigChange(msg2);
                            break;
                        }
                        case 25: {
                            this.processTrapConfigChange(msg2);
                            break;
                        }
                        case 127: {
                            this.processConsoleOutput(msg2);
                            break;
                        }
                        case 256: {
                            this.processImageLibraryUpdate(msg2);
                            break;
                        }
                        case 307: {
                            GraphDefinition graph = GraphDefinition.createGraphSettings(msg2, 0x10000000L);
                            NXCSession.this.sendNotification(new SessionNotification(1012, graph.getId(), graph));
                            break;
                        }
                        case 342: {
                            this.processAlarmCategoryConfigChange(msg2);
                            break;
                        }
                        case 112: {
                            this.processThresholdChange(msg2);
                            break;
                        }
                        case 365: {
                            this.processTcpProxyData((int)msg2.getMessageId(), msg2.getBinaryData());
                            break;
                        }
                        case 366: {
                            this.processTcpProxyClosure(msg2.getFieldAsInt32(574L), msg2.getFieldAsInt32(28L));
                            break;
                        }
                        case 45: {
                            void var8_21;
                            int type = msg2.getFieldAsInt32(411L);
                            switch (type) {
                                case 1: {
                                    DataCollectionItem dataCollectionItem = new DataCollectionItem(null, msg2);
                                    break;
                                }
                                case 2: {
                                    DataCollectionTable dataCollectionTable = new DataCollectionTable(null, msg2);
                                    break;
                                }
                                default: {
                                    Object var8_20 = null;
                                }
                            }
                            NXCSession.this.sendNotification(new SessionNotification(1035, msg2.getFieldAsInt64(3L), var8_21));
                            break;
                        }
                        case 44: {
                            NXCSession.this.sendNotification(new SessionNotification(1036, msg2.getFieldAsInt64(3L), msg2.getFieldAsInt64(43L)));
                            break;
                        }
                        case 104: {
                            int itemCount = msg2.getFieldAsInt32(111L);
                            long[] itemList = new long[itemCount];
                            int pos = 0;
                            for (int i = 0; i < itemCount; ++i) {
                                itemList[pos++] = msg2.getFieldAsInt32(112L + (long)i);
                            }
                            NXCSession.this.sendNotification(new SessionNotification(1037, msg2.getFieldAsInt64(3L), new DCOStatusHolder(itemList, msg2.getFieldAsInt32(48L))));
                            break;
                        }
                        case 374: {
                            NXCSession.this.sendNotification(new SessionNotification(1039, msg2.getFieldAsInt64(153L), new AgentPolicy(msg2)));
                            break;
                        }
                        case 375: {
                            NXCSession.this.sendNotification(new SessionNotification(1040, msg2.getFieldAsInt64(153L), msg2.getFieldAsUUID(222L)));
                            break;
                        }
                        case 48: {
                            NXCSession.this.userSystemRights = msg2.getFieldAsInt64(36L);
                            NXCSession.this.sendNotification(new SessionNotification(13, NXCSession.this.userSystemRights));
                            break;
                        }
                        case 444: {
                            NXCSession.this.sendNotification(new SessionNotification(1057, msg2.getFieldAsInt64(0x10000000L), new BusinessServiceCheck(msg2, 0x10000000L)));
                            break;
                        }
                        case 445: {
                            NXCSession.this.sendNotification(new SessionNotification(1058, msg2.getFieldAsInt64(769L)));
                            break;
                        }
                        case 223: {
                            NXCSession.this.sendNotification(new SessionNotification(msg2.getFieldAsInt32(23L) + 1000, new AgentTunnel(msg2, 0x10000000L)));
                            break;
                        }
                        default: {
                            Map map = NXCSession.this.messageSubscriptions;
                            synchronized (map) {
                                MessageSubscription s = new MessageSubscription(msg2.getMessageCode(), msg2.getMessageId());
                                MessageHandler handler2 = (MessageHandler)NXCSession.this.messageSubscriptions.get(s);
                                if (handler2 != null) {
                                    if (handler2.processMessage(msg2)) {
                                        msg2 = null;
                                    }
                                    if (handler2.isComplete()) {
                                        NXCSession.this.messageSubscriptions.remove(s);
                                    } else {
                                        handler2.setLastMessageTimestamp(System.currentTimeMillis());
                                    }
                                }
                                if (msg2 == null) break;
                            }
                            if (msg2.getMessageCode() >= 4096) {
                                NXCSession.this.sendNotification(new SessionNotification(2000, msg2));
                            }
                            NXCSession.this.msgWaitQueue.putMessage(msg2);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    logger.debug("Receiver error", e);
                    NXCSession.this.receiverStopCause = e;
                    break;
                }
                catch (NXCPException e) {
                    logger.debug("Receiver error", e);
                    if (e.getErrorCode() == 2) {
                        NXCSession.this.receiverStopCause = e;
                        break;
                    }
                    ++errorCount;
                }
                catch (NXCException e) {
                    logger.debug("Receiver error", e);
                    if (e.getErrorCode() == 98) {
                        NXCSession.this.receiverStopCause = e;
                        break;
                    }
                    ++errorCount;
                }
                if (errorCount <= 100) continue;
                NXCSession.this.receiverStopCause = new NXCPException(5);
                break;
            }
            Map map = NXCSession.this.tcpProxies;
            synchronized (map) {
                Throwable throwable = NXCSession.this.receiverStopCause != null ? NXCSession.this.receiverStopCause : new NXCPException(2);
                object = NXCSession.this.tcpProxies.values().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        // MONITOREXIT @DISABLED, blocks:[66, 67, 8] lbl267 : MonitorExitStatement: MONITOREXIT : var4_5
                        logger.info("Network receiver thread stopped");
                        NXCSession.this.msgWaitQueue.shutdown();
                        return;
                    }
                    TcpProxy p = (TcpProxy)object.next();
                    p.abort(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processConsoleOutput(NXCPMessage msg2) {
            String text2 = msg2.getFieldAsString(26L);
            Set set = NXCSession.this.consoleListeners;
            synchronized (set) {
                for (ServerConsoleListener l : NXCSession.this.consoleListeners) {
                    l.onConsoleOutput(text2);
                }
            }
        }

        private void processNewEvents(NXCPMessage msg2) {
            int count2 = msg2.getFieldAsInt32(174L);
            int order = msg2.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count2; ++i) {
                Event event = new Event(msg2, varId);
                NXCSession.this.sendNotification(new SessionNotification(2, order, event));
            }
        }

        private void processNewTraps(NXCPMessage msg2) {
            int count2 = msg2.getFieldAsInt32(174L);
            int order = msg2.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count2; ++i) {
                SnmpTrapLogRecord trap = new SnmpTrapLogRecord(msg2, varId);
                NXCSession.this.sendNotification(new SessionNotification(8, order, trap));
            }
        }

        private void processSyslogRecords(NXCPMessage msg2) {
            int count2 = msg2.getFieldAsInt32(174L);
            int order = msg2.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count2; ++i) {
                SyslogRecord record = new SyslogRecord(msg2, varId);
                NXCSession.this.sendNotification(new SessionNotification(7, order, record));
            }
        }

        private void processBulkAlarmStateChange(NXCPMessage msg2) {
            int code2 = msg2.getFieldAsInt32(23L) + 1000;
            NXCSession.this.sendNotification(new SessionNotification(code2, new BulkAlarmStateChangeData(msg2)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNotificationMessage(NXCPMessage msg2, boolean shiftCode) {
            int code2 = msg2.getFieldAsInt32(23L);
            if (shiftCode) {
                code2 += 1000;
            }
            long data = msg2.getFieldAsInt64(92L);
            switch (code2) {
                case 1024: {
                    NXCSession.this.strictAlarmStatusFlow = (int)data != 0;
                    break;
                }
                case 1002: {
                    if (!NXCSession.this.eventTemplatesSynchronized) break;
                    NXCSession.this.resyncEventTemplates();
                    break;
                }
                case 1: 
                case 1001: 
                case 1027: {
                    NXCSession.this.backgroundDisconnect(code2);
                    return;
                }
                case 1049: {
                    Map map = NXCSession.this.objectCategories;
                    synchronized (map) {
                        NXCSession.this.objectCategories.remove((int)data);
                        break;
                    }
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code2, data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileTail(NXCPMessage msg2) {
            String fileName = msg2.getFieldAsString(125L);
            String fileContent = msg2.getFieldAsString(460L);
            Map map = NXCSession.this.receivedFileUpdates;
            synchronized (map) {
                NXCSession.this.receivedFileUpdates.put(fileName, fileContent);
                NXCSession.this.receivedFileUpdates.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileData(NXCPMessage msg2) {
            NXCReceivedFile file;
            long id = msg2.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
            }
            int bytes = file.writeData(msg2.getBinaryData(), msg2.isCompressedStream());
            NXCSession.this.notifyProgressListener(id, bytes);
            if (msg2.isEndOfFile()) {
                file.close();
                Map map2 = NXCSession.this.receivedFiles;
                synchronized (map2) {
                    NXCSession.this.receivedFiles.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileTransferError(NXCPMessage msg2) {
            long id = msg2.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
                file.abortTransfer(msg2.getFieldAsBoolean(609L));
                NXCSession.this.receivedFiles.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUserDBUpdate(NXCPMessage msg2) {
            int code2 = msg2.getFieldAsInt32(42L);
            long id = msg2.getFieldAsInt64(35L);
            AbstractUserObject object = null;
            switch (code2) {
                case 0: 
                case 2: {
                    object = (id & 0x40000000L) != 0L ? new UserGroup(msg2) : new User(msg2);
                    Map map = NXCSession.this.userDatabase;
                    synchronized (map) {
                        NXCSession.this.userDatabase.put(id, object);
                        NXCSession.this.userDatabaseGUID.put(object.getGuid(), object);
                        NXCSession.this.missingUsers.remove(id);
                        break;
                    }
                }
                case 1: {
                    Map map = NXCSession.this.userDatabase;
                    synchronized (map) {
                        object = (AbstractUserObject)NXCSession.this.userDatabase.get(id);
                        if (object != null) {
                            NXCSession.this.userDatabase.remove(id);
                            NXCSession.this.userDatabaseGUID.remove(object.getGuid());
                        }
                        NXCSession.this.missingUsers.add(id);
                        break;
                    }
                }
            }
            if (object != null) {
                NXCSession.this.sendNotification(new SessionNotification(3, code2, object));
            }
        }

        private void processTrapConfigChange(NXCPMessage msg2) {
            int code2 = msg2.getFieldAsInt32(23L) + 1000;
            long id = msg2.getFieldAsInt64(117L);
            SnmpTrap trap = code2 != 1018 ? new SnmpTrap(msg2) : null;
            NXCSession.this.sendNotification(new SessionNotification(code2, id, trap));
        }

        private void processActionConfigChange(NXCPMessage msg2) {
            int code2 = msg2.getFieldAsInt32(23L) + 1000;
            long id = msg2.getFieldAsInt64(97L);
            ServerAction action = code2 != 1008 ? new ServerAction(msg2) : null;
            NXCSession.this.sendNotification(new SessionNotification(code2, id, action));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEventConfigChange(NXCPMessage msg2) {
            EventTemplate tmpl;
            int code2 = msg2.getFieldAsInt32(23L) + 1000;
            long eventCode = msg2.getFieldAsInt64(24L);
            EventTemplate eventTemplate = tmpl = code2 != 1014 ? new EventTemplate(msg2, 0x10000000L) : null;
            if (NXCSession.this.eventTemplatesSynchronized) {
                Map map = NXCSession.this.eventTemplates;
                synchronized (map) {
                    if (code2 == 1014) {
                        NXCSession.this.eventTemplates.remove(eventCode);
                    } else {
                        NXCSession.this.eventTemplates.put(tmpl.getCode(), tmpl);
                    }
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code2, tmpl == null ? eventCode : tmpl.getCode(), tmpl));
        }

        private void processImageLibraryUpdate(NXCPMessage msg2) {
            UUID imageGuid = msg2.getFieldAsUUID(222L);
            int flags = msg2.getFieldAsInt32(13L);
            NXCSession.this.sendNotification(new SessionNotification(11, flags == 0 ? 201L : 202L, imageGuid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processObjectCategoryUpdate(NXCPMessage msg2) {
            ObjectCategory category = new ObjectCategory(msg2, 0x10000000L);
            Map map = NXCSession.this.objectCategories;
            synchronized (map) {
                NXCSession.this.objectCategories.put(category.getId(), category);
            }
            NXCSession.this.sendNotification(new SessionNotification(1048, category.getId(), category));
        }

        private void processGeoAreaUpdate(NXCPMessage msg2) {
            GeoArea area = new GeoArea(msg2, 0x10000000L);
            NXCSession.this.sendNotification(new SessionNotification(1050, area.getId(), area));
        }

        public void processThresholdChange(NXCPMessage msg2) {
            NXCSession.this.sendNotification(new SessionNotification(12, msg2.getFieldAsInt64(3L), new ThresholdStateChange(msg2)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAlarmCategoryConfigChange(NXCPMessage msg2) {
            AlarmCategory ac;
            int code2 = msg2.getFieldAsInt32(23L) + 1000;
            long categoryId = msg2.getFieldAsInt64(0x10000000L);
            AlarmCategory alarmCategory = ac = code2 != 1031 ? new AlarmCategory(msg2, 0x10000000L) : null;
            if (NXCSession.this.alarmCategoriesSynchronized) {
                Map map = NXCSession.this.alarmCategories;
                synchronized (map) {
                    if (code2 == 1031) {
                        NXCSession.this.alarmCategories.remove(categoryId);
                    } else {
                        NXCSession.this.alarmCategories.put(categoryId, ac);
                    }
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code2, categoryId, ac));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTcpProxyData(int channelId, byte[] data) {
            TcpProxy proxy;
            Map map = NXCSession.this.tcpProxies;
            synchronized (map) {
                proxy = (TcpProxy)NXCSession.this.tcpProxies.get(channelId);
            }
            if (proxy != null) {
                proxy.processRemoteData(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTcpProxyClosure(int channelId, int rcc) {
            TcpProxy proxy;
            Map map = NXCSession.this.tcpProxies;
            synchronized (map) {
                proxy = (TcpProxy)NXCSession.this.tcpProxies.remove(channelId);
            }
            if (proxy != null) {
                if (rcc == 0) {
                    proxy.localClose();
                } else {
                    proxy.abort(new NXCException(rcc));
                }
            }
        }
    }

    private class HousekeeperThread
    extends Thread {
        private boolean stopFlag = false;

        HousekeeperThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopFlag) {
                Iterator<Object> it;
                try {
                    HousekeeperThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long currTime = System.currentTimeMillis();
                Map map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    it = NXCSession.this.receivedFiles.values().iterator();
                    while (it.hasNext()) {
                        NXCReceivedFile file = (NXCReceivedFile)it.next();
                        if (file.getTimestamp() + 300000L >= currTime) continue;
                        file.getFile().delete();
                        it.remove();
                    }
                }
                map = NXCSession.this.messageSubscriptions;
                synchronized (map) {
                    it = NXCSession.this.messageSubscriptions.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = (Map.Entry)it.next();
                        MessageHandler h = (MessageHandler)e.getValue();
                        if (currTime - h.getLastMessageTimestamp() <= (long)h.getMessageWaitTimeout()) continue;
                        h.setExpired();
                        it.remove();
                    }
                }
            }
        }

        public void setStopFlag(boolean stopFlag) {
            this.stopFlag = stopFlag;
        }
    }

    protected static final class MessageSubscription {
        protected int messageCode;
        protected long messageId;

        protected MessageSubscription(int messageCode, long messageId) {
            this.messageCode = messageCode;
            this.messageId = messageId;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.messageCode;
            result2 = 31 * result2 + (int)(this.messageId ^ this.messageId >>> 32);
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageSubscription other = (MessageSubscription)obj;
            if (this.messageCode != other.messageCode) {
                return false;
            }
            return this.messageId == other.messageId;
        }
    }

    private class NotificationProcessor
    extends Thread {
        private SessionListener[] cachedListenerList = new SessionListener[0];

        NotificationProcessor() {
            this.setName("Session Notification Processor");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    n = (SessionNotification)NXCSession.access$3400(NXCSession.this).take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (n.getCode() == 32767) break;
                if (n.getCode() == 32766) {
                    var2_2 /* !! */  = NXCSession.access$3500(NXCSession.this);
                    synchronized (var2_2 /* !! */ ) {
                        this.cachedListenerList = NXCSession.access$3500(NXCSession.this).toArray(new SessionListener[NXCSession.access$3500(NXCSession.this).size()]);
                    }
                }
                var2_2 /* !! */  = this.cachedListenerList;
                var3_4 = var2_2 /* !! */ .length;
                var4_6 = 0;
                while (true) {
                    if (var4_6 < var3_4) ** break;
                    continue block7;
                    l = var2_2 /* !! */ [var4_6];
                    try {
                        l.notificationHandler(n);
                    }
                    catch (Exception e) {
                        NXCSession.access$2000().error("Unhandled exception in notification handler", e);
                    }
                    ++var4_6;
                }
                break;
            }
            this.cachedListenerList = null;
        }
    }

    class BackgroundUserSync
    extends Thread {
        public BackgroundUserSync() {
            this.setName("BackgroundUserSync");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                List callbackListCopy;
                Set userSyncListCopy;
                Set set = NXCSession.this.userSyncList;
                synchronized (set) {
                    while (NXCSession.this.userSyncList.isEmpty()) {
                        try {
                            NXCSession.this.userSyncList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = NXCSession.this.userSyncList;
                synchronized (object) {
                    userSyncListCopy = NXCSession.this.userSyncList;
                    NXCSession.this.userSyncList = new HashSet();
                    callbackListCopy = NXCSession.this.callbackList;
                    NXCSession.this.callbackList = new ArrayList();
                }
                try {
                    NXCSession.this.syncMissingUsers(userSyncListCopy);
                    object = callbackListCopy.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block12;
                        Runnable cb = (Runnable)object.next();
                        cb.run();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while synchronizing user database objects", e);
                    continue;
                }
                break;
            }
        }
    }

    private static class ScriptExecutionUpdateHandler
    extends MessageHandler {
        private TextOutputListener listener;
        private int errorCode = 0;
        private String errorMessage = null;

        ScriptExecutionUpdateHandler(TextOutputListener listener) {
            this.listener = listener;
        }

        @Override
        public boolean processMessage(NXCPMessage m) {
            int rcc = m.getFieldAsInt32(28L);
            if (rcc != 0) {
                this.errorCode = rcc;
                this.errorMessage = m.getFieldAsString(259L);
                if (this.errorMessage == null) {
                    this.errorMessage = "Unspecified sript execution error (RCC=" + rcc + ")";
                }
                if (this.listener != null) {
                    this.listener.messageReceived(this.errorMessage + "\n\n");
                    this.listener.onError();
                }
            } else {
                String text2 = m.getFieldAsString(26L);
                if (text2 != null && this.listener != null) {
                    this.listener.messageReceived(text2);
                }
            }
            if (m.isEndOfSequence()) {
                this.setComplete();
            }
            return true;
        }

        public boolean isFailure() {
            return this.errorMessage != null;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

