/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ServerActionType;

public class ServerAction {
    private long id;
    private ServerActionType type;
    private String name;
    private String data;
    private String recipientAddress;
    private String emailSubject;
    private boolean disabled;
    private String channelName;

    public ServerAction(long id) {
        this.id = id;
        this.type = ServerActionType.LOCAL_COMMAND;
        this.name = "New action";
        this.data = "";
        this.disabled = false;
        this.channelName = "";
    }

    protected ServerAction(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt64(97L);
        this.type = ServerActionType.getByValue(msg2.getFieldAsInt32(99L));
        this.name = msg2.getFieldAsString(87L);
        this.data = msg2.getFieldAsString(100L);
        this.recipientAddress = msg2.getFieldAsString(102L);
        this.emailSubject = msg2.getFieldAsString(101L);
        this.disabled = msg2.getFieldAsBoolean(98L);
        this.channelName = msg2.getFieldAsString(654L);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(97L, (int)this.id);
        msg2.setFieldInt16(99L, this.type.getValue());
        msg2.setField(87L, this.name);
        msg2.setField(100L, this.data);
        msg2.setField(102L, this.recipientAddress);
        msg2.setField(101L, this.emailSubject);
        msg2.setFieldInt16(98L, this.disabled ? 1 : 0);
        msg2.setField(654L, this.channelName);
    }

    public ServerActionType getType() {
        return this.type;
    }

    public void setType(ServerActionType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
}

