/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.interfaces.NodeItemPair;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dci", strict=false)
public class ChartDciConfig
implements NodeItemPair {
    public static final String UNSET_COLOR = "UNSET";
    public static final int ITEM = 1;
    public static final int TABLE = 2;
    public static final int DEFAULT = -1;
    public static final int LINE = 0;
    public static final int AREA = 1;
    private static final int UNSET = -99;
    @Attribute
    public long nodeId;
    @Attribute
    public long dciId;
    @Element(required=false)
    public String dciName;
    @Element(required=false)
    public String dciDescription;
    @Element(required=false)
    public int type;
    @Element(required=false)
    public String color;
    @Element(required=false)
    public String name;
    @Element(required=false)
    public int lineWidth;
    @Element(required=false)
    public int lineChartType;
    @Element(required=false)
    protected int displayType;
    @Element(required=false)
    public boolean showThresholds;
    @Element(required=false)
    public boolean invertValues;
    @Element(required=false)
    public boolean useRawValues;
    @Element(required=false)
    public boolean multiMatch;
    @Element(required=false)
    public String instance;
    @Element(required=false)
    public String column;
    @Element(required=false)
    public String displayFormat;

    public ChartDciConfig() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.dciName = "";
        this.dciDescription = "";
        this.type = 1;
        this.color = UNSET_COLOR;
        this.name = "";
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.multiMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public ChartDciConfig(ChartDciConfig src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.dciName = src.dciName;
        this.dciDescription = src.dciDescription;
        this.type = src.type;
        this.color = src.color;
        this.name = src.name;
        this.lineWidth = src.lineWidth;
        this.lineChartType = src.lineChartType;
        this.displayType = src.displayType;
        this.showThresholds = src.showThresholds;
        this.invertValues = src.invertValues;
        this.useRawValues = src.useRawValues;
        this.multiMatch = src.multiMatch;
        this.instance = src.instance;
        this.column = src.column;
        this.displayFormat = src.displayFormat;
    }

    public ChartDciConfig(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.dciName = dci.getName();
        this.dciDescription = dci.getDescription();
        this.type = dci.getDcObjectType();
        this.name = dci.getDescription();
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.useRawValues = false;
        this.multiMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public ChartDciConfig(DataCollectionObject dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.dciName = dci.getName();
        this.dciDescription = dci.getDescription();
        this.type = dci instanceof DataCollectionItem ? 1 : 2;
        this.name = dci.getDescription();
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.useRawValues = false;
        this.multiMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public int getColorAsInt() {
        if (this.color.equals(UNSET_COLOR)) {
            return -1;
        }
        if (this.color.startsWith("0x")) {
            return Integer.parseInt(this.color.substring(2), 16);
        }
        return Integer.parseInt(this.color, 10);
    }

    public void setColor(int value) {
        this.color = "0x" + Integer.toHexString(value);
    }

    public String getLabel() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.dciDescription != null && !this.dciDescription.isEmpty()) {
            return this.dciDescription;
        }
        if (this.dciName != null && !this.dciName.isEmpty()) {
            return this.dciName;
        }
        return "[" + Long.toString(this.dciId) + "]";
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public int getLineChartType() {
        return this.displayType != -99 ? this.displayType - 1 : this.lineChartType;
    }

    public String getDciName() {
        return this.dciName == null ? "" : this.dciName;
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getDciDescription() {
        return this.dciDescription == null ? "" : this.dciDescription;
    }

    public void setDciDescription(String dciDescription) {
        this.dciDescription = dciDescription;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.dciId ^ this.dciId >>> 32);
        if (this.dciId == 0L) {
            result2 = 31 * result2 + (this.dciDescription == null ? 0 : this.dciDescription.hashCode());
            result2 = 31 * result2 + (this.dciName == null ? 0 : this.dciName.hashCode());
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartDciConfig other = (ChartDciConfig)obj;
        if (this.dciId != other.dciId) {
            return false;
        }
        if (this.dciId != 0L) {
            return true;
        }
        if (this.dciDescription == null ? other.dciDescription != null : !this.dciDescription.equals(other.dciDescription)) {
            return false;
        }
        return !(this.dciName == null ? other.dciName != null : !this.dciName.equals(other.dciName));
    }

    public String toString() {
        return "ChartDciConfig [nodeId=" + this.nodeId + ", dciId=" + this.dciId + ", dciName=" + this.dciName + ", dciDescription=" + this.dciDescription + ", type=" + this.type + ", color=" + this.color + ", name=" + this.name + ", lineWidth=" + this.lineWidth + ", lineChartType=" + this.lineChartType + ", displayType=" + this.displayType + ", showThresholds=" + this.showThresholds + ", invertValues=" + this.invertValues + ", useRawValues=" + this.useRawValues + ", multiMatch=" + this.multiMatch + ", instance=" + this.instance + ", column=" + this.column + ", displayFormat=" + this.displayFormat + "]";
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getDciId() {
        return this.dciId;
    }
}

