/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.TableDciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.datacollection.TimeFormatter;

public abstract class DciValue {
    public static final int MULTIPLIERS_DEFAULT = 0;
    public static final int MULTIPLIERS_YES = 1;
    public static final int MULTIPLIERS_NO = 2;
    protected long id;
    protected long nodeId;
    protected long templateDciId;
    protected String name;
    protected String description;
    protected String value;
    protected DataOrigin source;
    protected DataType dataType;
    protected int status;
    protected int errorCount;
    protected int dcObjectType;
    protected Date timestamp;
    protected Threshold activeThreshold;
    protected int flags;
    protected MeasurementUnit measurementUnit;

    public static DciValue createFromMessage(NXCPMessage msg2, long base2) {
        int type = msg2.getFieldAsInt32(base2 + 10L);
        switch (type) {
            case 1: {
                return new SimpleDciValue(msg2, base2);
            }
            case 2: {
                return new TableDciValue(msg2, base2);
            }
        }
        return null;
    }

    protected DciValue() {
    }

    protected DciValue(NXCPMessage msg2, long base2) {
        long fieldId = base2;
        this.nodeId = msg2.getFieldAsInt64(fieldId++);
        this.id = msg2.getFieldAsInt64(fieldId++);
        this.name = msg2.getFieldAsString(fieldId++);
        this.flags = msg2.getFieldAsInt32(fieldId++);
        this.description = msg2.getFieldAsString(fieldId++);
        this.source = DataOrigin.getByValue(msg2.getFieldAsInt32(fieldId++));
        this.dataType = DataType.getByValue(msg2.getFieldAsInt32(fieldId++));
        this.value = msg2.getFieldAsString(fieldId++);
        this.timestamp = msg2.getFieldAsDate(fieldId++);
        this.status = msg2.getFieldAsInt32(fieldId++);
        this.dcObjectType = msg2.getFieldAsInt32(fieldId++);
        this.errorCount = msg2.getFieldAsInt32(fieldId++);
        this.templateDciId = msg2.getFieldAsInt64(fieldId++);
        this.measurementUnit = new MeasurementUnit(msg2, fieldId);
        fieldId += 2L;
        this.activeThreshold = msg2.getFieldAsBoolean(fieldId++) ? new Threshold(msg2, fieldId) : null;
    }

    public String format(String formatString, TimeFormatter formatter2) {
        return new DataFormatter(formatString, this.dataType, this.measurementUnit).format(this.value, formatter2);
    }

    public String getFormattedValue(boolean useMultipliers, TimeFormatter formatter2) {
        int selection = this.getMultipliersSelection();
        String format = selection == 0 && useMultipliers || selection == 1 ? "%{m,u}s" : "%{u}s";
        return new DataFormatter(format, this.dataType, this.measurementUnit).format(this.value, formatter2);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name.isEmpty() ? "[" + this.getId() + "]" : this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public DataOrigin getSource() {
        return this.source;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Threshold getActiveThreshold() {
        return this.activeThreshold;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final long getTemplateDciId() {
        return this.templateDciId;
    }

    public Severity getThresholdSeverity() {
        return this.activeThreshold != null ? this.activeThreshold.getCurrentSeverity() : Severity.NORMAL;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMultipliersSelection() {
        return (this.flags & 0x30000) >> 16;
    }

    public Severity getMostCriticalSeverity() {
        return this.getThresholdSeverity();
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public String toString() {
        return "DciValue [id=" + this.id + ", nodeId=" + this.nodeId + ", templateDciId=" + this.templateDciId + ", name=" + this.name + ", description=" + this.description + ", value=" + this.value + ", source=" + (Object)((Object)this.source) + ", dataType=" + (Object)((Object)this.dataType) + ", status=" + this.status + ", errorCount=" + this.errorCount + ", dcObjectType=" + this.dcObjectType + ", timestamp=" + this.timestamp + ", activeThreshold=" + this.activeThreshold + ", flags=" + this.flags + ", measurementUnit=" + this.measurementUnit + "]";
    }
}

