/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class EventInfo {
    private long id;
    private Date timeStamp;
    private long sourceObjectId;
    private int code;
    private String name;
    private int severity;
    private String message;
    private EventInfo parent;
    private List<EventInfo> children;

    public EventInfo(NXCPMessage msg2, long baseId, EventInfo parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.children = null;
        this.id = msg2.getFieldAsInt64(baseId);
        this.code = msg2.getFieldAsInt32(baseId + 2L);
        this.name = msg2.getFieldAsString(baseId + 3L);
        this.severity = msg2.getFieldAsInt32(baseId + 4L);
        this.sourceObjectId = msg2.getFieldAsInt64(baseId + 5L);
        this.timeStamp = msg2.getFieldAsDate(baseId + 6L);
        this.message = msg2.getFieldAsString(baseId + 7L);
    }

    private void addChild(EventInfo e) {
        if (this.children == null) {
            this.children = new ArrayList<EventInfo>();
        }
        this.children.add(e);
    }

    public long getId() {
        return this.id;
    }

    public EventInfo getParent() {
        return this.parent;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public EventInfo[] getChildren() {
        return this.children != null ? this.children.toArray(new EventInfo[this.children.size()]) : new EventInfo[]{};
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }
}

