/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.LinkLayerDiscoveryProtocol;
import org.netxms.client.constants.OSPFInterfaceState;
import org.netxms.client.constants.OSPFInterfaceType;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.interfaces.NodeChild;
import org.netxms.client.objects.interfaces.ZoneMember;
import org.netxms.client.snmp.SnmpObjectId;

public class Interface
extends GenericObject
implements ZoneMember,
NodeChild {
    public static final int IF_SYNTHETIC_MASK = 1;
    public static final int IF_PHYSICAL_PORT = 2;
    public static final int IF_EXCLUDE_FROM_TOPOLOGY = 4;
    public static final int IF_LOOPBACK = 8;
    public static final int IF_CREATED_MANUALLY = 16;
    public static final int IF_PEER_REFLECTION = 32;
    public static final int IF_INCLUDE_IN_ICMP_POLL = 64;
    public static final int IF_DISABLE_SNMP_STATUS_POLL = 128;
    public static final int IF_DISABLE_ICMP_STATUS_POLL = 256;
    public static final int IF_DISABLE_AGENT_STATUS_POLL = 512;
    public static final int IF_OSPF_INTERFACE = 1024;
    public static final int IF_EXPECTED_STATE_MASK = 0x30000000;
    public static final int ADMIN_STATE_UNKNOWN = 0;
    public static final int ADMIN_STATE_UP = 1;
    public static final int ADMIN_STATE_DOWN = 2;
    public static final int ADMIN_STATE_TESTING = 3;
    public static final int OPER_STATE_UNKNOWN = 0;
    public static final int OPER_STATE_UP = 1;
    public static final int OPER_STATE_DOWN = 2;
    public static final int OPER_STATE_TESTING = 3;
    public static final int OPER_STATE_DORMANT = 4;
    public static final int OPER_STATE_NOT_PRESENT = 5;
    public static final int EXPECTED_STATE_UP = 0;
    public static final int EXPECTED_STATE_DOWN = 1;
    public static final int EXPECTED_STATE_IGNORE = 2;
    public static final int PAE_STATE_UNKNOWN = 0;
    public static final int PAE_STATE_INITIALIZE = 1;
    public static final int PAE_STATE_DISCONNECTED = 2;
    public static final int PAE_STATE_CONNECTING = 3;
    public static final int PAE_STATE_AUTHENTICATING = 4;
    public static final int PAE_STATE_AUTHENTICATED = 5;
    public static final int PAE_STATE_ABORTING = 6;
    public static final int PAE_STATE_HELD = 7;
    public static final int PAE_STATE_FORCE_AUTH = 8;
    public static final int PAE_STATE_FORCE_UNAUTH = 9;
    public static final int PAE_STATE_RESTART = 10;
    public static final int BACKEND_STATE_UNKNOWN = 0;
    public static final int BACKEND_STATE_REQUEST = 1;
    public static final int BACKEND_STATE_RESPONSE = 2;
    public static final int BACKEND_STATE_SUCCESS = 3;
    public static final int BACKEND_STATE_FAIL = 4;
    public static final int BACKEND_STATE_TIMEOUT = 5;
    public static final int BACKEND_STATE_IDLE = 6;
    public static final int BACKEND_STATE_INITIALIZE = 7;
    public static final int BACKEND_STATE_IGNORE = 8;
    private static final String[] stateText = new String[]{"UNKNOWN", "UP", "DOWN", "TESTING", "DORMANT", "NOT PRESENT"};
    private static final String[] paeStateText = new String[]{"UNKNOWN", "INITIALIZE", "DISCONNECTED", "CONNECTING", "AUTHENTICATING", "AUTHENTICATED", "ABORTING", "HELD", "FORCE AUTH", "FORCE UNAUTH", "RESTART"};
    private static final String[] backendStateText = new String[]{"UNKNOWN", "REQUEST", "RESPONSE", "SUCCESS", "FAIL", "TIMEOUT", "IDLE", "INITIALIZE", "IGNORE"};
    private static final Map<Integer, String> ifTypeNames = new HashMap<Integer, String>();
    private int ifIndex;
    private int ifType;
    private int mtu;
    private long speed;
    private int chassis;
    private int module;
    private int pic;
    private int port;
    private MacAddress macAddress;
    private List<InetAddressEx> ipAddressList;
    private int requiredPollCount;
    private long peerNodeId;
    private long peerInterfaceId;
    private LinkLayerDiscoveryProtocol peerDiscoveryProtocol;
    private int zoneId;
    private String description;
    protected String ifAlias;
    private int adminState;
    private int operState;
    private int dot1xPaeState;
    private int dot1xBackendState;
    private SnmpObjectId ifTableSuffix;
    private long parentInterfaceId;
    private long[] vlans;
    private InetAddress ospfArea;
    private OSPFInterfaceState ospfState;
    private OSPFInterfaceType ospfType;

    public Interface(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.ifIndex = msg2.getFieldAsInt32(11L);
        this.ifType = msg2.getFieldAsInt32(12L);
        this.mtu = msg2.getFieldAsInt32(493L);
        this.speed = msg2.getFieldAsInt64(512L);
        this.chassis = msg2.getFieldAsInt32(659L);
        this.module = msg2.getFieldAsInt32(367L);
        this.pic = msg2.getFieldAsInt32(660L);
        this.port = msg2.getFieldAsInt32(368L);
        this.macAddress = new MacAddress(msg2.getFieldAsBinary(113L));
        this.requiredPollCount = msg2.getFieldAsInt32(299L);
        this.peerNodeId = msg2.getFieldAsInt64(373L);
        this.peerInterfaceId = msg2.getFieldAsInt64(374L);
        this.peerDiscoveryProtocol = LinkLayerDiscoveryProtocol.getByValue(msg2.getFieldAsInt32(472L));
        this.zoneId = msg2.getFieldAsInt32(147L);
        this.description = msg2.getFieldAsString(27L);
        this.adminState = msg2.getFieldAsInt32(414L);
        this.operState = msg2.getFieldAsInt32(415L);
        this.dot1xPaeState = msg2.getFieldAsInt32(403L);
        this.dot1xBackendState = msg2.getFieldAsInt32(404L);
        this.ifTableSuffix = new SnmpObjectId(msg2.getFieldAsUInt32Array(513L));
        this.parentInterfaceId = msg2.getFieldAsInt64(580L);
        this.vlans = msg2.getFieldAsUInt32Array(622L);
        this.ifAlias = msg2.getFieldAsString(790L);
        this.ospfArea = msg2.getFieldAsInetAddress(796L);
        this.ospfState = OSPFInterfaceState.getByValue(msg2.getFieldAsInt32(798L));
        this.ospfType = OSPFInterfaceType.getByValue(msg2.getFieldAsInt32(797L));
        if (this.vlans != null) {
            Arrays.sort(this.vlans);
        }
        int count2 = msg2.getFieldAsInt32(150L);
        this.ipAddressList = new ArrayList<InetAddressEx>(count2);
        long fieldId = 0x7F000000L;
        for (int i = 0; i < count2; ++i) {
            this.ipAddressList.add(msg2.getFieldAsInetAddressEx(fieldId++));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public String getIfTypeName() {
        return Interface.getIfTypeName(this.ifType);
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getRequiredPollCount() {
        return this.requiredPollCount;
    }

    @Override
    public String getObjectClassName() {
        return "Interface";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public int getChassis() {
        return this.chassis;
    }

    public int getPIC() {
        return this.pic;
    }

    public int getModule() {
        return this.module;
    }

    public int getPort() {
        return this.port;
    }

    public String getPhysicalLocation() {
        return this.isPhysicalPort() ? this.chassis + "/" + this.module + "/" + this.pic + "/" + this.port : "";
    }

    public long getPeerNodeId() {
        return this.peerNodeId;
    }

    public long getPeerInterfaceId() {
        return this.peerInterfaceId;
    }

    @Override
    public int getZoneId() {
        return this.zoneId;
    }

    @Override
    public String getZoneName() {
        Zone zone = this.session.findZone(this.zoneId);
        return zone != null ? zone.getObjectName() : Long.toString(this.zoneId);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIfAlias() {
        return this.ifAlias != null ? this.ifAlias : "";
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDot1xPaeState() {
        return this.dot1xPaeState;
    }

    public String getDot1xPaeStateAsText() {
        try {
            return paeStateText[this.dot1xPaeState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return paeStateText[0];
        }
    }

    public int getDot1xBackendState() {
        return this.dot1xBackendState;
    }

    public String getDot1xBackendStateAsText() {
        try {
            return backendStateText[this.dot1xBackendState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return backendStateText[0];
        }
    }

    public int getAdminState() {
        return this.adminState;
    }

    public String getAdminStateAsText() {
        try {
            return stateText[this.adminState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return stateText[0];
        }
    }

    public int getOperState() {
        return this.operState;
    }

    public String getOperStateAsText() {
        try {
            return stateText[this.operState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return stateText[0];
        }
    }

    public int getExpectedState() {
        return (this.flags & 0x30000000) >> 28;
    }

    public boolean isPhysicalPort() {
        return (this.flags & 2) != 0;
    }

    public boolean isLoopback() {
        return (this.flags & 8) != 0;
    }

    public boolean isOSPF() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isExcludedFromTopology() {
        return (this.flags & 4) != 0;
    }

    public boolean isIncludedInIcmpPoll() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isIcmpStatusPollDisabled() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isSnmpStatusPollDisabled() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isAgentStatusPollDisabled() {
        return (this.flags & 0x200) != 0;
    }

    public LinkLayerDiscoveryProtocol getPeerDiscoveryProtocol() {
        return this.peerDiscoveryProtocol;
    }

    public int getMtu() {
        return this.mtu;
    }

    public long getSpeed() {
        return this.speed;
    }

    public SnmpObjectId getIfTableSuffix() {
        return this.ifTableSuffix;
    }

    public List<InetAddressEx> getIpAddressList() {
        return this.ipAddressList;
    }

    public boolean hasAddress(InetAddressEx addr) {
        return this.hasAddress(addr.getAddress());
    }

    public boolean hasAddress(InetAddress addr) {
        for (InetAddressEx a : this.ipAddressList) {
            if (!a.getAddress().equals(addr)) continue;
            return true;
        }
        return false;
    }

    public InetAddress getFirstUnicastAddress() {
        InetAddressEx a = this.getFirstUnicastAddressEx();
        return a != null ? a.getAddress() : null;
    }

    public InetAddressEx getFirstUnicastAddressEx() {
        for (InetAddressEx a : this.ipAddressList) {
            if (a.getAddress().isAnyLocalAddress() || a.getAddress().isLinkLocalAddress() || a.getAddress().isLoopbackAddress() || a.getAddress().isMulticastAddress()) continue;
            return a;
        }
        return null;
    }

    public String getIpAddressListAsString() {
        StringBuilder sb = new StringBuilder();
        for (InetAddressEx a : this.ipAddressList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(a.toString());
        }
        return sb.toString();
    }

    public static String getIfTypeName(int ifType) {
        return ifTypeNames.get(ifType);
    }

    public long getParentInterfaceId() {
        return this.parentInterfaceId;
    }

    public Interface getParentInterface() {
        return this.session.findObjectById(this.parentInterfaceId, Interface.class);
    }

    public long[] getVlans() {
        return this.vlans != null ? this.vlans : new long[]{};
    }

    public InetAddress getOSPFArea() {
        return this.ospfArea;
    }

    public OSPFInterfaceState getOSPFState() {
        return this.ospfState;
    }

    public OSPFInterfaceType getOSPFType() {
        return this.ospfType;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Interface.addString(strings, this.description);
        Interface.addString(strings, ifTypeNames.get(this.ifType));
        return strings;
    }

    static {
        ifTypeNames.put(1, "other");
        ifTypeNames.put(2, "regular1822");
        ifTypeNames.put(3, "hdh1822");
        ifTypeNames.put(4, "ddnX25");
        ifTypeNames.put(5, "rfc877x25");
        ifTypeNames.put(6, "ethernetCsmacd");
        ifTypeNames.put(7, "iso88023Csmacd");
        ifTypeNames.put(8, "iso88024TokenBus");
        ifTypeNames.put(9, "iso88025TokenRing");
        ifTypeNames.put(10, "iso88026Man");
        ifTypeNames.put(11, "starLan");
        ifTypeNames.put(12, "proteon10Mbit");
        ifTypeNames.put(13, "proteon80Mbit");
        ifTypeNames.put(14, "hyperchannel");
        ifTypeNames.put(15, "fddi");
        ifTypeNames.put(16, "lapb");
        ifTypeNames.put(17, "sdlc");
        ifTypeNames.put(18, "ds1");
        ifTypeNames.put(19, "e1");
        ifTypeNames.put(20, "basicISDN");
        ifTypeNames.put(21, "primaryISDN");
        ifTypeNames.put(22, "propPointToPointSerial");
        ifTypeNames.put(23, "ppp");
        ifTypeNames.put(24, "softwareLoopback");
        ifTypeNames.put(25, "eon");
        ifTypeNames.put(26, "ethernet3Mbit");
        ifTypeNames.put(27, "nsip");
        ifTypeNames.put(28, "slip");
        ifTypeNames.put(29, "ultra");
        ifTypeNames.put(30, "ds3");
        ifTypeNames.put(31, "sip");
        ifTypeNames.put(32, "frameRelay");
        ifTypeNames.put(33, "rs232");
        ifTypeNames.put(34, "para");
        ifTypeNames.put(35, "arcnet");
        ifTypeNames.put(36, "arcnetPlus");
        ifTypeNames.put(37, "atm");
        ifTypeNames.put(38, "miox25");
        ifTypeNames.put(39, "sonet");
        ifTypeNames.put(40, "x25ple");
        ifTypeNames.put(41, "iso88022llc");
        ifTypeNames.put(42, "localTalk");
        ifTypeNames.put(43, "smdsDxi");
        ifTypeNames.put(44, "frameRelayService");
        ifTypeNames.put(45, "v35");
        ifTypeNames.put(46, "hssi");
        ifTypeNames.put(47, "hippi");
        ifTypeNames.put(48, "modem");
        ifTypeNames.put(49, "aal5");
        ifTypeNames.put(50, "sonetPath");
        ifTypeNames.put(51, "sonetVT");
        ifTypeNames.put(52, "smdsIcip");
        ifTypeNames.put(53, "propVirtual");
        ifTypeNames.put(54, "propMultiplexor");
        ifTypeNames.put(55, "ieee80212");
        ifTypeNames.put(56, "fibreChannel");
        ifTypeNames.put(57, "hippiInterface");
        ifTypeNames.put(58, "frameRelayInterconnect");
        ifTypeNames.put(59, "aflane8023");
        ifTypeNames.put(60, "aflane8025");
        ifTypeNames.put(61, "cctEmul");
        ifTypeNames.put(62, "fastEther");
        ifTypeNames.put(63, "isdn");
        ifTypeNames.put(64, "v11");
        ifTypeNames.put(65, "v36");
        ifTypeNames.put(66, "g703at64k");
        ifTypeNames.put(67, "g703at2mb");
        ifTypeNames.put(68, "qllc");
        ifTypeNames.put(69, "fastEtherFX");
        ifTypeNames.put(70, "channel");
        ifTypeNames.put(71, "ieee80211");
        ifTypeNames.put(72, "ibm370parChan");
        ifTypeNames.put(73, "escon");
        ifTypeNames.put(74, "dlsw");
        ifTypeNames.put(75, "isdns");
        ifTypeNames.put(76, "isdnu");
        ifTypeNames.put(77, "lapd");
        ifTypeNames.put(78, "ipSwitch");
        ifTypeNames.put(79, "rsrb");
        ifTypeNames.put(80, "atmLogical");
        ifTypeNames.put(81, "ds0");
        ifTypeNames.put(82, "ds0Bundle");
        ifTypeNames.put(83, "bsc");
        ifTypeNames.put(84, "async");
        ifTypeNames.put(85, "cnr");
        ifTypeNames.put(86, "iso88025Dtr");
        ifTypeNames.put(87, "eplrs");
        ifTypeNames.put(88, "arap");
        ifTypeNames.put(89, "propCnls");
        ifTypeNames.put(90, "hostPad");
        ifTypeNames.put(91, "termPad");
        ifTypeNames.put(92, "frameRelayMPI");
        ifTypeNames.put(93, "x213");
        ifTypeNames.put(94, "adsl");
        ifTypeNames.put(95, "radsl");
        ifTypeNames.put(96, "sdsl");
        ifTypeNames.put(97, "vdsl");
        ifTypeNames.put(98, "iso88025CRFPInt");
        ifTypeNames.put(99, "myrinet");
        ifTypeNames.put(100, "voiceEM");
        ifTypeNames.put(101, "voiceFXO");
        ifTypeNames.put(102, "voiceFXS");
        ifTypeNames.put(103, "voiceEncap");
        ifTypeNames.put(104, "voiceOverIp");
        ifTypeNames.put(105, "atmDxi");
        ifTypeNames.put(106, "atmFuni");
        ifTypeNames.put(107, "atmIma");
        ifTypeNames.put(108, "pppMultilinkBundle");
        ifTypeNames.put(109, "ipOverCdlc");
        ifTypeNames.put(110, "ipOverClaw");
        ifTypeNames.put(111, "stackToStack");
        ifTypeNames.put(112, "virtualIpAddress");
        ifTypeNames.put(113, "mpc");
        ifTypeNames.put(114, "ipOverAtm");
        ifTypeNames.put(115, "iso88025Fiber");
        ifTypeNames.put(116, "tdlc");
        ifTypeNames.put(117, "gigabitEthernet");
        ifTypeNames.put(118, "hdlc");
        ifTypeNames.put(119, "lapf");
        ifTypeNames.put(120, "v37");
        ifTypeNames.put(121, "x25mlp");
        ifTypeNames.put(122, "x25huntGroup");
        ifTypeNames.put(123, "transpHdlc");
        ifTypeNames.put(124, "interleave");
        ifTypeNames.put(125, "fast");
        ifTypeNames.put(126, "ip");
        ifTypeNames.put(127, "docsCableMaclayer");
        ifTypeNames.put(128, "docsCableDownstream");
        ifTypeNames.put(129, "docsCableUpstream");
        ifTypeNames.put(130, "a12MppSwitch");
        ifTypeNames.put(131, "tunnel");
        ifTypeNames.put(132, "coffee");
        ifTypeNames.put(133, "ces");
        ifTypeNames.put(134, "atmSubInterface");
        ifTypeNames.put(135, "l2vlan");
        ifTypeNames.put(136, "l3ipvlan");
        ifTypeNames.put(137, "l3ipxvlan");
        ifTypeNames.put(138, "digitalPowerline");
        ifTypeNames.put(139, "mediaMailOverIp");
        ifTypeNames.put(140, "dtm");
        ifTypeNames.put(141, "dcn");
        ifTypeNames.put(142, "ipForward");
        ifTypeNames.put(143, "msdsl");
        ifTypeNames.put(144, "ieee1394");
        ifTypeNames.put(145, "if-gsn");
        ifTypeNames.put(146, "dvbRccMacLayer");
        ifTypeNames.put(147, "dvbRccDownstream");
        ifTypeNames.put(148, "dvbRccUpstream");
        ifTypeNames.put(149, "atmVirtual");
        ifTypeNames.put(150, "mplsTunnel");
        ifTypeNames.put(151, "srp");
        ifTypeNames.put(152, "voiceOverAtm");
        ifTypeNames.put(153, "voiceOverFrameRelay");
        ifTypeNames.put(154, "idsl");
        ifTypeNames.put(155, "compositeLink");
        ifTypeNames.put(156, "ss7SigLink");
        ifTypeNames.put(157, "propWirelessP2P");
        ifTypeNames.put(158, "frForward");
        ifTypeNames.put(159, "rfc1483");
        ifTypeNames.put(160, "usb");
        ifTypeNames.put(161, "ieee8023adLag");
        ifTypeNames.put(162, "bgppolicyaccounting");
        ifTypeNames.put(163, "frf16MfrBundle");
        ifTypeNames.put(164, "h323Gatekeeper");
        ifTypeNames.put(165, "h323Proxy");
        ifTypeNames.put(166, "mpls");
        ifTypeNames.put(167, "mfSigLink");
        ifTypeNames.put(168, "hdsl2");
        ifTypeNames.put(169, "shdsl");
        ifTypeNames.put(170, "ds1FDL");
        ifTypeNames.put(171, "pos");
        ifTypeNames.put(172, "dvbAsiIn");
        ifTypeNames.put(173, "dvbAsiOut");
        ifTypeNames.put(174, "plc");
        ifTypeNames.put(175, "nfas");
        ifTypeNames.put(176, "tr008");
        ifTypeNames.put(177, "gr303RDT");
        ifTypeNames.put(178, "gr303IDT");
        ifTypeNames.put(179, "isup");
        ifTypeNames.put(180, "propDocsWirelessMaclayer");
        ifTypeNames.put(181, "propDocsWirelessDownstream");
        ifTypeNames.put(182, "propDocsWirelessUpstream");
        ifTypeNames.put(183, "hiperlan2");
        ifTypeNames.put(184, "propBWAp2Mp");
        ifTypeNames.put(185, "sonetOverheadChannel");
        ifTypeNames.put(186, "digitalWrapperOverheadChannel");
        ifTypeNames.put(187, "aal2");
        ifTypeNames.put(188, "radioMAC");
        ifTypeNames.put(189, "atmRadio");
        ifTypeNames.put(190, "imt");
        ifTypeNames.put(191, "mvl");
        ifTypeNames.put(192, "reachDSL");
        ifTypeNames.put(193, "frDlciEndPt");
        ifTypeNames.put(194, "atmVciEndPt");
        ifTypeNames.put(195, "opticalChannel");
        ifTypeNames.put(196, "opticalTransport");
        ifTypeNames.put(197, "propAtm");
        ifTypeNames.put(198, "voiceOverCable");
        ifTypeNames.put(199, "infiniband");
        ifTypeNames.put(200, "teLink");
        ifTypeNames.put(201, "q2931");
        ifTypeNames.put(202, "virtualTg");
        ifTypeNames.put(203, "sipTg");
        ifTypeNames.put(204, "sipSig");
        ifTypeNames.put(205, "docsCableUpstreamChannel");
        ifTypeNames.put(206, "econet");
        ifTypeNames.put(207, "pon155");
        ifTypeNames.put(208, "pon622");
        ifTypeNames.put(209, "bridge");
        ifTypeNames.put(210, "linegroup");
        ifTypeNames.put(211, "voiceEMFGD");
        ifTypeNames.put(212, "voiceFGDEANA");
        ifTypeNames.put(213, "voiceDID");
        ifTypeNames.put(214, "mpegTransport");
        ifTypeNames.put(215, "sixToFour");
        ifTypeNames.put(216, "gtp");
        ifTypeNames.put(217, "pdnEtherLoop1");
        ifTypeNames.put(218, "pdnEtherLoop2");
        ifTypeNames.put(219, "opticalChannelGroup");
        ifTypeNames.put(220, "homepna");
        ifTypeNames.put(221, "gfp");
        ifTypeNames.put(222, "ciscoISLvlan");
        ifTypeNames.put(223, "actelisMetaLOOP");
        ifTypeNames.put(224, "fcipLink");
        ifTypeNames.put(225, "rpr");
        ifTypeNames.put(226, "qam");
        ifTypeNames.put(227, "lmp");
        ifTypeNames.put(228, "cblVectaStar");
        ifTypeNames.put(229, "docsCableMCmtsDownstream");
        ifTypeNames.put(230, "adsl2");
        ifTypeNames.put(231, "macSecControlledIF");
        ifTypeNames.put(232, "macSecUncontrolledIF");
        ifTypeNames.put(233, "aviciOpticalEther");
        ifTypeNames.put(234, "atmbond");
        ifTypeNames.put(235, "voiceFGDOS");
        ifTypeNames.put(236, "mocaVersion1");
        ifTypeNames.put(237, "ieee80216WMAN");
        ifTypeNames.put(238, "adsl2plus");
        ifTypeNames.put(239, "dvbRcsMacLayer");
        ifTypeNames.put(240, "dvbTdm");
        ifTypeNames.put(241, "dvbRcsTdma");
        ifTypeNames.put(242, "x86Laps");
        ifTypeNames.put(243, "wwanPP");
        ifTypeNames.put(244, "wwanPP2");
        ifTypeNames.put(245, "voiceEBS");
        ifTypeNames.put(246, "ifPwType");
        ifTypeNames.put(247, "ilan");
        ifTypeNames.put(248, "pip");
        ifTypeNames.put(249, "aluELP");
        ifTypeNames.put(250, "gpon");
        ifTypeNames.put(251, "vdsl2");
        ifTypeNames.put(252, "capwapDot11Profile");
        ifTypeNames.put(253, "capwapDot11Bss");
        ifTypeNames.put(254, "capwapWtpVirtualRadio");
        ifTypeNames.put(255, "bits");
        ifTypeNames.put(256, "docsCableUpstreamRfPort");
        ifTypeNames.put(257, "cableDownstreamRfPort");
        ifTypeNames.put(258, "vmwareVirtualNic");
        ifTypeNames.put(259, "ieee802154");
        ifTypeNames.put(260, "otnOdu");
        ifTypeNames.put(261, "otnOtu");
        ifTypeNames.put(262, "ifVfiType");
        ifTypeNames.put(263, "g9981");
        ifTypeNames.put(264, "g9982");
        ifTypeNames.put(265, "g9983");
        ifTypeNames.put(266, "aluEpon");
        ifTypeNames.put(267, "aluEponOnu");
        ifTypeNames.put(268, "aluEponPhysicalUni");
        ifTypeNames.put(269, "aluEponLogicalLink");
        ifTypeNames.put(270, "aluGponOnu");
        ifTypeNames.put(271, "aluGponPhysicalUni");
        ifTypeNames.put(272, "vmwareNicTeam");
    }
}

