/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Date;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.DataCollectionTarget;

public class MobileDevice
extends DataCollectionTarget {
    private String deviceId;
    private String commProtocol;
    private String vendor;
    private String model;
    private String serialNumber;
    private String osName;
    private String osVersion;
    private String userId;
    private short batteryLevel;
    private float speed;
    private short direction;
    private int altitude;
    private Date lastReportTime;

    public MobileDevice(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.deviceId = msg2.getFieldAsString(433L);
        this.commProtocol = msg2.getFieldAsString(583L);
        this.vendor = msg2.getFieldAsString(428L);
        this.model = msg2.getFieldAsString(429L);
        this.serialNumber = msg2.getFieldAsString(432L);
        this.osName = msg2.getFieldAsString(430L);
        this.osVersion = msg2.getFieldAsString(431L);
        this.userId = msg2.getFieldAsString(35L);
        this.batteryLevel = msg2.getFieldAsInt16(427L);
        this.speed = msg2.getFieldAsDouble(512L).floatValue();
        this.direction = msg2.getFieldAsInt16(718L);
        this.altitude = msg2.getFieldAsInt32(719L);
        this.lastReportTime = msg2.getFieldAsDate(241L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public final String getDeviceId() {
        return this.deviceId;
    }

    public String getCommProtocol() {
        return this.commProtocol;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final String getModel() {
        return this.model;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    public final String getOsName() {
        return this.osName;
    }

    public final String getOsVersion() {
        return this.osVersion;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final short getBatteryLevel() {
        return this.batteryLevel;
    }

    public float getSpeed() {
        return this.speed;
    }

    public short getDirection() {
        return this.direction;
    }

    public int getAltitude() {
        return this.altitude;
    }

    @Override
    public String getObjectClassName() {
        return "MobileDevice";
    }

    public final Date getLastReportTime() {
        return this.lastReportTime;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        MobileDevice.addString(strings, this.deviceId);
        MobileDevice.addString(strings, this.model);
        MobileDevice.addString(strings, this.osName);
        MobileDevice.addString(strings, this.osVersion);
        MobileDevice.addString(strings, this.serialNumber);
        MobileDevice.addString(strings, this.userId);
        MobileDevice.addString(strings, this.vendor);
        return strings;
    }
}

