/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.HashSet;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.NodeChild;

public class NetworkService
extends GenericObject
implements NodeChild {
    public static final int CUSTOM = 0;
    public static final int SSH = 1;
    public static final int POP3 = 2;
    public static final int SMTP = 3;
    public static final int FTP = 4;
    public static final int HTTP = 5;
    public static final int HTTPS = 6;
    public static final int TELNET = 7;
    int serviceType;
    InetAddressEx ipAddress;
    int protocol;
    int port;
    String request;
    String response;
    long pollerNode;
    int pollCount;

    public NetworkService(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.serviceType = msg2.getFieldAsInt32(130L);
        this.ipAddress = msg2.getFieldAsInetAddressEx(8L);
        this.protocol = msg2.getFieldAsInt32(131L);
        this.port = msg2.getFieldAsInt32(132L);
        this.request = msg2.getFieldAsString(133L);
        this.response = msg2.getFieldAsString(134L);
        this.pollerNode = msg2.getFieldAsInt64(135L);
        this.pollCount = msg2.getFieldAsInt32(299L);
    }

    @Override
    public String getObjectClassName() {
        return "NetworkService";
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public long getPollerNode() {
        return this.pollerNode;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }
}

