/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects.configs;

import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.PassiveRackElementType;
import org.netxms.client.constants.RackOrientation;

public class PassiveRackElement {
    public long id;
    public String name;
    public PassiveRackElementType type;
    public int position;
    public int height;
    public RackOrientation orientation;
    public int portCount;
    public UUID frontImage;
    public UUID rearImage;

    public PassiveRackElement() {
        this.id = 0L;
        this.name = "";
        this.type = PassiveRackElementType.FILLER_PANEL;
        this.position = 0;
        this.height = 1;
        this.orientation = RackOrientation.FILL;
        this.portCount = 0;
        this.frontImage = NXCommon.EMPTY_GUID;
        this.rearImage = NXCommon.EMPTY_GUID;
    }

    public PassiveRackElement(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt32(baseId++);
        this.name = msg2.getFieldAsString(baseId++);
        this.type = PassiveRackElementType.getByValue(msg2.getFieldAsInt32(baseId++));
        this.position = msg2.getFieldAsInt32(baseId++);
        this.height = msg2.getFieldAsInt32(baseId++);
        this.orientation = RackOrientation.getByValue(msg2.getFieldAsInt32(baseId++));
        this.portCount = msg2.getFieldAsInt32(baseId++);
        this.frontImage = msg2.getFieldAsUUID(baseId++);
        this.rearImage = msg2.getFieldAsUUID(baseId++);
    }

    public PassiveRackElement(PassiveRackElement src) {
        this.id = src.id;
        this.name = src.name;
        this.type = src.type;
        this.position = src.position;
        this.height = src.height;
        this.orientation = src.orientation;
        this.portCount = src.portCount;
        this.frontImage = src.frontImage;
        this.rearImage = src.rearImage;
    }

    public void fillMessage(NXCPMessage msg2, long baseId) {
        msg2.setFieldInt32(baseId++, (int)this.id);
        msg2.setField(baseId++, this.name);
        msg2.setFieldInt16(baseId++, this.type.getValue());
        msg2.setFieldInt16(baseId++, this.position);
        msg2.setFieldInt16(baseId++, this.height);
        msg2.setFieldInt16(baseId++, this.orientation.getValue());
        msg2.setFieldInt16(baseId++, this.portCount);
        msg2.setField(baseId++, this.frontImage);
        msg2.setField(baseId++, this.rearImage);
    }

    public void setType(PassiveRackElementType type) {
        this.type = type;
    }

    public PassiveRackElementType getType() {
        return this.type;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setOrientation(RackOrientation orientation) {
        this.orientation = orientation;
    }

    public RackOrientation getOrientation() {
        return this.orientation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPortCount() {
        return this.portCount;
    }

    public void setPortCount(int portCount) {
        this.portCount = portCount;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public UUID getFrontImage() {
        return this.frontImage;
    }

    public void setFrontImage(UUID frontImage) {
        this.frontImage = frontImage;
    }

    public UUID getRearImage() {
        return this.rearImage;
    }

    public void setRearImage(UUID rearImage) {
        this.rearImage = rearImage;
    }

    public String toString() {
        return this.orientation.toString() + " " + this.position + " (" + this.name + ")";
    }
}

