/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.InputField;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolTableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectToolDetails
extends ObjectTool {
    private static final Logger logger = LoggerFactory.getLogger(ObjectToolDetails.class);
    private boolean modified = false;
    private List<Long> accessList;
    private List<ObjectToolTableColumn> columns;

    public ObjectToolDetails(long toolId, int type, String name) {
        this.id = toolId;
        this.type = type;
        this.name = name;
        this.data = "";
        this.flags = 0;
        this.description = "";
        this.filter = new ObjectMenuFilter();
        this.confirmationText = "";
        this.accessList = new ArrayList<Long>(0);
        this.columns = new ArrayList<ObjectToolTableColumn>(0);
        this.commandName = "";
        this.commandShortName = "";
        this.imageData = null;
        this.remotePort = 0;
        this.inputFields = new HashMap();
        this.createDisplayName();
    }

    public ObjectToolDetails(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt64(165L);
        this.name = msg2.getFieldAsString(20L);
        this.type = msg2.getFieldAsInt32(196L);
        this.data = msg2.getFieldAsString(197L);
        this.flags = msg2.getFieldAsInt32(13L);
        this.description = msg2.getFieldAsString(27L);
        String filterData = msg2.getFieldAsString(199L);
        this.confirmationText = msg2.getFieldAsString(250L);
        this.commandName = msg2.getFieldAsString(474L);
        this.commandShortName = msg2.getFieldAsString(475L);
        this.remotePort = msg2.getFieldAsInt32(268L);
        this.imageData = msg2.getFieldAsBinary(369L);
        try {
            this.filter = ObjectMenuFilter.createFromXml(filterData);
        }
        catch (Exception e) {
            this.filter = new ObjectMenuFilter();
            logger.debug("Cannot create ObjectMenuFilter object from XML document", e);
        }
        Long[] acl = msg2.getFieldAsUInt32ArrayEx(198L);
        this.accessList = acl != null ? new ArrayList<Long>(Arrays.asList(acl)) : new ArrayList(0);
        int count2 = msg2.getFieldAsInt32(166L);
        this.columns = new ArrayList<ObjectToolTableColumn>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            this.columns.add(new ObjectToolTableColumn(msg2, varId));
            varId += 4L;
        }
        count2 = msg2.getFieldAsInt32(507L);
        this.inputFields = new HashMap(count2);
        long fieldId = 0x70000000L;
        for (int i = 0; i < count2; ++i) {
            InputField f = new InputField(msg2, fieldId);
            this.inputFields.put(f.getName(), f);
            fieldId += 10L;
        }
        if (this.type == 1 || this.type == 7 || this.type == 5 || this.type == 6 || this.type == 8 || this.type == 4) {
            this.validateInputFields();
        }
        this.createDisplayName();
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(165L, (int)this.id);
        msg2.setField(20L, this.name);
        msg2.setField(27L, this.description);
        msg2.setField(199L, this.filter.createXml());
        msg2.setField(250L, this.confirmationText);
        msg2.setField(197L, this.data);
        msg2.setFieldInt16(196L, this.type);
        msg2.setFieldInt32(13L, this.flags);
        msg2.setField(474L, this.commandName);
        msg2.setField(475L, this.commandShortName);
        msg2.setFieldInt32(268L, this.remotePort);
        if (this.imageData != null) {
            msg2.setField(369L, this.imageData);
        }
        msg2.setFieldInt32(32L, this.accessList.size());
        msg2.setField(198L, this.accessList.toArray(new Long[this.accessList.size()]));
        msg2.setFieldInt16(166L, this.columns.size());
        long fieldId = 0x10000000L;
        for (int i = 0; i < this.columns.size(); ++i) {
            ObjectToolTableColumn c = this.columns.get(i);
            msg2.setField(fieldId++, c.getName());
            msg2.setField(fieldId++, c.getSnmpOid());
            msg2.setFieldInt16(fieldId++, c.getFormat());
            msg2.setFieldInt16(fieldId++, c.getSubstringIndex());
        }
        msg2.setFieldInt16(507L, this.inputFields.size());
        fieldId = 0x70000000L;
        for (InputField f : this.inputFields.values()) {
            f.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
    }

    public List<Long> getAccessList() {
        return this.accessList;
    }

    public List<ObjectToolTableColumn> getColumns() {
        return this.columns;
    }

    public void addInputField(InputField f) {
        this.inputFields.put(f.getName(), f);
        this.modified = true;
    }

    public void setInputFields(Collection<InputField> fields) {
        this.inputFields.clear();
        for (InputField f : fields) {
            this.inputFields.put(f.getName(), f);
        }
        this.modified = true;
    }

    public void setId(long id) {
        this.id = id;
        this.modified = true;
    }

    public void setName(String name) {
        this.name = name;
        this.createDisplayName();
        this.modified = true;
    }

    public void setType(int type) {
        this.type = type;
        this.modified = true;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.modified = true;
    }

    public void setDescription(String description) {
        this.description = description;
        this.modified = true;
    }

    public void setData(String data) {
        this.data = data;
        this.modified = true;
    }

    public void setConfirmationText(String confirmationText) {
        this.confirmationText = confirmationText;
        this.modified = true;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setAccessList(List<Long> accessList) {
        this.accessList = accessList;
        this.modified = true;
    }

    public void setColumns(List<ObjectToolTableColumn> columns) {
        this.columns = columns;
        this.modified = true;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
        this.modified = true;
    }

    public void setCommandShortName(String commandShortName) {
        this.commandShortName = commandShortName;
        this.modified = true;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
        this.modified = true;
    }

    public void setFilter(String filterText, int filterType) {
        this.filter.setFilter(filterText, filterType);
        this.modified = true;
    }

    public void setFilterFlags(int flags) {
        this.filter.flags = flags;
        this.modified = true;
    }
}

