/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.server.RemoteFile;

public class ServerFile
implements RemoteFile {
    private String name;
    private long size;
    private Date modificationTime;
    private String extension;

    public ServerFile(NXCPMessage msg2, long baseId) {
        this.name = msg2.getFieldAsString(baseId);
        this.size = msg2.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg2.getFieldAsDate(baseId + 2L);
        this.setExtension();
    }

    private void setExtension() {
        if (this.name.startsWith(".")) {
            this.extension = " ";
            return;
        }
        String[] parts = this.name.split("\\.");
        this.extension = parts.length > 1 ? parts[parts.length - 1] : " ";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtension();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Date getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }
}

