/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;

public class SnmpTrapParameterMapping {
    public static final int BY_OBJECT_ID = 0;
    public static final int BY_POSITION = 1;
    public static final int FORCE_TEXT = 1;
    private int type;
    private int flags;
    private SnmpObjectId objectId;
    private int position;
    private String description;

    public SnmpTrapParameterMapping(int position) {
        this.type = 1;
        this.position = position;
    }

    public SnmpTrapParameterMapping(SnmpObjectId oid) {
        this.type = 0;
        this.objectId = oid;
    }

    public SnmpTrapParameterMapping(NXCPMessage msg2, long baseId) {
        this.type = msg2.getFieldAsInt32(baseId);
        if (this.type == 1) {
            this.position = (int)msg2.getFieldAsInt64(baseId + 1L);
        } else {
            this.objectId = new SnmpObjectId(msg2.getFieldAsUInt32Array(baseId + 1L));
        }
        this.description = msg2.getFieldAsString(baseId + 2L);
        this.flags = msg2.getFieldAsInt32(baseId + 3L);
    }

    public void fillMessage(NXCPMessage msg2, long baseId) {
        msg2.setFieldInt32(baseId, this.flags);
        msg2.setField(baseId + 1L, this.description);
        msg2.setFieldInt32(baseId + 2L, this.type);
        if (this.type == 1) {
            msg2.setFieldInt32(baseId + 3L, this.position);
        } else {
            this.objectId.setNXCPVariable(msg2, baseId + 3L);
            msg2.setFieldInt32(baseId + 4L, this.objectId.getLength());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public SnmpObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(SnmpObjectId objectId) {
        this.objectId = objectId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }
}

