/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.topology.Port;

public class VlanInfo {
    private int vlanId;
    private String name;
    private Port[] ports;
    private long nextFieldId;

    public VlanInfo(NXCPMessage msg2, long baseId) {
        this.vlanId = msg2.getFieldAsInt32(baseId);
        this.name = msg2.getFieldAsString(baseId + 1L);
        int count2 = msg2.getFieldAsInt32(baseId + 2L);
        this.ports = new Port[count2];
        long fieldId = baseId + 3L;
        for (int i = 0; i < count2; ++i) {
            int ifIndex = msg2.getFieldAsInt32(fieldId++);
            long objectId = msg2.getFieldAsInt64(fieldId++);
            int chassis = msg2.getFieldAsInt32(fieldId++);
            int module = msg2.getFieldAsInt32(fieldId++);
            int pic = msg2.getFieldAsInt32(fieldId++);
            int port = msg2.getFieldAsInt32(fieldId++);
            this.ports[i] = new Port(objectId, ifIndex, chassis, module, pic, port);
        }
        this.nextFieldId = fieldId;
    }

    public long getNextFieldId() {
        return this.nextFieldId;
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public String getName() {
        return this.name;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public boolean containsPort(int chassis, int module, int pic, int port) {
        for (Port p : this.ports) {
            if (p.getChassis() != chassis || p.getModule() != module || p.getPIC() != pic || p.getPort() != port) continue;
            return true;
        }
        return false;
    }
}

