/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.List;
import java.util.Map;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.websvc.ServerOutputListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectToolExecutor
extends Thread {
    private Logger log = LoggerFactory.getLogger(ObjectToolExecutor.class);
    private ObjectToolDetails details;
    private long objectId;
    private Map<String, String> inputFields;
    private List<String> maskedFields;
    private ServerOutputListener listener;
    private NXCSession session;
    private boolean generateOutput;

    public ObjectToolExecutor(ObjectToolDetails details, long objectId, Map<String, String> inputFields, List<String> maskedFields, ServerOutputListener listener, NXCSession session) {
        this.details = details;
        this.objectId = objectId;
        this.inputFields = inputFields;
        this.maskedFields = maskedFields;
        this.listener = listener;
        this.session = session;
        this.generateOutput = (details.getFlags() & 2) != 0;
        this.setDaemon(true);
        this.start();
    }

    public ObjectToolExecutor(ObjectToolDetails details, long objectId, Map<String, String> inputFields, List<String> maskedFields, NXCSession session) {
        this.details = details;
        this.objectId = objectId;
        this.inputFields = inputFields;
        this.maskedFields = maskedFields;
        this.listener = null;
        this.session = session;
        this.generateOutput = (details.getFlags() & 2) != 0;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        block7: {
            try {
                switch (this.details.getToolType()) {
                    case 1: {
                        this.session.executeActionWithExpansion(this.objectId, 0L, this.details.getData(), this.generateOutput, this.inputFields, this.maskedFields, (TextOutputListener)this.listener, null);
                        break;
                    }
                    case 6: {
                        this.session.executeServerCommand(this.objectId, this.details.getData(), this.inputFields, this.maskedFields, this.generateOutput, (TextOutputListener)this.listener, null);
                    }
                }
                if (this.generateOutput && this.listener != null) {
                    this.listener.onSuccess();
                }
            }
            catch (Exception e) {
                this.log.error("Object tool execution error", (Throwable)e);
                if (!this.generateOutput || this.listener == null) break block7;
                this.listener.onFailure(e);
            }
        }
    }
}

