/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONException;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.websvc.handlers.AbstractHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrafanaAlarms
extends AbstractHandler {
    private static final String[] STATES = new String[]{"Outstanding", "Acknowledged", "Resolved", "Terminated"};

    public Object getCollection(Map<String, String> query) throws Exception {
        if (!this.getSession().areObjectsSynchronized()) {
            this.getSession().syncObjects();
        }
        if (!this.getSession().isUserDatabaseSynchronized()) {
            this.getSession().syncUserDatabase();
        }
        if (query.isEmpty()) {
            HashSet<Integer> classFilter = new HashSet<Integer>(5);
            classFilter.add(2);
            classFilter.add(31);
            classFilter.add(32);
            classFilter.add(14);
            classFilter.add(37);
            AbstractObject[] objects = this.getSession().getTopLevelObjects(classFilter);
            HashMap<Long, String> result = new HashMap<Long, String>();
            for (AbstractObject o : objects) {
                result.put(o.getObjectId(), o.getObjectName());
            }
            return result;
        }
        JsonObject root = new JsonObject();
        JsonArray columns = new JsonArray();
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Severity", (boolean)true, (boolean)true));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"State", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Source", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Message", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Count", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Helpdesk ID", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Ack/Resolved By", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Created", (boolean)true, (boolean)false));
        columns.add((JsonElement)GrafanaAlarms.createColumn((String)"Last Change", (boolean)true, (boolean)false));
        root.add("columns", (JsonElement)columns);
        JsonArray rows = new JsonArray();
        JsonArray r = new JsonArray();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        AbstractObject object = null;
        AbstractUserObject user = null;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(query.get("targets"));
        if (!element.isJsonArray()) {
            return new JsonArray();
        }
        JsonArray targets = element.getAsJsonArray();
        long sourceId = 0L;
        HashMap alarms = this.getSession().getAlarms();
        for (JsonElement e : targets) {
            for (Alarm a : alarms.values()) {
                JsonObject alarmSource;
                if (e.getAsJsonObject().has("alarmSource") && (alarmSource = e.getAsJsonObject().getAsJsonObject("alarmSource")).size() > 0) {
                    sourceId = Long.parseLong(alarmSource.get("id").getAsString());
                }
                if (sourceId != 0L && a.getSourceObjectId() != sourceId) continue;
                r.add(a.getCurrentSeverity().name());
                r.add(STATES[a.getState()]);
                object = this.getSession().findObjectById(a.getSourceObjectId());
                if (object == null) {
                    r.add((Number)a.getSourceObjectId());
                } else {
                    r.add(object.getObjectName());
                }
                r.add(a.getMessage());
                r.add((Number)a.getRepeatCount());
                r.add(a.getHelpdeskReference());
                user = this.getSession().findUserDBObjectById((long)a.getAcknowledgedByUser(), null);
                if (user == null) {
                    r.add("");
                } else {
                    r.add(user.getName());
                }
                r.add(df.format(a.getCreationTime()));
                r.add(df.format(a.getLastChangeTime()));
                rows.add((JsonElement)r);
                r = new JsonArray();
            }
        }
        root.add("rows", (JsonElement)rows);
        root.addProperty("type", "table");
        JsonArray wrapper = new JsonArray();
        wrapper.add((JsonElement)root);
        return wrapper;
    }

    private static JsonObject createColumn(String name, boolean sort, boolean desc) throws JSONException {
        JsonObject column = new JsonObject();
        column.addProperty("text", name);
        column.addProperty("sort", Boolean.valueOf(sort));
        column.addProperty("sort", Boolean.valueOf(desc));
        return column;
    }
}

