/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.LogParserEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFile;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserType;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserFileEditor
extends DashboardComposite {
    private LogParserFile file;
    private LogParserEditor editor;
    private Combo comboFileEncoding;
    private LabeledText labelFileName;
    private Button checkPreallocated;
    private Button checkSnapshot;
    private Button checkKeepOpen;
    private Button checkIgnoreModificationTime;
    private Button checkRescan;

    public LogParserFileEditor(Composite parent, LogParserFile file, final LogParserEditor editor) {
        super(parent, 2048);
        this.file = file;
        this.editor = editor;
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)layout);
        this.labelFileName = new LabeledText((Composite)this, 0);
        this.labelFileName.setLabel("File path");
        this.labelFileName.setBackground(this.getBackground());
        this.labelFileName.setText(file != null ? file.getFile() : "");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.labelFileName.setLayoutData((Object)gd);
        this.labelFileName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                editor.fireModifyListeners();
                editor.updateRules();
            }
        });
        String[] items = new String[]{"AUTO", "ACP", "UTF-8", "UCS-2", "UCS-2LE", "UCS-2BE", "UCS-4", "UCS-4LE", "UCS-4BE"};
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 4;
        this.comboFileEncoding = WidgetHelper.createLabeledCombo((Composite)this, (int)2056, (String)"File encoding", (Object)gd);
        this.comboFileEncoding.setItems(items);
        this.comboFileEncoding.select(file != null && file.getEncoding() != null ? Arrays.asList(items).indexOf(file.getEncoding()) : 0);
        this.comboFileEncoding.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                editor.fireModifyListeners();
            }
        });
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        Composite checkboxBar = new Composite((Composite)this, 0);
        checkboxBar.setLayout((Layout)new RowLayout(256));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 16384;
        checkboxBar.setLayoutData((Object)gd);
        this.checkPreallocated = new Button(checkboxBar, 32);
        this.checkPreallocated.setBackground(this.getBackground());
        this.checkPreallocated.setText("&Preallocated");
        this.checkPreallocated.setSelection(file.getPreallocated());
        this.checkPreallocated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
        this.checkSnapshot = new Button(checkboxBar, 32);
        this.checkSnapshot.setBackground(this.getBackground());
        this.checkSnapshot.setText("Use &snapshot");
        this.checkSnapshot.setSelection(file.getSnapshot());
        this.checkSnapshot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
        this.checkKeepOpen = new Button(checkboxBar, 32);
        this.checkKeepOpen.setBackground(this.getBackground());
        this.checkKeepOpen.setText("&Keep open");
        this.checkKeepOpen.setSelection(file.getKeepOpen());
        this.checkKeepOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
        this.checkIgnoreModificationTime = new Button(checkboxBar, 32);
        this.checkIgnoreModificationTime.setBackground(this.getBackground());
        this.checkIgnoreModificationTime.setText("Ignore &modification time");
        this.checkIgnoreModificationTime.setSelection(file.getIgnoreModificationTime());
        this.checkIgnoreModificationTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
        this.checkRescan = new Button(checkboxBar, 32);
        this.checkRescan.setBackground(this.getBackground());
        this.checkRescan.setText("&Rescan");
        this.checkRescan.setSelection(file.getRescan());
        this.checkRescan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_DeleteRule);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserFileEditor.this.editor.deleteFile(LogParserFileEditor.this.file);
            }
        });
    }

    public void save() {
        this.file.setFile(this.labelFileName.getText().trim());
        this.file.setEncoding(this.comboFileEncoding.getSelectionIndex() == 0 ? null : this.comboFileEncoding.getText());
        this.file.setPreallocated(this.checkPreallocated.getSelection());
        this.file.setSnapshot(this.checkSnapshot.getSelection());
        this.file.setKeepOpen(this.checkKeepOpen.getSelection());
        this.file.setIgnoreModificationTime(this.checkIgnoreModificationTime.getSelection());
        this.file.setRescan(this.checkRescan.getSelection());
    }

    public LogParserType getParserType() {
        return this.editor.getParserType();
    }

    public String getFile() {
        return this.labelFileName.getText();
    }
}

