/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;

public class SSHCommandResults
extends AbstractCommandResults {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.SSHCommandResults";
    private Action actionRestart;
    private String executionString;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                SSHCommandResults.this.executeSshCommand(SSHCommandResults.this.executionString);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeSshCommand(final String executionString) {
        this.actionRestart.setEnabled(false);
        this.createOutputStream();
        this.executionString = executionString;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, this.session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, SSHCommandResults.this.session.getObjectName(SSHCommandResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    SSHCommandResults.this.session.executeSshCommand(SSHCommandResults.this.nodeId, executionString, true, SSHCommandResults.this.getOutputListener(), null);
                    Messages.get();
                    SSHCommandResults.this.writeToOutputStream(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    SSHCommandResults.this.closeOutputStream();
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SSHCommandResults.this.actionRestart.setEnabled(true);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

