/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledControl;

public class PasswordInputField
extends LabeledControl {
    private Composite composite;
    private Text text;
    private Button buttonShow;
    private Button buttonCopyToClipboard;
    private boolean enabled = true;

    public PasswordInputField(Composite parent, int style, boolean showCopyOption) {
        super(parent, style, 0x400804, -1, showCopyOption);
    }

    public PasswordInputField(Composite parent, int style) {
        super(parent, style, 0x400804);
    }

    @Override
    protected Control createControl(int controlStyle, Object parameters) {
        int heightHint;
        boolean showCopyOption = parameters != null ? (Boolean)parameters : false;
        this.composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = showCopyOption ? 3 : 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        this.composite.setLayout((Layout)layout);
        this.text = new Text(this.composite, controlStyle);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonShow = new Button(this.composite, 8);
        this.buttonShow.setImage(SharedIcons.IMG_SHOW);
        this.buttonShow.setToolTipText("Show");
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.heightHint = heightHint = this.text.computeSize((int)-1, (int)-1).y;
        this.buttonShow.setLayoutData((Object)gd);
        this.buttonShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordInputField.this.togglePasswordVisibility();
            }
        });
        if (showCopyOption) {
            this.buttonCopyToClipboard = new Button(this.composite, 8);
            this.buttonCopyToClipboard.setImage(SharedIcons.IMG_COPY_TO_CLIPBOARD);
            this.buttonCopyToClipboard.setToolTipText("Copy to clipboard");
            gd = new GridData(0x1000000, 0x1000000, false, false);
            gd.heightHint = heightHint;
            this.buttonCopyToClipboard.setLayoutData((Object)gd);
            this.buttonCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WidgetHelper.copyToClipboard(PasswordInputField.this.text.getText());
                }
            });
        }
        return this.composite;
    }

    @Override
    public void setText(String newText) {
        this.text.setText(newText != null ? newText : "");
    }

    @Override
    public String getText() {
        return this.text.getText();
    }

    private void togglePasswordVisibility() {
        int style = this.text.getStyle();
        String content = this.text.getText();
        this.text.dispose();
        if ((style & 0x400000) != 0) {
            this.text = new Text(this.composite, style & 0xFFBFFFFF);
            this.buttonShow.setImage(SharedIcons.IMG_HIDE);
            this.buttonShow.setToolTipText("Hide");
        } else {
            this.text = new Text(this.composite, style | 0x400000);
            this.buttonShow.setImage(SharedIcons.IMG_SHOW);
            this.buttonShow.setToolTipText("Show");
        }
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.moveAbove(null);
        this.text.setText(content);
        this.text.setEnabled(this.enabled);
        this.composite.layout(true, true);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public boolean isEditable() {
        return this.text.getEditable();
    }

    public void setInputControlsEnabled(boolean enabled) {
        this.enabled = enabled;
        this.text.setEnabled(enabled);
        this.buttonShow.setEnabled(enabled);
    }
}

