/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectTreeViewer
extends TreeViewer {
    private NXCSession session = ConsoleSharedData.getSession();
    private boolean objectsFullySync;

    public ObjectTreeViewer(Composite parent, int style, boolean objectsFullySync) {
        super(parent, style);
        this.objectsFullySync = objectsFullySync;
        this.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return element instanceof AbstractObject ? (int)((AbstractObject)element).getObjectId() : element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof AbstractObject && b instanceof AbstractObject) {
                    return ((AbstractObject)a).getObjectId() == ((AbstractObject)b).getObjectId();
                }
                return a.equals(b);
            }
        });
    }

    public ViewerRow getTreeViewerRow(TreeItem item) {
        return this.getViewerRowFromItem((Widget)item);
    }

    public void toggleItemExpandState(TreeItem item) {
        if (item.getExpanded()) {
            item.setExpanded(false);
        } else {
            this.checkAndSyncChildren((AbstractObject)item.getData());
            this.createChildren((Widget)item);
            item.setExpanded(true);
        }
    }

    protected void handleTreeExpand(TreeEvent event) {
        this.checkAndSyncChildren((AbstractObject)event.item.getData());
        super.handleTreeExpand(event);
    }

    private void checkAndSyncChildren(AbstractObject object) {
        if (!this.objectsFullySync && object instanceof Node && object.hasChildren() && !this.session.areChildrenSynchronized(object.getObjectId())) {
            this.syncChildren(object);
        }
    }

    private void syncChildren(final AbstractObject object) {
        ConsoleJob job = new ConsoleJob("Synchronize node components", null, "org.netxms.ui.eclipse.objectbrowser", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ObjectTreeViewer.this.session.syncChildren(object);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectTreeViewer.this.refresh(object);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot synchronize node components";
            }
        };
        job.setUser(false);
        job.start();
    }
}

