/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Sensor;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.dialogs.HistoricalDataSelectionDialog;
import org.netxms.ui.eclipse.perfview.views.helpers.HistoricalDataComparator;
import org.netxms.ui.eclipse.perfview.views.helpers.HistoricalDataLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class HistoricalDataView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.HistoricalDataView";
    public static final int COLUMN_TIME = 0;
    public static final int COLUMN_DATA = 1;
    private NXCSession session;
    private long nodeId;
    private long dciId;
    private String nodeName;
    private String tableName;
    private String instance;
    private String column;
    private boolean tableCellHistory;
    private SortableTableViewer viewer;
    private Date timeFrom = null;
    private Date timeTo = null;
    private int recordLimit = 4096;
    private boolean updateInProgress = false;
    private Action actionRefresh;
    private Action actionSelectRange;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionDeleteDciEntry;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.nodeId = Long.parseLong(parts[0]);
        AbstractObject object = this.session.findObjectById(this.nodeId);
        if (object == null || !(object instanceof AbstractNode) && !(object instanceof MobileDevice) && !(object instanceof Cluster) && !(object instanceof Sensor)) {
            Messages.get();
            throw new PartInitException(Messages.HistoricalDataView_InvalidObjectID);
        }
        this.nodeName = object.getObjectName();
        if (parts[1].contains("@")) {
            String[] subparts = parts[1].split("@");
            this.tableCellHistory = true;
            try {
                this.dciId = Long.parseLong(subparts[0]);
                this.tableName = URLDecoder.decode(subparts[1], "UTF-8");
                this.instance = URLDecoder.decode(subparts[2], "UTF-8");
                this.column = URLDecoder.decode(subparts[3], "UTF-8");
            }
            catch (UnsupportedEncodingException | NumberFormatException e) {
                Activator.logError("Invalid view secondary ID", e);
            }
        } else {
            this.dciId = Long.parseLong(parts[1]);
        }
        this.setPartName(String.valueOf(this.nodeName) + ": [" + (this.tableName == null ? Long.toString(this.dciId) : this.tableName) + "]");
    }

    public void createPartControl(Composite parent) {
        String[] stringArray;
        if (this.tableName != null) {
            String[] stringArray2 = new String[2];
            Messages.get();
            stringArray2[0] = Messages.HistoricalDataView_ColTimestamp;
            stringArray = stringArray2;
            Messages.get();
            stringArray2[1] = Messages.HistoricalDataView_ColValue;
        } else {
            String[] stringArray3 = new String[3];
            Messages.get();
            stringArray3[0] = Messages.HistoricalDataView_ColTimestamp;
            Messages.get();
            stringArray3[1] = Messages.HistoricalDataView_ColValue;
            stringArray = stringArray3;
            stringArray3[2] = "Raw value";
        }
        String[] names = stringArray;
        int[] widths = new int[]{150, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HistoricalDataLabelProvider());
        this.viewer.setComparator((ViewerComparator)new HistoricalDataComparator());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshData();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                HistoricalDataView.this.refreshData();
            }
        };
        Messages.get();
        this.actionSelectRange = new Action(Messages.HistoricalDataView_SelectDataRange){

            public void run() {
                HistoricalDataView.this.selectRange();
            }
        };
        this.actionDeleteDciEntry = new Action("Delete value"){

            public void run() {
                HistoricalDataView.this.deleteValue();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSelectRange);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoricalDataView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeleteDciEntry);
        manager.add((IAction)this.actionSelectRange);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        new ConsoleJob(Messages.HistoricalDataView_RefreshJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciData data = HistoricalDataView.this.tableCellHistory ? HistoricalDataView.this.session.getCollectedTableData(HistoricalDataView.this.nodeId, HistoricalDataView.this.dciId, HistoricalDataView.this.instance, HistoricalDataView.this.column, HistoricalDataView.this.timeFrom, HistoricalDataView.this.timeTo, HistoricalDataView.this.recordLimit) : HistoricalDataView.this.session.getCollectedData(HistoricalDataView.this.nodeId, HistoricalDataView.this.dciId, HistoricalDataView.this.timeFrom, HistoricalDataView.this.timeTo, HistoricalDataView.this.recordLimit, HistoricalDataType.RAW_AND_PROCESSED);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).HistoricalDataView.this.viewer.setInput((Object)data.getValues());
                        (this).HistoricalDataView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.HistoricalDataView_RefreshJobError, HistoricalDataView.this.nodeName, HistoricalDataView.this.dciId);
            }
        }.start();
    }

    private void selectRange() {
        HistoricalDataSelectionDialog dlg = new HistoricalDataSelectionDialog(this.getSite().getShell(), this.recordLimit, this.timeFrom, this.timeTo);
        if (dlg.open() == 0) {
            this.recordLimit = dlg.getMaxRecords();
            this.timeFrom = dlg.getTimeFrom();
            this.timeTo = dlg.getTimeTo();
            this.refreshData();
        }
    }

    private void deleteValue() {
        final IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        new ConsoleJob("Delete DCI entry", null, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List list = selection.toList();
                for (DciDataRow r : list) {
                    HistoricalDataView.this.session.deleteDciEntry(HistoricalDataView.this.nodeId, HistoricalDataView.this.dciId, r.getTimestamp().getTime() / 1000L);
                }
                final DciData data = HistoricalDataView.this.tableCellHistory ? HistoricalDataView.this.session.getCollectedTableData(HistoricalDataView.this.nodeId, HistoricalDataView.this.dciId, HistoricalDataView.this.instance, HistoricalDataView.this.column, HistoricalDataView.this.timeFrom, HistoricalDataView.this.timeTo, HistoricalDataView.this.recordLimit) : HistoricalDataView.this.session.getCollectedData(HistoricalDataView.this.nodeId, HistoricalDataView.this.dciId, HistoricalDataView.this.timeFrom, HistoricalDataView.this.timeTo, HistoricalDataView.this.recordLimit, HistoricalDataType.RAW_AND_PROCESSED);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).HistoricalDataView.this.viewer.setInput((Object)data.getValues());
                        (this).HistoricalDataView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete DCI entry";
            }
        }.start();
    }
}

