/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.UserSelectionDialog;

public class Members
extends PropertyPage {
    private TableViewer userList;
    private NXCSession session;
    private UserGroup object;
    private HashMap<Long, AbstractUserObject> members = new HashMap(0);

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (UserGroup)this.getElement().getAdapter(UserGroup.class);
        if (this.object.getId() == 0x40000000L) {
            GridLayout layout = new GridLayout();
            dialogArea.setLayout((Layout)layout);
            Label label = new Label(dialogArea, 0x1000040);
            label.setText("This built-in group contains all the users in the system and\nis populated automatically. You can\u00e2\u20ac\u2122t add or remove users here.");
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.userList = new TableViewer(dialogArea, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.userList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((AbstractUserObject)e1).getName().compareToIgnoreCase(((AbstractUserObject)e2).getName());
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.Members_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                UserSelectionDialog dlg = new UserSelectionDialog(Members.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        Members.this.members.put(user.getId(), user);
                        ++n2;
                    }
                    Members.this.userList.setInput((Object)Members.this.members.values().toArray(new AbstractUserObject[Members.this.members.size()]));
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.Members_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)Members.this.userList.getSelection();
                for (AbstractUserObject element : sel) {
                    Members.this.members.remove(element.getId());
                }
                Members.this.userList.setInput((Object)Members.this.members.values().toArray());
            }
        });
        this.userList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!Members.this.userList.getSelection().isEmpty());
            }
        });
        long[] lArray = this.object.getMembers();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            AbstractUserObject user = this.session.findUserDBObjectById(userId, null);
            if (user != null) {
                this.members.put(user.getId(), user);
            }
            ++n2;
        }
        this.userList.setInput((Object)this.members.values().toArray());
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long[] memberIds = new long[this.members.size()];
        int i = 0;
        for (Long id : this.members.keySet()) {
            memberIds[i++] = id;
        }
        this.object.setMembers(memberIds);
        Messages.get();
        new ConsoleJob(Messages.Members_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Members.this.session.modifyUserDBObject((AbstractUserObject)Members.this.object, 32);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Members_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Members.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

