/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectCategorySelectionDialog
extends Dialog {
    private TableViewer viewer;
    private int categoryId = 0;

    public ObjectCategorySelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Object Category");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Available categories");
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ObjectCategory)e1).getName().compareToIgnoreCase(((ObjectCategory)e2).getName());
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ObjectCategory)element).getName();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectCategorySelectionDialog.this.okPressed();
            }
        });
        this.viewer.setInput((Object)ConsoleSharedData.getSession().getObjectCategories().toArray());
        GridData gd = new GridData();
        gd.widthHint = 500;
        gd.heightHint = 300;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        this.categoryId = selection.isEmpty() ? 0 : ((ObjectCategory)selection.getFirstElement()).getId();
        super.okPressed();
    }

    public int getCategoryId() {
        return this.categoryId;
    }
}

