/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCompressionMode;
import org.netxms.client.constants.CertificateMappingMethod;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.PasswordInputField;

public class Agent
extends PropertyPage {
    private AbstractNode node;
    private LabeledText agentPort;
    private PasswordInputField agentSharedSecret;
    private Button agentForceEncryption;
    private Button agentTunnelOnly;
    private ObjectSelector agentProxy;
    private Button radioAgentCompressionDefault;
    private Button radioAgentCompressionEnabled;
    private Button radioAgentCompressionDisabled;
    private Combo certMappingMethod;
    private LabeledText certMappingData;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        FormLayout dialogLayout = new FormLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.spacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        this.agentPort = new LabeledText(dialogArea, 0);
        Messages.get();
        this.agentPort.setLabel(Messages.Communication_TCPPort);
        this.agentPort.setText(Integer.toString(this.node.getAgentPort()));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentPort.setLayoutData((Object)fd);
        this.agentProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.agentProxy.setLabel(Messages.Communication_Proxy);
        this.agentProxy.setObjectId(this.node.getAgentProxyId());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentPort, 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentProxy.setLayoutData((Object)fd);
        this.agentForceEncryption = new Button(dialogArea, 32);
        Messages.get();
        this.agentForceEncryption.setText(Messages.Communication_ForceEncryption);
        this.agentForceEncryption.setSelection((this.node.getFlags() & 0x400000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentPort, 0, 1024);
        this.agentForceEncryption.setLayoutData((Object)fd);
        this.agentTunnelOnly = new Button(dialogArea, 32);
        this.agentTunnelOnly.setText("Agent connections through &tunnel only");
        this.agentTunnelOnly.setSelection((this.node.getFlags() & 0x1000000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        this.agentTunnelOnly.setLayoutData((Object)fd);
        this.agentSharedSecret = new PasswordInputField(dialogArea, 0);
        Messages.get();
        this.agentSharedSecret.setLabel(Messages.Communication_SharedSecret);
        this.agentSharedSecret.setText(this.node.getAgentSharedSecret());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentTunnelOnly, 0, 1024);
        this.agentSharedSecret.setLayoutData((Object)fd);
        Group agentCompressionGroup = new Group(dialogArea, 0);
        agentCompressionGroup.setText("Protocol compression mode");
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        agentCompressionGroup.setLayout((Layout)layout);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentSharedSecret, 0, 1024);
        agentCompressionGroup.setLayoutData((Object)fd);
        this.radioAgentCompressionDefault = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionDefault.setText("Default");
        this.radioAgentCompressionDefault.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.DEFAULT);
        this.radioAgentCompressionEnabled = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionEnabled.setText("Enabled");
        this.radioAgentCompressionEnabled.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.ENABLED);
        this.radioAgentCompressionDisabled = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionDisabled.setText("Disabled");
        this.radioAgentCompressionDisabled.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.DISABLED);
        Group certificateMappingGroup = new Group(dialogArea, 0);
        certificateMappingGroup.setText("Certificate mapping");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        certificateMappingGroup.setLayout((Layout)layout);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)agentCompressionGroup, 0, 1024);
        certificateMappingGroup.setLayoutData((Object)fd);
        this.certMappingMethod = WidgetHelper.createLabeledCombo((Composite)certificateMappingGroup, (int)12, (String)"Method", (Object)new GridData(4, 1024, false, false));
        this.certMappingMethod.add("Subject");
        this.certMappingMethod.add("Public key");
        this.certMappingMethod.add("Common name");
        this.certMappingMethod.add("Template ID");
        this.certMappingMethod.select(this.node.getAgentCertificateMappingMethod().getValue());
        this.certMappingData = new LabeledText((Composite)certificateMappingGroup, 0);
        this.certMappingData.setLabel("Mapping data");
        if (this.node.getAgentCertificateMappingData() != null) {
            this.certMappingData.setText(this.node.getAgentCertificateMappingData());
        }
        this.certMappingData.setLayoutData((Object)new GridData(4, 1024, true, false));
        return dialogArea;
    }

    private AgentCompressionMode collectAgentCompressionMode() {
        if (this.radioAgentCompressionEnabled.getSelection()) {
            return AgentCompressionMode.ENABLED;
        }
        if (this.radioAgentCompressionDisabled.getSelection()) {
            return AgentCompressionMode.DISABLED;
        }
        return AgentCompressionMode.DEFAULT;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setAgentPort(Integer.parseInt(this.agentPort.getText(), 10));
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)Messages.Communication_WarningInvalidAgentPort);
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setAgentProxy(this.agentProxy.getObjectId());
        md.setAgentSecret(this.agentSharedSecret.getText().trim());
        md.setAgentCompressionMode(this.collectAgentCompressionMode());
        md.setObjectFlags((this.agentForceEncryption.getSelection() ? 0x400000 : 0) | (this.agentTunnelOnly.getSelection() ? 0x1000000 : 0), 0x1400000);
        md.setCertificateMapping(CertificateMappingMethod.getByValue((int)this.certMappingMethod.getSelectionIndex()), this.certMappingData.getText().trim());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating agent communication settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update agent communication settings for node %s", Agent.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Agent.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentPort.setText("4700");
        this.agentForceEncryption.setSelection(false);
        this.agentProxy.setObjectId(0L);
        this.agentSharedSecret.setText("");
        this.certMappingMethod.select(CertificateMappingMethod.COMMON_NAME.getValue());
        this.certMappingData.setText("");
    }
}

