/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.ResponsibleUser;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Activator;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.dialogs.UserSelectionDialog;

public class ResponsibleUsers
extends PropertyPage {
    private AbstractObject object;
    private TableViewer viewer;
    private Map<Long, ResponsibleUserInfo> users = new HashMap<Long, ResponsibleUserInfo>();
    private NXCSession session = ConsoleSharedData.getSession();

    protected Control createContents(Composite parent) {
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        for (ResponsibleUser r : this.object.getResponsibleUsers()) {
            this.users.put(r.userId, new ResponsibleUserInfo(r));
        }
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResponsibleUsersLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ResponsibleUserInfo)e1).getName().compareToIgnoreCase(((ResponsibleUserInfo)e2).getName());
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn column = new TableColumn(this.viewer.getTable(), 0);
        column.setText("User");
        column.setWidth(300);
        column = new TableColumn(this.viewer.getTable(), 0);
        column.setText("Tag");
        column.setWidth(120);
        final ArrayList<String> tags = new ArrayList<String>(this.session.getResponsibleUserTags());
        tags.add("");
        tags.sort(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        this.viewer.setColumnProperties(new String[]{"name", "tag"});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new ComboBoxCellEditor((Composite)this.viewer.getTable(), tags.toArray(new String[tags.size()]), 12);
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                int index;
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (property.equals("tag") && (index = ((Integer)value).intValue()) >= 0) {
                    ((ResponsibleUserInfo)element).tag = (String)tags.get(index);
                    ResponsibleUsers.this.viewer.update(element, new String[]{property});
                }
            }

            public Object getValue(Object element, String property) {
                return tags.indexOf(((ResponsibleUserInfo)element).tag);
            }

            public boolean canModify(Object element, String property) {
                return property.equals("tag");
            }
        });
        this.viewer.setInput((Object)this.users.values().toArray());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText("Add...");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                UserSelectionDialog dlg = new UserSelectionDialog(ResponsibleUsers.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        ResponsibleUsers.this.users.put(user.getId(), new ResponsibleUserInfo(user));
                        ++n2;
                    }
                    ResponsibleUsers.this.viewer.setInput((Object)ResponsibleUsers.this.users.values().toArray());
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        deleteButton.setText("Delete");
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ResponsibleUsers.this.viewer.getStructuredSelection();
                for (Object o : selection.toList()) {
                    ResponsibleUsers.this.users.remove(((ResponsibleUserInfo)o).userId);
                }
                ResponsibleUsers.this.viewer.setInput((Object)ResponsibleUsers.this.users.values().toArray());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        ConsoleJob job = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.objectmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                HashSet<Long> uids = new HashSet<Long>();
                for (ResponsibleUser r : ResponsibleUsers.this.object.getResponsibleUsers()) {
                    uids.add(r.userId);
                }
                if (ResponsibleUsers.this.session.syncMissingUsers(uids)) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).ResponsibleUsers.this.users.clear();
                            for (ResponsibleUser r : (this).ResponsibleUsers.this.object.getResponsibleUsers()) {
                                (this).ResponsibleUsers.this.users.put(r.userId, new ResponsibleUserInfo(r));
                            }
                            (this).ResponsibleUsers.this.viewer.setInput((Object)(this).ResponsibleUsers.this.users.values().toArray());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        ArrayList<ResponsibleUser> list = new ArrayList<ResponsibleUser>(this.users.size());
        for (ResponsibleUserInfo ri : this.users.values()) {
            list.add(new ResponsibleUser(ri.userId, ri.tag));
        }
        md.setResponsibleUsers(list);
        Messages.get();
        new ConsoleJob(String.format(Messages.AccessControl_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ResponsibleUsers.this.session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ResponsibleUsers.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AccessControl_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.users.clear();
        this.viewer.setInput((Object)new AbstractUserObject[0]);
    }

    private class ResponsibleUserInfo {
        long userId;
        AbstractUserObject user;
        String tag;

        ResponsibleUserInfo(ResponsibleUser r) {
            this.userId = r.userId;
            this.user = ResponsibleUsers.this.session.findUserDBObjectById(this.userId, null);
            this.tag = r.tag;
        }

        public ResponsibleUserInfo(AbstractUserObject user) {
            this.userId = user.getId();
            this.user = user;
            this.tag = "";
        }

        public String getName() {
            return this.user != null ? this.user.getName() : "[" + this.userId + "]";
        }

        public String getLabel() {
            return this.user != null ? this.user.getLabel() : "[" + this.userId + "]";
        }
    }

    private static class ResponsibleUsersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image imageUser = Activator.getImageDescriptor("icons/user.png").createImage();
        private Image imageGroup = Activator.getImageDescriptor("icons/group.png").createImage();

        private ResponsibleUsersLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            ResponsibleUserInfo r = (ResponsibleUserInfo)element;
            return r.user != null ? (r.user instanceof UserGroup ? this.imageGroup : this.imageUser) : SharedIcons.IMG_UNKNOWN_OBJECT;
        }

        public String getColumnText(Object element, int columnIndex) {
            ResponsibleUserInfo r = (ResponsibleUserInfo)element;
            return columnIndex == 0 ? r.getLabel() : r.tag;
        }

        public void dispose() {
            this.imageUser.dispose();
            this.imageGroup.dispose();
            super.dispose();
        }
    }
}

