/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.widgets;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.widgets.helpers.SnmpTrapMonitorFilter;
import org.netxms.ui.eclipse.snmp.widgets.helpers.SnmpTrapMonitorLabelProvider;
import org.netxms.ui.eclipse.widgets.AbstractTraceWidget;

public class SnmpTrapTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE_IP = 1;
    public static final int COLUMN_SOURCE_NODE = 2;
    public static final int COLUMN_OID = 3;
    public static final int COLUMN_VARBINDS = 4;
    private NXCSession session = ConsoleSharedData.getSession();
    private SnmpTrapMonitorFilter filter;

    public SnmpTrapTraceWidget(Composite parent, int style, IViewPart viewPart) {
        super(parent, style, viewPart);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SnmpTrapTraceWidget.this.session.removeListener((SessionListener)SnmpTrapTraceWidget.this);
            }
        });
    }

    protected void setupViewer(TableViewer viewer) {
        Messages.get();
        this.addColumn(Messages.SnmpTrapMonitor_ColTime, 150);
        Messages.get();
        this.addColumn(Messages.SnmpTrapMonitor_ColSourceIP, 120);
        Messages.get();
        this.addColumn(Messages.SnmpTrapMonitor_ColSourceNode, 200);
        Messages.get();
        this.addColumn(Messages.SnmpTrapMonitor_ColOID, 200);
        Messages.get();
        this.addColumn(Messages.SnmpTrapMonitor_ColVarbinds, 600);
        viewer.setLabelProvider((IBaseLabelProvider)new SnmpTrapMonitorLabelProvider());
        this.filter = new SnmpTrapMonitorFilter();
        this.setFilter(this.filter);
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "SnmpTrapMonitor";
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 8) {
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    SnmpTrapTraceWidget.this.addElement(n.getObject());
                }
            });
        }
    }

    public void setRootObject(long objectId) {
        this.filter.setRootObject(objectId);
        this.refresh();
    }
}

