/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary;

import java.util.UUID;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;

public class LoginListener
implements ConsoleLoginListener {
    public void afterLogin(final NXCSession session, final Display display) {
        ImageProvider.createInstance(display, session);
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageProvider.getInstance().syncMetaData();
                    session.addListener((SessionListener)new ImageLibraryListener(display, session));
                }
                catch (Exception e) {
                    Activator.logError("Exception in login listener worker thread", e);
                }
            }
        }, "");
        worker.setDaemon(true);
        worker.start();
    }

    private final class ImageLibraryListener
    implements SessionListener {
        private ImageLibraryListener(Display display, NXCSession session) {
        }

        public void notificationHandler(SessionNotification n) {
            if (n.getCode() == 11) {
                UUID guid = (UUID)n.getObject();
                ImageProvider imageProvider = ImageProvider.getInstance();
                if (n.getSubCode() == 202L) {
                    imageProvider.deleteImage(guid);
                } else {
                    imageProvider.updateImage(guid);
                }
            }
        }
    }
}

