/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.ui.eclipse.objectview.dialogs.PatchPanelSelectonDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class PatchPanelSelector
extends AbstractSelector {
    private Rack rack;
    private long patchPanelId = 0L;
    private String patchPanelName = null;

    public PatchPanelSelector(Composite parent, int style, Rack rack) {
        super(parent, style, 0);
        this.setText("None");
        this.rack = rack;
    }

    public void setRack(Rack rack) {
        if (this.rack != rack) {
            this.clearButtonHandler();
        }
        this.rack = rack;
    }

    public PatchPanelSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, (useHyperlink ? 1 : 0) | 8);
        this.setText("None");
    }

    protected void selectionButtonHandler() {
        PatchPanelSelectonDialog dlg = new PatchPanelSelectonDialog(this.getShell(), this.rack);
        if (dlg.open() == 0) {
            long prevPatchPanelId = this.patchPanelId;
            long id = dlg.getPatchPanelId();
            if (id != 0L) {
                this.patchPanelId = id;
                PassiveRackElement element = this.rack.getPassiveElement(id);
                this.patchPanelName = this.rack.getPassiveElement(id).toString();
                this.setText(this.patchPanelName);
                this.getTextControl().setToolTipText(this.generateToolTipText(element));
            } else {
                this.patchPanelId = 0L;
                this.patchPanelName = null;
                this.setText("None");
                this.getTextControl().setToolTipText(null);
            }
            if (prevPatchPanelId != this.patchPanelId) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.patchPanelId == 0L) {
            return;
        }
        this.patchPanelId = 0L;
        this.patchPanelName = null;
        this.setText("None");
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public long getPatchPanelId() {
        return this.patchPanelId;
    }

    public String getPatchPanelName() {
        return this.patchPanelName;
    }

    public void setPatchPanelId(long patchPanelId) {
        if (this.patchPanelId == patchPanelId) {
            return;
        }
        this.patchPanelId = patchPanelId;
        if (patchPanelId != 0L) {
            PassiveRackElement element = this.rack.getPassiveElement(patchPanelId);
            if (element != null) {
                this.patchPanelName = element.toString();
                this.setText(this.patchPanelName);
                this.getTextControl().setToolTipText(this.generateToolTipText(element));
            } else {
                this.setText("Unknown");
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            this.setText("None");
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
        this.fireModifyListeners();
    }

    private String generateToolTipText(PassiveRackElement element) {
        StringBuilder sb = new StringBuilder(element.getName());
        sb.append(" [");
        sb.append(element.getId());
        sb.append("]\n\n");
        sb.append("Position: ");
        sb.append(element.getPosition());
        sb.append("\nOrientation:");
        sb.append(element.getOrientation().toString());
        return sb.toString();
    }

    protected String getSelectionButtonToolTip() {
        return "Patch panel selector";
    }
}

