/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class MaintenanceJournalEntry {
    private long id;
    private long objectId;
    private long author;
    private long lastEditedBy;
    private String description;
    private Date creationTime;
    private Date modificationTime;

    public MaintenanceJournalEntry(NXCPMessage msg, long base) {
        this.id = msg.getFieldAsInt32(base);
        this.objectId = msg.getFieldAsInt32(base + 1L);
        this.author = msg.getFieldAsInt32(base + 2L);
        this.lastEditedBy = msg.getFieldAsInt32(base + 3L);
        this.description = msg.getFieldAsString(base + 4L);
        this.creationTime = msg.getFieldAsDate(base + 5L);
        this.modificationTime = msg.getFieldAsDate(base + 6L);
    }

    public long getId() {
        return this.id;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getAuthor() {
        return this.author;
    }

    public long getLastEditedBy() {
        return this.lastEditedBy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionShort() {
        int firstLineEnd = this.description.indexOf(10);
        int shortLineEnd = firstLineEnd < 0 ? 64 : (firstLineEnd >= 64 ? 64 : firstLineEnd);
        return shortLineEnd >= this.description.length() ? this.description : String.valueOf(this.description.substring(0, shortLineEnd)) + "...";
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }
}

