/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Date;
import java.util.Set;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.client.sensor.configs.DlmsConfig;
import org.netxms.client.sensor.configs.LoraWanConfig;
import org.netxms.client.sensor.configs.LoraWanRegConfig;
import org.netxms.client.sensor.configs.SensorConfig;
import org.netxms.client.sensor.configs.SensorRegistrationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sensor
extends DataCollectionTarget
implements PollingTarget {
    public static final int SENSOR_PROVISIONED = 65536;
    public static final int SENSOR_REGISTERED = 131072;
    public static final int SENSOR_ACTIVE = 262144;
    public static final int SENSOR_CONF_UPDATE_PENDING = 524288;
    public static final int SENSOR_PROTO_UNKNOWN = 0;
    public static final int COMM_LORAWAN = 1;
    public static final int COMM_DLMS = 2;
    public static final String[] COMM_METHOD = new String[]{"Unknown", "LoRaWAN", "DLMS"};
    public static final int SENSOR_CLASS_UNKNOWN = 0;
    public static final int SENSOR_UPS = 1;
    public static final int SENSOR_WATER_METER = 2;
    public static final int SENSOR_ELECTR_METER = 3;
    public static final String[] DEV_CLASS_NAMES = new String[]{"Unknown", "UPS", "Water meter", "Electricity meter"};
    private static final Logger logger = LoggerFactory.getLogger(Sensor.class);
    protected MacAddress macAddress;
    private int deviceClass;
    private String vendor;
    private int commProtocol;
    private SensorRegistrationConfig regConfig;
    private SensorConfig config;
    private String serialNumber;
    private String deviceAddress;
    private String metaType;
    private String description;
    private Date lastConnectionTime;
    private int frameCount;
    private int signalStrenght;
    private int signalNoise;
    private int frequency;
    private long proxyId;

    public Sensor(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.macAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.deviceClass = msg.getFieldAsInt32(582L);
        this.vendor = msg.getFieldAsString(428L);
        this.commProtocol = msg.getFieldAsInt32(583L);
        this.setXmlRegConfig(msg.getFieldAsString(593L));
        this.setXmlConfig(msg.getFieldAsString(584L));
        this.serialNumber = msg.getFieldAsString(432L);
        this.deviceAddress = msg.getFieldAsString(585L);
        this.metaType = msg.getFieldAsString(586L);
        this.description = msg.getFieldAsString(27L);
        this.lastConnectionTime = msg.getFieldAsDate(587L);
        this.frameCount = msg.getFieldAsInt32(588L);
        this.signalStrenght = msg.getFieldAsInt32(589L);
        this.signalNoise = msg.getFieldAsInt32(590L);
        this.frequency = msg.getFieldAsInt32(591L);
        this.proxyId = msg.getFieldAsInt32(592L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    @Override
    public String getObjectClassName() {
        return "Sensor";
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Sensor.addString(strings, this.macAddress.toString());
        Sensor.addString(strings, this.vendor);
        Sensor.addString(strings, this.serialNumber);
        Sensor.addString(strings, this.deviceAddress);
        Sensor.addString(strings, this.metaType);
        Sensor.addString(strings, this.description);
        return strings;
    }

    private void setXmlRegConfig(String xml) {
        switch (this.commProtocol) {
            case 1: {
                try {
                    this.regConfig = SensorRegistrationConfig.createFromXml(LoraWanRegConfig.class, xml);
                }
                catch (Exception e) {
                    this.regConfig = new LoraWanRegConfig();
                    logger.debug("Cannot create LoraWanRegConfig object from XML document", (Throwable)e);
                }
                break;
            }
            default: {
                this.config = null;
            }
        }
    }

    private void setXmlConfig(String xml) {
        switch (this.commProtocol) {
            case 1: {
                try {
                    this.config = SensorConfig.createFromXml(LoraWanConfig.class, xml);
                }
                catch (Exception e) {
                    this.config = new LoraWanConfig();
                    logger.debug("Cannot create LoraWanConfig object from XML document", (Throwable)e);
                }
                break;
            }
            case 2: {
                try {
                    this.config = SensorConfig.createFromXml(DlmsConfig.class, xml);
                }
                catch (Exception e) {
                    this.config = new DlmsConfig();
                }
                break;
            }
            default: {
                this.config = null;
            }
        }
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getSignalStrenght() {
        return this.signalStrenght;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getDeviceClass() {
        return this.deviceClass;
    }

    public int getCommProtocol() {
        return this.commProtocol;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getLastConnectionTime() {
        return this.lastConnectionTime;
    }

    public long getProxyId() {
        return this.proxyId;
    }

    public int getSignalNoise() {
        return this.signalNoise;
    }

    public SensorRegistrationConfig getRegConfig() {
        return this.regConfig;
    }

    public SensorConfig getConfig() {
        return this.config;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }
}

