/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;

public class ServerScriptResults
extends AbstractCommandResults {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ServerScriptResults";
    private String lastScript = null;
    private Action actionRestart;
    private Map<String, String> lastInputValues = null;
    private long alarmId;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                ServerScriptResults.this.executeScript(ServerScriptResults.this.lastScript, ServerScriptResults.this.alarmId, ServerScriptResults.this.lastInputValues);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeScript(final String script, final long alarmId, final Map<String, String> inputValues) {
        this.actionRestart.setEnabled(false);
        this.createOutputStream();
        this.lastScript = script;
        this.alarmId = alarmId;
        this.lastInputValues = inputValues;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, this.session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, ServerScriptResults.this.session.getObjectName(ServerScriptResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    ServerScriptResults.this.session.executeLibraryScript(ServerScriptResults.this.nodeId, alarmId, script, inputValues, ServerScriptResults.this.getOutputListener());
                }
                finally {
                    ServerScriptResults.this.closeOutputStream();
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ServerScriptResults.this.actionRestart.setEnabled(true);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

