/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.widgets.helpers.ConnectionPointComparator;
import org.netxms.ui.eclipse.topology.widgets.helpers.ConnectionPointLabelProvider;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SearchResult
extends CompositeWithMessageBar {
    public static final int COLUMN_SEQUENCE = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_MAC_ADDRESS = 3;
    public static final int COLUMN_NIC_VENDOR = 4;
    public static final int COLUMN_IP_ADDRESS = 5;
    public static final int COLUMN_SWITCH = 6;
    public static final int COLUMN_PORT = 7;
    public static final int COLUMN_TYPE = 8;
    private ViewPart viewPart;
    private SortableTableViewer viewer;
    private List<ConnectionPoint> results = new ArrayList<ConnectionPoint>();
    private Action actionClearLog;
    private Action actionCopyMAC;
    private Action actionCopyIP;
    private Action actionCopyRecord;

    public SearchResult(ViewPart viewPart, Composite parent, int style, final String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        String[] stringArray = new String[9];
        Messages.get();
        stringArray[0] = Messages.HostSearchResults_ColSeq;
        Messages.get();
        stringArray[1] = Messages.HostSearchResults_ColNode;
        Messages.get();
        stringArray[2] = Messages.HostSearchResults_ColIface;
        Messages.get();
        stringArray[3] = Messages.HostSearchResults_ColMac;
        stringArray[4] = "NIC vendor";
        Messages.get();
        stringArray[5] = Messages.HostSearchResults_ColIp;
        Messages.get();
        stringArray[6] = Messages.HostSearchResults_ColSwitch;
        Messages.get();
        stringArray[7] = Messages.HostSearchResults_ColPort;
        Messages.get();
        stringArray[8] = Messages.HostSearchResults_ColType;
        String[] names = stringArray;
        int[] widths = new int[]{70, 120, 120, 180, 90, 90, 120, 120, 60};
        this.viewer = new SortableTableViewer(this.getContent(), names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ConnectionPointLabelProvider labelProvider = new ConnectionPointLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ConnectionPointComparator(labelProvider));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)SearchResult.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
            }
        });
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        Messages.get();
        this.actionClearLog = new Action(Messages.HostSearchResults_ClearLog){

            public void run() {
                SearchResult.this.results.clear();
                SearchResult.this.viewer.setInput((Object)SearchResult.this.results.toArray());
            }
        };
        this.actionClearLog.setImageDescriptor(SharedIcons.CLEAR_LOG);
        Messages.get();
        this.actionCopyIP = new Action(Messages.HostSearchResults_CopyIp){

            public void run() {
                SearchResult.this.copyToClipboard(5);
            }
        };
        Messages.get();
        this.actionCopyMAC = new Action(Messages.HostSearchResults_CopyMac){

            public void run() {
                SearchResult.this.copyMacAddress();
            }
        };
        Messages.get();
        this.actionCopyRecord = new Action(Messages.HostSearchResults_Copy, SharedIcons.COPY){

            public void run() {
                SearchResult.this.copyToClipboard(-1);
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SearchResult.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void copyMacAddress() {
        List selection = this.viewer.getStructuredSelection().toList();
        if (selection.size() > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.size()) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(((ConnectionPoint)selection.get(i)).getLocalMacAddress().toString());
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    int j = 0;
                    while (j < this.viewer.getTable().getColumnCount()) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public boolean setFocus() {
        return this.viewer.getTable().setFocus();
    }

    public void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    public void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    private void addResult(ConnectionPoint cp) {
        cp.setData((Object)this.results.size());
        this.results.add(cp);
        this.viewer.setInput((Object)this.results.toArray());
    }

    private void clearResults() {
        this.results.clear();
        this.viewer.setInput((Object)new Object[0]);
        this.hideMessage();
    }

    public void showConnection(final ConnectionPoint cp) {
        this.clearResults();
        if (cp == null) {
            Messages.get();
            this.showMessage(1, Messages.HostSearchResults_NotFound);
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        if (session.areChildrenSynchronized(cp.getNodeId()) && session.areChildrenSynchronized(cp.getLocalNodeId())) {
            this.showConnectionStep2(session, cp);
        } else {
            new ConsoleJob("Synchronize objects", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.topology", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    AbstractObject object = session.findObjectById(cp.getNodeId());
                    if (object != null) {
                        session.syncChildren(object);
                    }
                    if ((object = session.findObjectById(cp.getLocalNodeId())) != null) {
                        session.syncChildren(object);
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SearchResult.this.showConnectionStep2(session, cp);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot synchronize objects";
                }
            }.start();
        }
    }

    private void showConnectionStep2(NXCSession session, ConnectionPoint cp) {
        try {
            Node host = (Node)session.findObjectById(cp.getLocalNodeId());
            Node bridge = (Node)session.findObjectById(cp.getNodeId());
            AbstractObject iface = session.findObjectById(cp.getInterfaceId());
            if (bridge != null && iface != null) {
                if (cp.getType() == ConnectionPointType.WIRELESS) {
                    if (host != null) {
                        Messages.get();
                        this.showMessage(0, String.format(Messages.HostSearchResults_NodeConnectedToWiFi, host.getObjectName(), bridge.getObjectName(), iface.getObjectName()));
                    } else if (cp.getLocalIpAddress() != null) {
                        Messages.get();
                        this.showMessage(0, String.format(Messages.HostSearchResults_NodeIpMacConnectedToWiFi, cp.getLocalIpAddress().getHostAddress(), cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    } else {
                        Messages.get();
                        this.showMessage(0, String.format(Messages.HostSearchResults_NodeMacConnectedToWiFi, cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    }
                } else if (host != null) {
                    String string;
                    Messages.get();
                    Object[] objectArray = new Object[4];
                    objectArray[0] = host.getObjectName();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[1] = string;
                    objectArray[2] = bridge.getObjectName();
                    objectArray[3] = iface.getObjectName();
                    this.showMessage(0, String.format(Messages.HostSearchResults_NodeConnected, objectArray));
                } else if (cp.getLocalIpAddress() != null) {
                    String string;
                    Messages.get();
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cp.getLocalIpAddress().getHostAddress();
                    objectArray[1] = cp.getLocalMacAddress();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[2] = string;
                    objectArray[3] = bridge.getObjectName();
                    objectArray[4] = iface.getObjectName();
                    this.showMessage(0, String.format(Messages.HostSearchResults_NodeIpMacConnected, objectArray));
                } else {
                    String string;
                    Messages.get();
                    Object[] objectArray = new Object[4];
                    objectArray[0] = cp.getLocalMacAddress();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[1] = string;
                    objectArray[2] = bridge.getObjectName();
                    objectArray[3] = iface.getObjectName();
                    this.showMessage(0, String.format(Messages.HostSearchResults_NodeMacConnected, objectArray));
                }
                this.addResult(cp);
            } else if (host != null && cp.getType() == ConnectionPointType.UNKNOWN) {
                this.showMessage(1, String.format("Found node %s but it's connection point is unknown", host.getObjectName()));
                this.addResult(cp);
            } else {
                Messages.get();
                this.showMessage(1, Messages.HostSearchResults_NotFound);
            }
        }
        catch (Exception e) {
            Activator.logError("Exception in host search result view", e);
            Messages.get();
            this.showMessage(1, String.format(Messages.HostSearchResults_ShowError, e.getLocalizedMessage()));
        }
    }

    public void showConnection(final List<ConnectionPoint> cps) {
        this.clearResults();
        final NXCSession session = ConsoleSharedData.getSession();
        if (session.areObjectsSynchronized()) {
            this.showConnectionStep2(session, cps);
        } else {
            new ConsoleJob("Synchronize objects", null, "org.netxms.ui.eclipse.topology", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    for (ConnectionPoint cp : cps) {
                        AbstractObject object = session.findObjectById(cp.getNodeId());
                        if (object != null) {
                            session.syncChildren(object);
                        }
                        if ((object = session.findObjectById(cp.getLocalNodeId())) == null) continue;
                        session.syncChildren(object);
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SearchResult.this.showConnectionStep2(session, cps);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot synchronize objects";
                }
            }.start();
        }
    }

    public void showConnectionStep2(NXCSession session, List<ConnectionPoint> cps) {
        int counter = 0;
        try {
            for (ConnectionPoint p : cps) {
                if (!p.hasConnection()) {
                    ++counter;
                }
                this.addResult(p);
            }
            if (counter > 0) {
                Messages.get();
                this.showMessage(1, String.valueOf(Messages.HostSearchResults_NotFound) + " for " + counter + " interfaces!");
            }
        }
        catch (Exception e) {
            Messages.get();
            this.showMessage(1, String.format(Messages.HostSearchResults_ShowError, e.getLocalizedMessage()));
        }
    }
}

