/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.base.GeoLocation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.views.AbstractGeolocationView;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;
import org.netxms.ui.eclipse.osm.widgets.ObjectGeoLocationViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LocationMap
extends AbstractGeolocationView {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.LocationMap";
    private AbstractObject object;
    private Action actionHideOtherObjects;
    private Action actionShowObjectNames;

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            long id = Long.parseLong(site.getSecondaryId());
            this.object = ConsoleSharedData.getSession().findObjectById(id);
            Messages.get();
            this.setPartName(String.valueOf(Messages.LocationMap_PartNamePrefix) + this.object.getNameWithAlias());
        }
        catch (Exception e) {
            Messages.get();
            throw new PartInitException(Messages.LocationMap_InitError1, (Throwable)e);
        }
        if (this.object == null) {
            Messages.get();
            throw new PartInitException(Messages.LocationMap_InitError2);
        }
    }

    @Override
    protected AbstractGeoMapViewer createMapViewer(Composite parent, int style) {
        ObjectGeoLocationViewer mapViewer = new ObjectGeoLocationViewer(parent, style);
        mapViewer.setShowObjectNames(!Activator.getDefault().getDialogSettings().getBoolean("LocationMap.HideObjectNames"));
        if (Activator.getDefault().getDialogSettings().getBoolean("LocationMap.HideOtherObjects")) {
            mapViewer.setRootObjectId(this.object.getObjectId());
            mapViewer.setSingleObjectMode(true);
        }
        return mapViewer;
    }

    @Override
    protected GeoLocation getInitialCenterPoint() {
        return this.object.getGeolocation();
    }

    @Override
    protected int getInitialZoomLevel() {
        return 15;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.actionHideOtherObjects = new Action("&Hide other objects", 2){

            public void run() {
                Activator.getDefault().getDialogSettings().put("LocationMap.HideOtherObjects", this.isChecked());
                ((ObjectGeoLocationViewer)LocationMap.this.map).setRootObjectId(this.isChecked() ? LocationMap.this.object.getObjectId() : 0L);
                ((ObjectGeoLocationViewer)LocationMap.this.map).setSingleObjectMode(this.isChecked());
                LocationMap.this.map.reloadMap();
            }
        };
        this.actionHideOtherObjects.setImageDescriptor(Activator.getImageDescriptor("icons/hide_other_objects.png"));
        this.actionHideOtherObjects.setChecked(Activator.getDefault().getDialogSettings().getBoolean("LocationMap.HideOtherObjects"));
        this.actionShowObjectNames = new Action("Show object &names", 2){

            public void run() {
                Activator.getDefault().getDialogSettings().put("LocationMap.HideObjectNames", !this.isChecked());
                ((ObjectGeoLocationViewer)LocationMap.this.map).setShowObjectNames(this.isChecked());
                LocationMap.this.map.reloadMap();
            }
        };
        this.actionShowObjectNames.setImageDescriptor(Activator.getImageDescriptor("icons/show_names.png"));
        this.actionShowObjectNames.setChecked(!Activator.getDefault().getDialogSettings().getBoolean("LocationMap.HideObjectNames"));
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionHideOtherObjects);
        manager.add((IAction)this.actionShowObjectNames);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionHideOtherObjects);
        manager.add((IAction)this.actionShowObjectNames);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }
}

